/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.editor.templates.AntTemplateViewerConfiguration;
import org.eclipse.ant.internal.ui.editor.text.AntDocumentSetupParticipant;
import org.eclipse.ant.internal.ui.preferences.AbstractAntEditorPreferencePage;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntPreviewerUpdater;
import org.eclipse.ant.internal.ui.preferences.ColorEditor;
import org.eclipse.ant.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.ant.internal.ui.preferences.TabFolderLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class AntEditorPreferencePage
extends AbstractAntEditorPreferencePage {
    private String[][] fSyntaxColorListModel;
    private final String[][] fAppearanceColorListModel;
    private final String[] fProblemPreferenceKeys;
    private org.eclipse.swt.widgets.List fAppearanceColorList;
    private ColorEditor fAppearanceColorEditor;
    private Button fAppearanceColorDefault;
    private ColorEditor fSyntaxForegroundColorEditor;
    private ColorEditor fBackgroundColorEditor;
    private Button fBackgroundDefaultRadioButton;
    private Button fBackgroundCustomRadioButton;
    private Button fBackgroundColorButton;
    private Button fBoldCheckBox;
    private Button fItalicCheckBox;
    private TableViewer fHighlightingColorListViewer;
    private final List fHighlightingColorList;
    private SourceViewer fPreviewViewer;
    private AntPreviewerUpdater fPreviewerUpdater;
    private SelectionListener fSelectionListener;
    protected Map fWorkingValues;
    protected ArrayList fComboBoxes;

    public AntEditorPreferencePage() {
        String[][] stringArrayArray = new String[5][];
        String[] stringArray = new String[3];
        stringArray[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.lineNumberForegroundColor");
        stringArray[1] = "lineNumberColor";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.currentLineHighlighColor");
        stringArray2[1] = "currentLineColor";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.printMarginColor");
        stringArray3[1] = "printMarginColor";
        stringArrayArray[2] = stringArray3;
        stringArrayArray[3] = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.41"), "AbstractTextEditor.Color.SelectionForeground", "AbstractTextEditor.Color.SelectionForeground.SystemDefault"};
        stringArrayArray[4] = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.42"), "AbstractTextEditor.Color.SelectionBackground", "AbstractTextEditor.Color.SelectionBackground.SystemDefault"};
        this.fAppearanceColorListModel = stringArrayArray;
        this.fProblemPreferenceKeys = new String[]{"problem_classpath", "problem_properties", "problem_imports", "problem_tasks"};
        this.fHighlightingColorList = new ArrayList(5);
        this.setDescription(AntPreferencesMessages.getString("AntEditorPreferencePage.description"));
    }

    protected OverlayPreferenceStore createOverlayStore() {
        String[][] stringArrayArray = new String[5][];
        String[] stringArray = new String[3];
        stringArray[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_text_1");
        stringArray[1] = "org.eclipse.ant.ui.textColor";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_processing_instuctions_2");
        stringArray2[1] = "org.eclipse.ant.ui.processingInstructionsColor";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_constant_strings_3");
        stringArray3[1] = "org.eclipse.ant.ui.constantStringsColor";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_tags_4");
        stringArray4[1] = "org.eclipse.ant.ui.tagsColor";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_comments_5");
        stringArray5[1] = "org.eclipse.ant.ui.commentsColor";
        stringArrayArray[4] = stringArray5;
        this.fSyntaxColorListModel = stringArrayArray;
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionForeground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionForeground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionBackground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionBackground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "tabWidth"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "spaces_for_tabs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "overviewRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoactivation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "content_assist_autoactivation_delay"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoinsert"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "org.eclipse.ant.ui.codeAssistProposalsBackgroundColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "org.eclipse.ant.ui.codeAssistProposalsForegroundColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_autoactivation_triggers_java"));
        int i = 0;
        while (i < this.fSyntaxColorListModel.length) {
            String colorKey = this.fSyntaxColorListModel[i][1];
            this.addTextKeyToCover(overlayKeys, colorKey);
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    private void addTextKeyToCover(ArrayList overlayKeys, String mainKey) {
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, mainKey));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, String.valueOf(mainKey) + "_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, String.valueOf(mainKey) + "_italic"));
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getOverlayStore(), (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
        this.updateAppearanceColorWidgets(this.fAppearanceColorListModel[i][2]);
    }

    private void updateAppearanceColorWidgets(String systemDefaultKey) {
        if (systemDefaultKey == null) {
            this.fAppearanceColorDefault.setSelection(false);
            this.fAppearanceColorDefault.setVisible(false);
            this.fAppearanceColorEditor.getButton().setEnabled(true);
        } else {
            boolean systemDefault = this.getOverlayStore().getBoolean(systemDefaultKey);
            this.fAppearanceColorDefault.setSelection(systemDefault);
            this.fAppearanceColorDefault.setVisible(true);
            this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
        }
    }

    private Control createAppearancePage(Composite parent) {
        Font font = parent.getFont();
        Composite appearanceComposite = new Composite(parent, 0);
        appearanceComposite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.printMarginColumn");
        String[] errorMessages = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.empty_input_print_margin"), AntPreferencesMessages.getString("AntEditorPreferencePage.invalid_input_print_margin")};
        this.addTextField(appearanceComposite, labelText, "printMarginColumn", 3, 0, errorMessages);
        labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.37");
        errorMessages = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.38"), AntPreferencesMessages.getString("AntEditorPreferencePage.39")};
        this.addTextField(appearanceComposite, labelText, "tabWidth", 3, 0, errorMessages);
        labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.40");
        this.addCheckBox(appearanceComposite, labelText, "spaces_for_tabs", 1);
        labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.showOverviewRuler");
        this.addCheckBox(appearanceComposite, labelText, "overviewRuler", 0);
        labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.showLineNumbers");
        this.addCheckBox(appearanceComposite, labelText, "lineNumberRuler", 0);
        labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.highlightCurrentLine");
        this.addCheckBox(appearanceComposite, labelText, "currentLine", 0);
        labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.showPrintMargin");
        this.addCheckBox(appearanceComposite, labelText, "printMargin", 0);
        Label label = new Label(appearanceComposite, 16384);
        label.setFont(font);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gd);
        label = new Label(appearanceComposite, 16384);
        label.setFont(font);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.appearanceOptions"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        editorComposite.setFont(font);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new org.eclipse.swt.widgets.List(editorComposite, 2564);
        this.fAppearanceColorList.setFont(font);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(6);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        stylesComposite.setFont(font);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setFont(font);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.6"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        foregroundColorButton.setFont(font);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AntEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        SelectionListener colorDefaultSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean systemDefault = AntEditorPreferencePage.this.fAppearanceColorDefault.getSelection();
                AntEditorPreferencePage.this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
                int i = AntEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = AntEditorPreferencePage.this.fAppearanceColorListModel[i][2];
                if (key != null) {
                    AntEditorPreferencePage.this.getOverlayStore().setValue(key, systemDefault);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fAppearanceColorDefault = new Button(stylesComposite, 32);
        this.fAppearanceColorDefault.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.0"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fAppearanceColorDefault.setLayoutData((Object)gd);
        this.fAppearanceColorDefault.setVisible(false);
        this.fAppearanceColorDefault.addSelectionListener(colorDefaultSelectionListener);
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AntEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = AntEditorPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AntEditorPreferencePage.this.getOverlayStore(), (String)key, (RGB)AntEditorPreferencePage.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return appearanceComposite;
    }

    protected Control createContents(Composite parent) {
        this.initializeDefaultColors();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ant.ui.ant_editor_preference_page_context");
        this.getOverlayStore().load();
        this.getOverlayStore().start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.general"));
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.1"));
        item.setControl(this.createSyntaxPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.10"));
        item.setControl((Control)this.createProblemsTabContent(folder));
        this.initialize();
        this.applyDialogFont((Composite)folder);
        return folder;
    }

    private void initializeDefaultColors() {
        RGB rgb;
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Background")) {
            rgb = this.getControl().getDisplay().getSystemColor(25).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.getOverlayStore(), (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Foreground")) {
            rgb = this.getControl().getDisplay().getSystemColor(24).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.getOverlayStore(), (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionBackground")) {
            rgb = this.getControl().getDisplay().getSystemColor(26).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.getOverlayStore(), (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionForeground")) {
            rgb = this.getControl().getDisplay().getSystemColor(27).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.getOverlayStore(), (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
        }
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        int n = this.fSyntaxColorListModel.length;
        while (i < n) {
            this.fHighlightingColorList.add(new HighlightingColorListItem(this.fSyntaxColorListModel[i][0], this.fSyntaxColorListModel[i][1], String.valueOf(this.fSyntaxColorListModel[i][1]) + "_bold", String.valueOf(this.fSyntaxColorListModel[i][1]) + "_italic", null));
            ++i;
        }
        this.fHighlightingColorListViewer.setInput((Object)this.fHighlightingColorList);
        this.fHighlightingColorListViewer.setSelection((ISelection)new StructuredSelection(this.fHighlightingColorListViewer.getElementAt(0)));
        i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AntEditorPreferencePage.this.fAppearanceColorList != null && !AntEditorPreferencePage.this.fAppearanceColorList.isDisposed()) {
                    AntEditorPreferencePage.this.fAppearanceColorList.select(0);
                    AntEditorPreferencePage.this.handleAppearanceColorListSelection();
                }
            }
        });
        this.initializeBackgroundColorFields();
    }

    private void initializeBackgroundColorFields() {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getOverlayStore(), (String)"AbstractTextEditor.Color.Background");
        this.fBackgroundColorEditor.setColorValue(rgb);
        boolean dflt = this.getOverlayStore().getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        this.fBackgroundDefaultRadioButton.setSelection(dflt);
        this.fBackgroundCustomRadioButton.setSelection(!dflt);
        this.fBackgroundColorButton.setEnabled(!dflt);
    }

    protected void handleDefaults() {
        this.handleAppearanceColorListSelection();
        this.handleSyntaxColorListSelection();
        this.initializeBackgroundColorFields();
        this.restoreWorkingValuesToDefaults();
    }

    private Control createSyntaxPage(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Group backgroundComposite = new Group(colorComposite, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        backgroundComposite.setLayout((Layout)layout);
        backgroundComposite.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.2"));
        SelectionListener backgroundSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean custom = AntEditorPreferencePage.this.fBackgroundCustomRadioButton.getSelection();
                AntEditorPreferencePage.this.fBackgroundColorButton.setEnabled(custom);
                AntEditorPreferencePage.this.getOverlayStore().setValue("AbstractTextEditor.Color.Background.SystemDefault", !custom);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fBackgroundDefaultRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundDefaultRadioButton.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.3"));
        this.fBackgroundDefaultRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundCustomRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundCustomRadioButton.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.4"));
        this.fBackgroundCustomRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundColorEditor = new ColorEditor((Composite)backgroundComposite);
        this.fBackgroundColorButton = this.fBackgroundColorEditor.getButton();
        Label label = new Label(colorComposite, 16384);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.5"));
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer = new TableViewer(editorComposite, 68100);
        this.fHighlightingColorListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fHighlightingColorListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fHighlightingColorListViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fHighlightingColorListViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.6"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.7"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.8"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.9"));
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AntEditorPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AntEditorPreferencePage.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)AntEditorPreferencePage.this.getOverlayStore(), (String)item.getColorKey(), (RGB)AntEditorPreferencePage.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBackgroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferenceConverter.setValue((IPreferenceStore)AntEditorPreferencePage.this.getOverlayStore(), (String)"AbstractTextEditor.Color.Background", (RGB)AntEditorPreferencePage.this.fBackgroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AntEditorPreferencePage.this.getHighlightingColorListItem();
                AntEditorPreferencePage.this.getOverlayStore().setValue(item.getBoldKey(), AntEditorPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AntEditorPreferencePage.this.getHighlightingColorListItem();
                AntEditorPreferencePage.this.getOverlayStore().setValue(item.getItalicKey(), AntEditorPreferencePage.this.fItalicCheckBox.getSelection());
            }
        });
        return colorComposite;
    }

    private Control createPreviewer(Composite parent) {
        this.fPreviewViewer = new SourceViewer(parent, null, null, false, 2816);
        AntTemplateViewerConfiguration configuration = new AntTemplateViewerConfiguration();
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        this.fPreviewViewer.setEditable(false);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.getOverlayStore(), EditorsUI.getPreferenceStore()});
        this.fPreviewerUpdater = new AntPreviewerUpdater(this.fPreviewViewer, configuration, (IPreferenceStore)store);
        String content = this.loadPreviewContentFromFile("SyntaxPreviewCode.txt");
        Document document = new Document(content);
        new AntDocumentSetupParticipant().setup((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        return this.fPreviewViewer.getControl();
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getOverlayStore(), (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.getOverlayStore().getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getOverlayStore().getBoolean(item.getItalicKey()));
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fHighlightingColorListViewer.getSelection();
        return (HighlightingColorListItem)selection.getFirstElement();
    }

    public void dispose() {
        super.dispose();
        if (this.fPreviewerUpdater != null) {
            this.fPreviewerUpdater.dispose();
        }
    }

    private Composite createProblemsTabContent(TabFolder folder) {
        this.fComboBoxes = new ArrayList();
        this.initializeWorkingValues();
        String[] errorWarningIgnoreLabels = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.11"), AntPreferencesMessages.getString("AntEditorPreferencePage.12"), AntPreferencesMessages.getString("AntEditorPreferencePage.13")};
        String[] errorWarningIgnore = new String[]{"error", "warning", "ignore"};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite othersComposite = new Composite((Composite)folder, 0);
        othersComposite.setLayout((Layout)layout);
        Label description = new Label(othersComposite, 64);
        description.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.14"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        String label = AntPreferencesMessages.getString("AntEditorPreferencePage.18");
        this.addComboBox(othersComposite, label, "problem_tasks", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AntPreferencesMessages.getString("AntEditorPreferencePage.15");
        this.addComboBox(othersComposite, label, "problem_classpath", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AntPreferencesMessages.getString("AntEditorPreferencePage.16");
        this.addComboBox(othersComposite, label, "problem_properties", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AntPreferencesMessages.getString("AntEditorPreferencePage.17");
        this.addComboBox(othersComposite, label, "problem_imports", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        return othersComposite;
    }

    private void initializeWorkingValues() {
        this.fWorkingValues = new HashMap(this.fProblemPreferenceKeys.length);
        int i = 0;
        while (i < this.fProblemPreferenceKeys.length) {
            String key = this.fProblemPreferenceKeys[i];
            this.fWorkingValues.put(key, this.getPreferenceStore().getString(key));
            ++i;
        }
    }

    private void restoreWorkingValuesToDefaults() {
        this.fWorkingValues = new HashMap(this.fProblemPreferenceKeys.length);
        int i = 0;
        while (i < this.fProblemPreferenceKeys.length) {
            String key = this.fProblemPreferenceKeys[i];
            this.fWorkingValues.put(key, this.getPreferenceStore().getDefaultString(key));
            ++i;
        }
        this.updateControls();
    }

    protected Combo addComboBox(Composite parent, String label, String key, String[] values, String[] valueLabels, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = new Combo(parent, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.setLayoutData((Object)new GridData(256));
        comboBox.addSelectionListener(this.getSelectionListener());
        Label placeHolder = new Label(parent, 0);
        placeHolder.setLayoutData((Object)new GridData(768));
        String currValue = (String)this.fWorkingValues.get(key);
        comboBox.select(data.getSelection(currValue));
        this.fComboBoxes.add(comboBox);
        return comboBox;
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    AntEditorPreferencePage.this.controlChanged(e.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData data = (ControlData)widget.getData();
        String newValue = null;
        if (widget instanceof Button) {
            newValue = data.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            newValue = data.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        this.fWorkingValues.put(data.getKey(), newValue);
    }

    protected void updateControls() {
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            Combo curr = (Combo)this.fComboBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            String currValue = (String)this.fWorkingValues.get(data.getKey());
            curr.select(data.getSelection(currValue));
            --i;
        }
    }

    public boolean performOk() {
        Iterator iter = this.fWorkingValues.keySet().iterator();
        IPreferenceStore store = this.getPreferenceStore();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            store.putValue(key, (String)this.fWorkingValues.get(key));
        }
        if (store.needsSaving()) {
            store.putValue("problem", "changed");
        }
        return super.performOk();
    }

    protected static class ControlData {
        private String fKey;
        private String[] fValues;

        public ControlData(String key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.fValues.length) {
                    if (value.equals(this.fValues[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.fValues.length - 1;
        }
    }

    private class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private Color fItemColor;

        public HighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, Color itemColor) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fItemColor = itemColor;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public Color getItemColor() {
            return this.fItemColor;
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        ColorListLabelProvider() {
        }

        public String getText(Object element) {
            return ((HighlightingColorListItem)element).getDisplayName();
        }

        public Color getForeground(Object element) {
            return ((HighlightingColorListItem)element).getItemColor();
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private class ColorListContentProvider
    implements IStructuredContentProvider {
        ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

