/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.connect;

import com.sun.jdi.VMDisconnectedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.jdi.TimeoutException;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.connect.ConnectMessages;
import org.eclipse.jdi.internal.connect.ConnectorImpl;
import org.eclipse.jdi.internal.connect.PacketManager;
import org.eclipse.jdi.internal.jdwp.JdwpCommandPacket;
import org.eclipse.jdi.internal.jdwp.JdwpPacket;
import org.eclipse.jdi.internal.jdwp.JdwpReplyPacket;

public class PacketReceiveManager
extends PacketManager {
    public static final int TIMEOUT_NOT_BLOCKING = 0;
    public static final int TIMEOUT_INFINITE = -1;
    private VirtualMachineImpl fVM;
    private InputStream fInStream;
    private LinkedList fCommandPackets;
    private LinkedList fReplyPackets;

    public PacketReceiveManager(ConnectorImpl connector) {
        super(connector);
        try {
            this.fVM = connector.virtualMachine();
            this.fInStream = connector.getInputStream();
            this.fCommandPackets = new LinkedList();
            this.fReplyPackets = new LinkedList();
        }
        catch (IOException e) {
            this.disconnectVM(e);
        }
    }

    public void run() {
        try {
            while (true) {
                this.readAvailablePacket();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException e) {
            this.disconnectVM(e);
        }
    }

    public synchronized JdwpCommandPacket getCommand(int command, long timeToWait) throws InterruptedException {
        JdwpCommandPacket packet = null;
        long remainingTime = timeToWait;
        while (!(this.VMIsDisconnected() || (packet = this.removeCommandPacket(command)) != null || timeToWait >= 0L && remainingTime <= 0L)) {
            long timeBeforeWait = System.currentTimeMillis();
            this.waitForPacketAvailable(remainingTime);
            long waitedTime = System.currentTimeMillis() - timeBeforeWait;
            remainingTime -= waitedTime;
        }
        if (this.VMIsDisconnected()) {
            String exMessage;
            String message = this.getDisconnectException() == null ? ConnectMessages.getString("PacketReceiveManager.Got_IOException_from_Virtual_Machine_1") : ((exMessage = this.getDisconnectException().getMessage()) == null ? MessageFormat.format(ConnectMessages.getString("PacketReceiveManager.Got_{0}_from_Virtual_Machine_1"), this.getDisconnectException().getClass().getName()) : MessageFormat.format(ConnectMessages.getString("PacketReceiveManager.Got_{0}_from_Virtual_Machine__{1}_1"), this.getDisconnectException().getClass().getName(), exMessage));
            throw new VMDisconnectedException(message);
        }
        if (packet == null) {
            throw new TimeoutException();
        }
        return packet;
    }

    public synchronized JdwpReplyPacket getReply(int id, long timeToWait) {
        JdwpReplyPacket packet = null;
        long remainingTime = timeToWait;
        while (!(this.VMIsDisconnected() || (packet = this.removeReplyPacket(id)) != null || timeToWait >= 0L && remainingTime <= 0L)) {
            long timeBeforeWait = System.currentTimeMillis();
            try {
                this.waitForPacketAvailable(remainingTime);
            }
            catch (InterruptedException interruptedException) {}
            long waitedTime = System.currentTimeMillis() - timeBeforeWait;
            remainingTime -= waitedTime;
        }
        if (this.VMIsDisconnected()) {
            throw new VMDisconnectedException(ConnectMessages.getString("PacketReceiveManager.Got_IOException_from_Virtual_Machine_2"));
        }
        if (packet == null) {
            throw new TimeoutException();
        }
        return packet;
    }

    public JdwpReplyPacket getReply(JdwpCommandPacket commandPacket) {
        return this.getReply(commandPacket.getId(), this.fVM.getRequestTimeout());
    }

    private void waitForPacketAvailable(long timeToWait) throws InterruptedException {
        if (timeToWait == 0L) {
            return;
        }
        if (timeToWait < 0L) {
            this.wait();
        } else {
            this.wait(timeToWait);
        }
    }

    private JdwpCommandPacket removeCommandPacket(int command) {
        ListIterator iter = this.fCommandPackets.listIterator();
        while (iter.hasNext()) {
            JdwpCommandPacket packet = (JdwpCommandPacket)iter.next();
            if (packet.getCommand() != command) continue;
            iter.remove();
            return packet;
        }
        return null;
    }

    private JdwpReplyPacket removeReplyPacket(int id) {
        ListIterator iter = this.fReplyPackets.listIterator();
        while (iter.hasNext()) {
            JdwpReplyPacket packet = (JdwpReplyPacket)iter.next();
            if (packet.getId() != id) continue;
            iter.remove();
            return packet;
        }
        return null;
    }

    private synchronized void addCommandPacket(JdwpCommandPacket packet) {
        this.fCommandPackets.add(packet);
        this.notifyAll();
    }

    private synchronized void addReplyPacket(JdwpReplyPacket packet) {
        this.fReplyPackets.add(packet);
        this.notifyAll();
    }

    private void readAvailablePacket() throws IOException {
        JdwpPacket packet = JdwpPacket.read(this.fInStream);
        if (packet instanceof JdwpCommandPacket) {
            this.addCommandPacket((JdwpCommandPacket)packet);
        } else {
            this.addReplyPacket((JdwpReplyPacket)packet);
        }
    }
}

