/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser.embedded;

import org.eclipse.core.runtime.Platform;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.browser.IBrowserFactory;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.ui.internal.HelpUIEventLoop;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.browser.embedded.EmbeddedBrowserAdapter;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EmbeddedBrowserFactory
implements IBrowserFactory {
    private boolean tested = false;
    private boolean available = false;

    public boolean isAvailable() {
        if (BaseHelpSystem.getMode() == 2) {
            try {
                if (HelpUIEventLoop.isRunning()) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            EmbeddedBrowserFactory.this.test();
                        }
                    });
                }
            }
            catch (Exception exception) {}
        } else {
            this.test();
        }
        this.tested = true;
        return this.available;
    }

    private boolean test() {
        if (!"win32".equalsIgnoreCase(Platform.getOS()) && !"linux".equalsIgnoreCase(Platform.getOS())) {
            return false;
        }
        if (!this.tested) {
            this.tested = true;
            Shell sh = new Shell();
            try {
                new Browser((Composite)sh, 0);
                this.available = true;
            }
            catch (SWTError se) {
                if (se.code == 2) {
                    this.available = false;
                }
                HelpUIPlugin.logError(HelpUIResources.getString("EmbeddedBrowserFactory.error"), se);
            }
            if (sh != null && !sh.isDisposed()) {
                sh.dispose();
            }
        }
        return this.available;
    }

    public IBrowser createBrowser() {
        return new EmbeddedBrowserAdapter();
    }
}

