/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LauncherUtils {
    private static final String KEY_MISSING_REQUIRED = "WorkbenchLauncherConfigurationDelegate.missingRequired";
    private static final String KEY_BROKEN_PLUGINS = "WorkbenchLauncherConfigurationDelegate.brokenPlugins";
    private static final String KEY_NO_JRE = "WorkbenchLauncherConfigurationDelegate.noJRE";
    private static final String KEY_JRE_PATH_NOT_FOUND = "WorkbenchLauncherConfigurationDelegate.jrePathNotFound";
    private static final String KEY_PROBLEMS_DELETING = "WorkbenchLauncherConfigurationDelegate.problemsDeleting";
    private static final String KEY_TITLE = "WorkbenchLauncherConfigurationDelegate.title";
    private static final String KEY_DELETE_WORKSPACE = "WorkbenchLauncherConfigurationDelegate.confirmDeleteWorkspace";

    public static IVMInstall[] getAllVMInstances() {
        ArrayList<IVMInstall> res = new ArrayList<IVMInstall>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] installs = types[i].getVMInstalls();
            int k = 0;
            while (k < installs.length) {
                res.add(installs[k]);
                ++k;
            }
            ++i;
        }
        return res.toArray(new IVMInstall[res.size()]);
    }

    public static String[] getVMInstallNames() {
        IVMInstall[] installs = LauncherUtils.getAllVMInstances();
        String[] names = new String[installs.length];
        int i = 0;
        while (i < installs.length) {
            names[i] = installs[i].getName();
            ++i;
        }
        return names;
    }

    public static String getDefaultVMInstallName() {
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null) {
            return install.getName();
        }
        return null;
    }

    public static IVMInstall getVMInstall(String name) {
        if (name != null) {
            IVMInstall[] installs = LauncherUtils.getAllVMInstances();
            int i = 0;
            while (i < installs.length) {
                if (installs[i].getName().equals(name)) {
                    return installs[i];
                }
                ++i;
            }
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    public static String getDefaultProgramArguments() {
        String os = TargetPlatform.getOS();
        String ws = TargetPlatform.getWS();
        String arch = TargetPlatform.getOSArch();
        String nl = TargetPlatform.getNL();
        String args = "-os " + os + " -ws " + ws + " -arch " + arch + " -nl " + nl;
        if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            return String.valueOf(args) + " -clean";
        }
        return args;
    }

    public static String getDefaultWorkspace() {
        return LauncherUtils.getDefaultPath().append("runtime-workspace").toOSString();
    }

    public static IPath getDefaultPath() {
        return PDEPlugin.getWorkspace().getRoot().getLocation().removeLastSegments(1);
    }

    public static TreeSet parseDeselectedWSIds(ILaunchConfiguration config) throws CoreException {
        TreeSet<String> deselected = new TreeSet<String>();
        String ids = config.getAttribute("wsproject", null);
        if (ids != null) {
            StringTokenizer tok = new StringTokenizer(ids, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                deselected.add(tok.nextToken());
            }
        }
        return deselected;
    }

    public static TreeSet parseSelectedExtIds(ILaunchConfiguration config) throws CoreException {
        TreeSet<String> selected = new TreeSet<String>();
        String ids = config.getAttribute("extplugins", null);
        if (ids != null) {
            StringTokenizer tok = new StringTokenizer(ids, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int loc = token.lastIndexOf(44);
                if (loc == -1) {
                    selected.add(token);
                    continue;
                }
                if (token.charAt(loc + 1) != 't') continue;
                selected.add(token.substring(0, loc));
            }
        }
        return selected;
    }

    public static String[] constructClasspath(ILaunchConfiguration configuration) throws CoreException {
        String jarPath = LauncherUtils.getStartupJarPath();
        if (jarPath == null) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(jarPath);
        StringTokenizer tok = new StringTokenizer(configuration.getAttribute("bootstrap", ""), ",");
        while (tok.hasMoreTokens()) {
            entries.add(tok.nextToken().trim());
        }
        return entries.toArray(new String[entries.size()]);
    }

    private static String getStartupJarPath() throws CoreException {
        File startupJar;
        IPlugin plugin = PDECore.getDefault().findPlugin("org.eclipse.platform");
        if (plugin != null && plugin.getModel().getUnderlyingResource() != null) {
            IProject project = plugin.getModel().getUnderlyingResource().getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1 && roots[i].getPackageFragment("org.eclipse.core.launcher").exists()) {
                        IPath path = jProject.getOutputLocation().removeFirstSegments(1);
                        return project.getLocation().append(path).toOSString();
                    }
                    ++i;
                }
            }
            if (project.getFile("startup.jar").exists()) {
                return project.getFile("startup.jar").getLocation().toOSString();
            }
        }
        if (!(startupJar = ExternalModelManager.getEclipseHome().append("startup.jar").toFile()).exists()) {
            startupJar = new Path(ExternalModelManager.computeDefaultPlatformPath()).append("startup.jar").toFile();
        }
        return startupJar.exists() ? startupJar.getAbsolutePath() : null;
    }

    public static TreeMap getPluginsToRun(ILaunchConfiguration config) throws CoreException {
        MultiStatus multiStatus;
        String requiredPlugin;
        TreeMap map = null;
        ArrayList statusEntries = new ArrayList();
        if (!config.getAttribute("default", true)) {
            map = LauncherUtils.validatePlugins(LauncherUtils.getSelectedPlugins(config), statusEntries);
        }
        if (map == null) {
            map = LauncherUtils.validatePlugins(PDECore.getDefault().getModelManager().getPlugins(), statusEntries);
        }
        if (!map.containsKey(requiredPlugin = PDECore.getDefault().getModelManager().isOSGiRuntime() ? "org.eclipse.osgi" : "org.eclipse.core.boot")) {
            final Display display = LauncherUtils.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)PDEPlugin.getResourceString(LauncherUtils.KEY_TITLE), (String)PDEPlugin.getFormattedMessage(LauncherUtils.KEY_MISSING_REQUIRED, requiredPlugin));
                }
            });
            return null;
        }
        if (statusEntries.size() > 0 && !LauncherUtils.ignoreValidationErrors(multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, statusEntries.toArray(new IStatus[statusEntries.size()]), PDEPlugin.getResourceString(KEY_BROKEN_PLUGINS), null))) {
            return null;
        }
        return map;
    }

    public static HashMap getAutoStartPlugins(ILaunchConfiguration config) {
        boolean useDefault = true;
        String customAutoStart = "";
        try {
            useDefault = config.getAttribute("useDefaultConfig", true);
            customAutoStart = config.getAttribute("autoStartList", "");
        }
        catch (CoreException coreException) {}
        return LauncherUtils.getAutoStartPlugins(useDefault, customAutoStart);
    }

    public static HashMap getAutoStartPlugins(boolean useDefault, String customAutoStart) {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        if (!PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            list.put("org.eclipse.core.boot", new Integer(0));
        } else {
            String bundles = null;
            if (useDefault) {
                Properties prop = LauncherUtils.getConfigIniProperties(ExternalModelManager.getEclipseHome().toOSString(), "configuration/config.ini");
                if (prop != null) {
                    bundles = prop.getProperty("osgi.bundles");
                }
                if (prop == null || bundles == null) {
                    String path = LauncherUtils.getOSGiPath();
                    if (path != null) {
                        prop = LauncherUtils.getConfigIniProperties(path, "eclipse.properties");
                    }
                    if (prop != null) {
                        bundles = prop.getProperty("osgi.bundles");
                    }
                }
            } else {
                bundles = customAutoStart;
            }
            if (bundles != null) {
                StringTokenizer tokenizer = new StringTokenizer(bundles, ",");
                while (tokenizer.hasMoreTokens()) {
                    String start;
                    String token = tokenizer.nextToken().trim();
                    int index = token.indexOf(64);
                    if (index == -1 || index == token.length() - 1 || (start = token.substring(index + 1)).indexOf("start") == -1 && useDefault) continue;
                    Integer level = index != -1 ? LauncherUtils.getStartLevel(start) : new Integer(-1);
                    list.put(index != -1 ? token.substring(0, token.indexOf(64)) : token, level);
                }
            }
        }
        return list;
    }

    private static String getOSGiPath() {
        ModelEntry entry = PDECore.getDefault().getModelManager().findEntry("org.eclipse.osgi");
        if (entry != null) {
            IPluginModelBase model = entry.getActiveModel();
            if (model.getUnderlyingResource() != null) {
                return model.getUnderlyingResource().getLocation().removeLastSegments(2).toOSString();
            }
            return model.getInstallLocation();
        }
        return null;
    }

    private static Integer getStartLevel(String text) {
        StringTokenizer tok = new StringTokenizer(text, ":");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            try {
                return new Integer(token);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new Integer(-1);
    }

    private static IPluginModelBase[] getSelectedPlugins(ILaunchConfiguration config) throws CoreException {
        TreeMap<String, IPluginModelBase> map = new TreeMap<String, IPluginModelBase>();
        IPluginModelBase[] wsmodels = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
        TreeSet deselectedWSPlugins = LauncherUtils.parseDeselectedWSIds(config);
        int i = 0;
        while (i < wsmodels.length) {
            String id = wsmodels[i].getPluginBase().getId();
            if (id != null && !deselectedWSPlugins.contains(id)) {
                map.put(id, wsmodels[i]);
            }
            ++i;
        }
        TreeSet selectedExModels = LauncherUtils.parseSelectedExtIds(config);
        IPluginModelBase[] exmodels = PDECore.getDefault().getExternalModelManager().getAllModels();
        int i2 = 0;
        while (i2 < exmodels.length) {
            String id = exmodels[i2].getPluginBase().getId();
            if (id != null && selectedExModels.contains(id) && !map.containsKey(id)) {
                map.put(id, exmodels[i2]);
            }
            ++i2;
        }
        return map.values().toArray(new IPluginModelBase[map.size()]);
    }

    public static IProject[] getAffectedProjects(ILaunchConfiguration config) throws CoreException {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IPluginModelBase[] models = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
        TreeSet ignored = LauncherUtils.parseDeselectedWSIds(config);
        int i = 0;
        while (i < models.length) {
            IProject project;
            String id = models[i].getPluginBase().getId();
            if (id != null && id.length() != 0 && !ignored.contains(id) && (project = models[i].getUnderlyingResource().getProject()).hasNature("org.eclipse.jdt.core.javanature")) {
                projects.add(project);
            }
            ++i;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    private static TreeMap validatePlugins(IPluginModelBase[] models, ArrayList statusEntries) {
        TreeMap<String, IPluginModelBase> map = new TreeMap<String, IPluginModelBase>();
        int i = 0;
        while (i < models.length) {
            IStatus status = LauncherUtils.validateModel(models[i]);
            if (status == null) {
                String id = models[i].getPluginBase().getId();
                if (id != null) {
                    map.put(id, models[i]);
                }
            } else {
                statusEntries.add(status);
            }
            ++i;
        }
        return map;
    }

    private static IStatus validateModel(IPluginModelBase model) {
        return model.isLoaded() ? null : new Status(2, PDEPlugin.getPluginId(), 0, model.getPluginBase().getId(), null);
    }

    public static String getBootPath(IPluginModelBase bootModel) {
        try {
            IResource resource = bootModel.getUnderlyingResource();
            if (resource != null) {
                IProject project = resource.getProject();
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    resource = project.findMember("boot.jar");
                    if (resource != null) {
                        return "file:" + resource.getLocation().toOSString();
                    }
                    IPath path = JavaCore.create((IProject)project).getOutputLocation();
                    if (path != null) {
                        IPath sourceBootPath = project.getParent().getLocation().append(path);
                        return sourceBootPath.addTrailingSeparator().toOSString();
                    }
                }
            } else {
                File bootJar = new File(bootModel.getInstallLocation(), "boot.jar");
                if (bootJar.exists()) {
                    return "file:" + bootJar.getAbsolutePath();
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private static boolean ignoreValidationErrors(final MultiStatus status) {
        final boolean[] result = new boolean[1];
        LauncherUtils.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = MessageDialog.openConfirm((Shell)LauncherUtils.getDisplay().getActiveShell(), (String)PDEPlugin.getResourceString(LauncherUtils.KEY_TITLE), (String)status.getMessage());
            }
        });
        return result[0];
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IVMInstall createLauncher(ILaunchConfiguration configuration) throws CoreException {
        String vm = configuration.getAttribute("vminstall", null);
        IVMInstall launcher = LauncherUtils.getVMInstall(vm);
        if (launcher == null) {
            throw new CoreException(LauncherUtils.createErrorStatus(PDEPlugin.getFormattedMessage(KEY_NO_JRE, vm)));
        }
        if (!launcher.getInstallLocation().exists()) {
            throw new CoreException(LauncherUtils.createErrorStatus(PDEPlugin.getResourceString(KEY_JRE_PATH_NOT_FOUND)));
        }
        return launcher;
    }

    public static IStatus createErrorStatus(String message) {
        return new Status(4, PDEPlugin.getPluginId(), 0, message, null);
    }

    public static void setDefaultSourceLocator(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        String id;
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        String locator = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
        if (locator != null) {
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
        }
        if ((id = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null)) == null) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
        }
        if (locator != null || id == null) {
            wc.doSave();
        }
    }

    public static boolean clearWorkspace(ILaunchConfiguration configuration, String workspace, IProgressMonitor monitor) throws CoreException {
        File workspaceFile = new Path(workspace).toFile();
        if (configuration.getAttribute("clearws", false) && workspaceFile.exists()) {
            boolean doClear;
            boolean bl = doClear = !configuration.getAttribute("askclear", true);
            if (!doClear) {
                int result = LauncherUtils.confirmDeleteWorkspace(workspaceFile);
                if (result == 2) {
                    monitor.done();
                    return false;
                }
                boolean bl2 = doClear = result == 0;
            }
            if (doClear) {
                try {
                    LauncherUtils.deleteContent(workspaceFile, monitor);
                }
                catch (IOException iOException) {
                    LauncherUtils.showWarningDialog(PDEPlugin.getResourceString(KEY_PROBLEMS_DELETING));
                }
            }
        }
        monitor.done();
        return true;
    }

    private static void showWarningDialog(final String message) {
        LauncherUtils.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = PDEPlugin.getResourceString(LauncherUtils.KEY_TITLE);
                MessageDialog.openWarning((Shell)LauncherUtils.getDisplay().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    private static int confirmDeleteWorkspace(final File workspaceFile) {
        final int[] result = new int[1];
        LauncherUtils.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = PDEPlugin.getResourceString(LauncherUtils.KEY_TITLE);
                String message = PDEPlugin.getFormattedMessage(LauncherUtils.KEY_DELETE_WORKSPACE, workspaceFile.getPath());
                MessageDialog dialog = new MessageDialog(LauncherUtils.getDisplay().getActiveShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                result[0] = dialog.open();
            }
        });
        return result[0];
    }

    public static File createConfigArea(String name) {
        IPath statePath = PDECore.getDefault().getStateLocation();
        File dir = new File(statePath.toOSString());
        if (name.length() > 0 && !(dir = new File(dir, name)).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static void clearConfigArea(File configDir, IProgressMonitor monitor) {
        try {
            LauncherUtils.deleteContent(configDir, monitor);
        }
        catch (IOException iOException) {
            LauncherUtils.showWarningDialog(PDEPlugin.getResourceString("LauncherUtils.problemsDeletingConfig"));
        }
    }

    private static void deleteContent(File curr, IProgressMonitor monitor) throws IOException {
        File[] children;
        if (curr.isDirectory() && (children = curr.listFiles()) != null) {
            monitor.beginTask("", children.length);
            int i = 0;
            while (i < children.length) {
                LauncherUtils.deleteContent(children[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        curr.delete();
        monitor.done();
    }

    public static String getTracingFileArgument(ILaunchConfiguration config, String optionsFileName) throws CoreException {
        try {
            TracingOptionsManager mng = PDECore.getDefault().getTracingOptionsManager();
            Map options = config.getAttribute("tracingOptions", null);
            String selected = config.getAttribute("checked", null);
            if (selected == null) {
                mng.save(optionsFileName, options);
            } else if (!selected.equals("[NONE]")) {
                HashSet<String> result = new HashSet<String>();
                StringTokenizer tokenizer = new StringTokenizer(selected, ",");
                while (tokenizer.hasMoreTokens()) {
                    result.add(tokenizer.nextToken());
                }
                mng.save(optionsFileName, options, result);
            }
        }
        catch (CoreException coreException) {
            return "";
        }
        return optionsFileName;
    }

    public static String getPrimaryFeatureId() {
        boolean isOSGi = PDECore.getDefault().getModelManager().isOSGiRuntime();
        String filename = isOSGi ? "configuration/config.ini" : "install.ini";
        Properties properties = LauncherUtils.getConfigIniProperties(ExternalModelManager.getEclipseHome().toOSString(), filename);
        String property = isOSGi ? "eclipse.product" : "feature.default.id";
        return properties == null ? null : properties.getProperty(property);
    }

    public static String getDefaultApplicationName() {
        if (!PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            return "org.eclipse.ui.workbench";
        }
        Properties properties = LauncherUtils.getConfigIniProperties(ExternalModelManager.getEclipseHome().toOSString(), "configuration/config.ini");
        String appName = properties != null ? properties.getProperty("eclipse.application") : null;
        return appName != null ? appName : "org.eclipse.ui.ide.workbench";
    }

    public static Properties getConfigIniProperties(String directory, String filename) {
        File iniFile = new File(directory, filename);
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        try {
            FileInputStream fis = new FileInputStream(iniFile);
            pini.load(fis);
            fis.close();
            return pini;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

