/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.sourcelookup.SourceLookupDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CommonSourceNotFoundEditor
extends EditorPart
implements IReusableEditor,
IDebugEventSetListener {
    private Text fText;
    protected Object fObject;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        GridLayout topLayout = new GridLayout();
        GridData data = new GridData();
        topLayout.numColumns = 1;
        topLayout.verticalSpacing = 10;
        parent.setLayout((Layout)topLayout);
        parent.setLayoutData((Object)data);
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        this.fText = new Text(parent, 72);
        this.fText.setForeground(JFaceColors.getErrorText((Display)this.fText.getDisplay()));
        this.fText.setBackground(parent.getDisplay().getSystemColor(1));
        if (this.getEditorInput() != null) {
            this.setInput(this.getEditorInput());
        }
        Button button = new Button(parent, 8);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        data.heightHint = 50;
        data.widthHint = 50;
        button.setData((Object)data);
        button.setText(SourceLookupUIMessages.getString("addSourceLocation.addButton2"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CommonSourceNotFoundEditor.this.buttonSelected();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        WorkbenchHelp.setHelp((Control)parent, (String)IDebugHelpContextIds.NO_SOURCE_EDITOR);
    }

    private void buttonSelected() {
        ISourceLocator locator = null;
        ILaunch launch = null;
        IAdaptable selection = DebugUITools.getDebugContext();
        if (selection == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.ILaunch");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (selection.getAdapter((Class)clazz) != null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.debug.core.ILaunch");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            launch = (ILaunch)selection.getAdapter((Class)clazz2);
            locator = launch.getSourceLocator();
        } else {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.debug.core.model.IDebugElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (selection.getAdapter((Class)clazz3) != null) {
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("org.eclipse.debug.core.model.IDebugElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                launch = ((IDebugElement)selection.getAdapter((Class)clazz4)).getLaunch();
                locator = launch.getSourceLocator();
            } else {
                return;
            }
        }
        if (locator == null || !(locator instanceof AbstractSourceLookupDirector)) {
            return;
        }
        SourceLookupDialog dialog = new SourceLookupDialog(DebugUIPlugin.getShell(), (ISourceLookupDirector)((AbstractSourceLookupDirector)locator));
        int result = dialog.open();
        if (result == 0) {
            this.resetEditor();
        }
    }

    public void resetEditor() {
        this.fireChangeEventsOnStack();
        if (this.fObject instanceof IStackFrame) {
            return;
        }
        final int lineNumber = this.getLineNumber();
        Runnable open = new Runnable(){

            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow dwindow = DebugUIPlugin.getActiveWorkbenchWindow();
                if (dwindow != null && (page = dwindow.getActivePage()) != null) {
                    String id;
                    IDebugModelPresentation modelPres = DebugUITools.newDebugModelPresentation();
                    IEditorInput input = modelPres.getEditorInput(CommonSourceNotFoundEditor.this.fObject);
                    if (input != null && (id = modelPres.getEditorId(input, CommonSourceNotFoundEditor.this.fObject)) != null) {
                        try {
                            ITextEditor textEditor;
                            IRegion region;
                            IEditorPart editorPart = page.openEditor(input, id);
                            if (editorPart instanceof ITextEditor && lineNumber >= 0 && (region = CommonSourceNotFoundEditor.this.getLineInformation(textEditor = (ITextEditor)editorPart, lineNumber)) != null) {
                                textEditor.selectAndReveal(region.getOffset(), 0);
                            }
                        }
                        catch (PartInitException partInitException) {}
                    }
                    modelPres.dispose();
                }
            }
        };
        this.closeEditor();
        DebugUIPlugin.getStandardDisplay().asyncExec(open);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IEditorInput input;
        IDocumentProvider provider;
        block7: {
            IRegion iRegion;
            provider = editor.getDocumentProvider();
            input = editor.getEditorInput();
            try {
                provider.connect((Object)input);
            }
            catch (CoreException coreException) {
                return null;
            }
            try {
                try {
                    IDocument document = provider.getDocument((Object)input);
                    if (document == null) break block7;
                    iRegion = document.getLineInformation(lineNumber);
                    Object var6_7 = null;
                }
                catch (BadLocationException badLocationException) {
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                provider.disconnect((Object)input);
                throw throwable;
            }
            provider.disconnect((Object)input);
            return iRegion;
        }
        Object var6_9 = null;
        provider.disconnect((Object)input);
        return null;
    }

    protected int getLineNumber() {
        int line = -1;
        if (this.fObject instanceof IMarker) {
            try {
                line = (Integer)((IMarker)this.fObject).getAttribute("lineNumber");
            }
            catch (CoreException coreException) {}
        }
        return line;
    }

    public void setFocus() {
        if (this.fText != null) {
            this.fText.setFocus();
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof CommonSourceNotFoundEditorInput) {
            this.fObject = ((CommonSourceNotFoundEditorInput)input).getObject();
        }
        this.setTitle(input.getName());
        if (this.fText != null) {
            this.fText.setText(String.valueOf(input.getToolTipText()) + "\n");
        }
    }

    protected void fireChangeEventsOnStack() {
        if (this.fObject instanceof IStackFrame) {
            this.fireChangeEvent(512, (IDebugElement)((IStackFrame)this.fObject));
        } else if (this.fObject instanceof IDebugElement) {
            try {
                IThread[] threads = ((IDebugElement)this.fObject).getDebugTarget().getThreads();
                int i = 0;
                while (i < threads.length) {
                    this.fireChangeEvent(512, (IDebugElement)threads[i].getTopStackFrame());
                    ++i;
                }
            }
            catch (DebugException debugException) {}
        }
    }

    public void fireChangeEvent(int detail, IDebugElement source) {
        this.fireEvent(new DebugEvent((Object)source, 16, detail));
    }

    private void fireEvent(DebugEvent event) {
        if (DebugPlugin.getDefault() != null) {
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object source = event.getSource();
            switch (event.getKind()) {
                case 8: {
                    if (!this.checkIfEditorShouldClose(source)) break;
                    this.closeEditor();
                    break;
                }
                case 16: {
                    if (!source.equals(this.fObject)) {
                        return;
                    }
                    IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                    if (window == null) {
                        return;
                    }
                    IWorkbenchPage p = window.getActivePage();
                    if (p == null) {
                        return;
                    }
                    IViewPart fLaunchView = p.findView("org.eclipse.debug.ui.DebugView");
                    if (!(fLaunchView instanceof ISelectionChangedListener)) break;
                    ISelection fSelection = ((LaunchView)fLaunchView).getViewer().getSelection();
                    ((LaunchView)fLaunchView).clearSourceSelection(((IStackFrame)source).getThread());
                    ((LaunchView)fLaunchView).getViewer().setSelection(fSelection, true);
                }
            }
            ++i;
        }
    }

    protected boolean checkIfEditorShouldClose(Object source) {
        if (this.fObject instanceof IDebugElement && source instanceof IDebugElement) {
            IDebugElement element = (IDebugElement)this.fObject;
            IDebugElement sourceElement = (IDebugElement)source;
            return sourceElement.getDebugTarget().equals(element.getDebugTarget());
        }
        return false;
    }

    protected void closeEditor() {
        CommonSourceNotFoundEditor editor = this;
        DebugUIPlugin.getStandardDisplay().syncExec(new Runnable((IEditorPart)editor){
            private final /* synthetic */ IEditorPart val$editor;
            {
                this.val$editor = iEditorPart;
            }

            public void run() {
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWorkbenchWindow = DebugUIPlugin.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
                    activePage.closeEditor(this.val$editor, false);
                }
            }
        });
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
    }
}

