/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.actions.FollowHyperlinkAction;
import org.eclipse.debug.internal.ui.actions.KeyBindingFollowHyperlinkAction;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.console.ConsoleDocument;
import org.eclipse.debug.internal.ui.views.console.ConsoleRemoveAllTerminatedAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleTerminateAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleViewer;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.internal.ui.views.console.ScrollLockAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.console.actions.TextViewerGotoLineAction;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class ProcessConsolePage
implements IPageBookViewPage,
ISelectionListener,
IAdaptable,
IShowInSource,
IShowInTargetList,
IDebugEventSetListener,
ITextListener {
    private IPageSite fSite = null;
    private ConsoleViewer fViewer = null;
    private IConsoleView fView;
    private ProcessConsole fConsole;
    private boolean fIsLocked = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_CONSOLE_SCROLL_LOCK);
    private ISelectionChangedListener fTextListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ProcessConsolePage.this.updateSelectionDependentActions();
        }
    };
    private ClearOutputAction fClearOutputAction;
    private Map fGlobalActions = new HashMap(10);
    protected List fSelectionActions = new ArrayList(3);
    private FollowHyperlinkAction fFollowLinkAction;
    private ScrollLockAction fScrollLockAction;
    private ConsoleTerminateAction fTerminate;
    private ConsoleRemoveAllTerminatedAction fRemoveTerminated;
    private KeyBindingFollowHyperlinkAction fKeyBindingFollowLinkAction;
    private Menu fMenu;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public ProcessConsolePage(IConsoleView view, ProcessConsole console) {
        this.fView = view;
        this.fConsole = console;
    }

    public IPageSite getSite() {
        return this.fSite;
    }

    public void init(IPageSite site) {
        this.fSite = site;
    }

    public void createControl(Composite parent) {
        this.fViewer = new ConsoleViewer(parent);
        this.fViewer.setDocument(DebugUIPlugin.getDefault().getConsoleDocumentManager().getConsoleDocument(this.getProcess()));
        MenuManager manager = new MenuManager("#ProcessConsole", "#ProcessConsole");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                ProcessConsolePage.this.contextMenuAboutToShow(m);
            }
        });
        this.fMenu = manager.createContextMenu(this.getControl());
        this.getControl().setMenu(this.fMenu);
        IPageSite site = this.getSite();
        site.registerContextMenu(String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".processConsole", manager, (ISelectionProvider)this.getConsoleViewer());
        site.setSelectionProvider((ISelectionProvider)this.getConsoleViewer());
        this.createActions();
        this.configureToolBar(this.getSite().getActionBars().getToolBarManager());
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.fViewer.getSelectionProvider().addSelectionChangedListener(this.fTextListener);
        this.fViewer.addTextListener(this);
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        ConsoleDocument doc = (ConsoleDocument)this.getConsoleViewer().getDocument();
        if (doc == null) {
            return;
        }
        if (doc.isReadOnly()) {
            menu.add((IAction)this.fGlobalActions.get(ActionFactory.COPY.getId()));
            menu.add((IAction)this.fGlobalActions.get(ActionFactory.SELECT_ALL.getId()));
        } else {
            this.updateAction(ActionFactory.PASTE.getId());
            menu.add((IAction)this.fGlobalActions.get(ActionFactory.CUT.getId()));
            menu.add((IAction)this.fGlobalActions.get(ActionFactory.COPY.getId()));
            menu.add((IAction)this.fGlobalActions.get(ActionFactory.PASTE.getId()));
            menu.add((IAction)this.fGlobalActions.get(ActionFactory.SELECT_ALL.getId()));
        }
        menu.add((IContributionItem)new Separator("FIND"));
        menu.add((IAction)this.fGlobalActions.get(ActionFactory.FIND.getId()));
        menu.add((IAction)this.fGlobalActions.get("GotoLine"));
        this.fFollowLinkAction.setEnabled(this.fFollowLinkAction.getHyperLink() != null);
        menu.add((IAction)this.fFollowLinkAction);
        menu.add((IAction)this.fClearOutputAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IAction)this.fTerminate);
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.fViewer.getSelectionProvider().removeSelectionChangedListener(this.fTextListener);
        this.fViewer.removeTextListener(this);
        if (this.fKeyBindingFollowLinkAction != null) {
            this.getConsoleView().getSite().getKeyBindingService().unregisterAction((IAction)this.fKeyBindingFollowLinkAction);
        }
        if (this.fRemoveTerminated != null) {
            this.fRemoveTerminated.dispose();
        }
        if (this.fScrollLockAction != null) {
            this.fScrollLockAction.dispose();
        }
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fViewer != null) {
            this.fViewer.dispose();
            this.fViewer = null;
        }
        this.fSite = null;
        this.fSelectionActions.clear();
    }

    public Control getControl() {
        if (this.fViewer != null) {
            return this.fViewer.getControl();
        }
        return null;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
        this.updateSelectionDependentActions();
    }

    protected void createActions() {
        this.fClearOutputAction = new ClearOutputAction((ITextViewer)this.getConsoleViewer());
        this.fRemoveTerminated = new ConsoleRemoveAllTerminatedAction();
        IActionBars actionBars = this.getSite().getActionBars();
        TextViewerAction action = new TextViewerAction((ITextViewer)this.getConsoleViewer(), 3);
        action.configureAction(DebugUIViewsMessages.getString("ConsoleView.Cu&t@Ctrl+X_3"), DebugUIViewsMessages.getString("ConsoleView.Cut_4"), DebugUIViewsMessages.getString("ConsoleView.Cut_4"));
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        this.setGlobalAction(actionBars, ActionFactory.CUT.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)this.getConsoleViewer(), 4);
        action.configureAction(DebugUIViewsMessages.getString("ConsoleView.&Copy@Ctrl+C_6"), DebugUIViewsMessages.getString("ConsoleView.Copy_7"), DebugUIViewsMessages.getString("ConsoleView.Copy_7"));
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setGlobalAction(actionBars, ActionFactory.COPY.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)this.getConsoleViewer(), 5);
        action.configureAction(DebugUIViewsMessages.getString("ConsoleView.&Paste@Ctrl+V_9"), DebugUIViewsMessages.getString("ConsoleView.Paste_10"), DebugUIViewsMessages.getString("ConsoleView.Paste_Clipboard_Text_11"));
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.setGlobalAction(actionBars, ActionFactory.PASTE.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)this.getConsoleViewer(), 7);
        action.configureAction(DebugUIViewsMessages.getString("ConsoleView.Select_&All@Ctrl+A_12"), DebugUIViewsMessages.getString("ConsoleView.Select_All"), DebugUIViewsMessages.getString("ConsoleView.Select_All"));
        this.setGlobalAction(actionBars, ActionFactory.SELECT_ALL.getId(), (IAction)action);
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.debug.internal.ui.views.DebugUIViewsMessages");
        this.setGlobalAction(actionBars, ActionFactory.FIND.getId(), (IAction)new FindReplaceAction(bundle, "find_replace_action.", (IWorkbenchPart)this.getConsoleView()));
        action = new TextViewerGotoLineAction((ITextViewer)this.getConsoleViewer());
        this.setGlobalAction(actionBars, "GotoLine", (IAction)action);
        this.fFollowLinkAction = new FollowHyperlinkAction((ISelectionProvider)this.getConsoleViewer());
        this.fKeyBindingFollowLinkAction = new KeyBindingFollowHyperlinkAction((ISelectionProvider)this.getConsoleViewer(), actionBars);
        this.fKeyBindingFollowLinkAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        this.getConsoleView().getSite().getKeyBindingService().registerAction((IAction)this.fKeyBindingFollowLinkAction);
        this.fScrollLockAction = new ScrollLockAction();
        this.fScrollLockAction.setChecked(this.fIsLocked);
        this.getConsoleViewer().setAutoScroll(!this.fIsLocked);
        actionBars.updateActionBars();
        this.fTerminate = new ConsoleTerminateAction(this.getConsole());
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fSelectionActions.add(ActionFactory.CUT.getId());
        this.fSelectionActions.add(ActionFactory.COPY.getId());
        this.fSelectionActions.add(ActionFactory.PASTE.getId());
        this.fSelectionActions.add(ActionFactory.FIND.getId());
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
        this.fGlobalActions.put(actionID, action);
        actionBars.setGlobalActionHandler(actionID, action);
    }

    public ConsoleViewer getConsoleViewer() {
        return this.fViewer;
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.appendToGroup("launchGroup", (IAction)this.fTerminate);
        mgr.appendToGroup("launchGroup", (IAction)this.fRemoveTerminated);
        mgr.appendToGroup("outputGroup", (IAction)this.fScrollLockAction);
        mgr.appendToGroup("outputGroup", (IAction)this.fClearOutputAction);
    }

    protected IProcess getProcess() {
        return this.getConsole().getProcess();
    }

    protected IConsoleView getConsoleView() {
        return this.fView;
    }

    protected ProcessConsole getConsole() {
        return this.fConsole;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.getProcess().equals(DebugUITools.getCurrentProcess())) {
            this.getConsoleView().display((IConsole)this.getConsole());
        }
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IFindReplaceTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getConsoleViewer().getFindReplaceTarget();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.swt.widgets.Widget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this.getConsoleViewer().getTextWidget();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(required)) {
            return this;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.equals(required)) {
            return this;
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        IProcess process = this.getProcess();
        if (process == null) {
            return null;
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDebugTarget target = (IDebugTarget)process.getAdapter((Class)clazz);
        StructuredSelection selection = null;
        selection = target == null ? new StructuredSelection((Object)process) : new StructuredSelection((Object)target);
        return new ShowInContext(null, (ISelection)selection);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.debug.ui.DebugView"};
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource().equals(this.getProcess())) {
                Runnable r = new Runnable(){

                    public void run() {
                        if (ProcessConsolePage.this.isAvailable()) {
                            ProcessConsolePage.this.fTerminate.update();
                        }
                    }
                };
                if (this.isAvailable()) {
                    this.getControl().getDisplay().asyncExec(r);
                }
            }
            ++i;
        }
    }

    protected boolean isAvailable() {
        return this.getControl() != null;
    }

    public void textChanged(TextEvent event) {
        IUpdate findReplace = (IUpdate)this.fGlobalActions.get(ActionFactory.FIND.getId());
        if (findReplace != null) {
            findReplace.update();
        }
    }
}

