/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.internal.launching.StandardVM;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.LibraryLocation;

public class StandardVMType
extends AbstractVMInstallType {
    private String fDefaultRootPath;
    private static final char fgSeparator = File.separatorChar;
    private static final String[] fgCandidateJavaLocations = new String[]{"bin" + fgSeparator + "javaw", "bin" + fgSeparator + "javaw.exe", "jre" + fgSeparator + "bin" + fgSeparator + "javaw", "jre" + fgSeparator + "bin" + fgSeparator + "javaw.exe", "bin" + fgSeparator + "java", "bin" + fgSeparator + "java.exe", "jre" + fgSeparator + "bin" + fgSeparator + "java", "jre" + fgSeparator + "bin" + fgSeparator + "java.exe"};

    public static File findJavaExecutable(File vmInstallLocation) {
        int i = 0;
        while (i < fgCandidateJavaLocations.length) {
            File javaFile = new File(vmInstallLocation, fgCandidateJavaLocations[i]);
            if (javaFile.isFile()) {
                return javaFile;
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        return LaunchingMessages.getString("StandardVMType.Standard_VM_3");
    }

    protected IVMInstall doCreateVMInstall(String id) {
        return new StandardVM(this, id);
    }

    protected synchronized LibraryInfo getLibraryInfo(File javaHome, File javaExecutable) {
        String installPath = javaHome.getAbsolutePath();
        LibraryInfo info = LaunchingPlugin.getLibraryInfo(installPath);
        if (info == null) {
            info = this.generateLibraryInfo(javaHome, javaExecutable);
            if (info == null) {
                info = this.getDefaultLibraryInfo(javaHome);
            } else {
                LaunchingPlugin.setLibraryInfo(installPath, info);
            }
        }
        return info;
    }

    protected boolean canDetectDefaultSystemLibraries(File javaHome, File javaExecutable) {
        LibraryLocation[] locations = this.getDefaultLibraryLocations(javaHome);
        String version = this.getVMVersion(javaHome, javaExecutable);
        return locations.length > 0 && !version.startsWith("1.1");
    }

    protected String getVMVersion(File javaHome, File javaExecutable) {
        LibraryInfo info = this.getLibraryInfo(javaHome, javaExecutable);
        return info.getVersion();
    }

    public File detectInstallLocation() {
        File parent;
        File javaHome;
        if (Platform.getOS().equals("macosx")) {
            return null;
        }
        try {
            javaHome = new File(System.getProperty("java.home")).getCanonicalFile();
        }
        catch (IOException e) {
            LaunchingPlugin.log(e);
            return null;
        }
        if (!javaHome.exists()) {
            return null;
        }
        File javaExecutable = StandardVMType.findJavaExecutable(javaHome);
        if (javaExecutable == null) {
            return null;
        }
        boolean foundLibraries = false;
        if (javaHome.getName().equalsIgnoreCase("jre") && this.canDetectDefaultSystemLibraries(parent = new File(javaHome.getParent()), javaExecutable)) {
            javaHome = parent;
            foundLibraries = true;
        }
        if (!foundLibraries && !this.canDetectDefaultSystemLibraries(javaHome, javaExecutable)) {
            return null;
        }
        return javaHome;
    }

    protected IPath getDefaultSystemLibrary(File javaHome) {
        IPath jreLibPath = new Path(javaHome.getPath()).append("lib").append("rt.jar");
        if (jreLibPath.toFile().isFile()) {
            return jreLibPath;
        }
        return new Path(javaHome.getPath()).append("jre").append("lib").append("rt.jar");
    }

    protected IPath getDefaultSystemLibrarySource(File libLocation) {
        File parent = libLocation.getParentFile();
        while (parent != null) {
            File parentsrc = new File(parent, "src.jar");
            if (parentsrc.isFile()) {
                this.setDefaultRootPath("src");
                return new Path(parentsrc.getPath());
            }
            parentsrc = new File(parent, "src.zip");
            if (parentsrc.isFile()) {
                this.setDefaultRootPath("");
                return new Path(parentsrc.getPath());
            }
            parent = parent.getParentFile();
        }
        this.setDefaultRootPath("");
        return Path.EMPTY;
    }

    protected IPath getDefaultPackageRootPath() {
        return new Path(this.getDefaultRootPath());
    }

    public LibraryLocation[] getDefaultLibraryLocations(File installLocation) {
        File javaExecutable = StandardVMType.findJavaExecutable(installLocation);
        LibraryInfo libInfo = javaExecutable == null ? this.getDefaultLibraryInfo(installLocation) : this.getLibraryInfo(installLocation, javaExecutable);
        String[] bootpath = libInfo.getBootpath();
        List extensions = this.gatherAllLibraries(libInfo.getExtensionDirs());
        ArrayList<LibraryLocation> allLibs = new ArrayList<LibraryLocation>(bootpath.length + extensions.size());
        int i = 0;
        while (i < bootpath.length) {
            Path path = new Path(bootpath[i]);
            File lib = path.toFile();
            if (lib.exists() && lib.isFile()) {
                allLibs.add(new LibraryLocation((IPath)path, this.getDefaultSystemLibrarySource(lib), this.getDefaultPackageRootPath()));
            }
            ++i;
        }
        Iterator iter = extensions.iterator();
        while (iter.hasNext()) {
            LibraryLocation lib = (LibraryLocation)iter.next();
            if (this.isDuplicateLibrary(allLibs, lib)) continue;
            allLibs.add(lib);
        }
        return allLibs.toArray(new LibraryLocation[allLibs.size()]);
    }

    private boolean isDuplicateLibrary(List libs, LibraryLocation dup) {
        String osPath = dup.getSystemLibraryPath().toOSString();
        int i = 0;
        while (i < libs.size()) {
            LibraryLocation location = (LibraryLocation)libs.get(i);
            if (location.getSystemLibraryPath().toOSString().equalsIgnoreCase(osPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected LibraryInfo getDefaultLibraryInfo(File installLocation) {
        IPath rtjar = this.getDefaultSystemLibrary(installLocation);
        File extDir = this.getDefaultExtensionDirectory(installLocation);
        File endDir = this.getDefaultEndorsedDirectory(installLocation);
        String[] dirs = null;
        dirs = extDir == null ? new String[]{} : new String[]{extDir.getAbsolutePath()};
        String[] endDirs = null;
        endDirs = endDir == null ? new String[]{} : new String[]{endDir.getAbsolutePath()};
        return new LibraryInfo("???", new String[]{rtjar.toOSString()}, dirs, endDirs);
    }

    protected List gatherAllLibraries(String[] dirPaths) {
        ArrayList<LibraryLocation> libraries = new ArrayList<LibraryLocation>();
        int i = 0;
        while (i < dirPaths.length) {
            File extDir = new File(dirPaths[i]);
            if (extDir != null && extDir.exists() && extDir.isDirectory()) {
                String[] names = extDir.list();
                int j = 0;
                while (j < names.length) {
                    String suffix;
                    int length;
                    String name = names[j];
                    File jar = new File(extDir, name);
                    if (jar.isFile() && (length = name.length()) > 4 && ((suffix = name.substring(length - 4)).equalsIgnoreCase(".zip") || suffix.equalsIgnoreCase(".jar"))) {
                        try {
                            Path libPath = new Path(jar.getCanonicalPath());
                            LibraryLocation library = new LibraryLocation((IPath)libPath, (IPath)Path.EMPTY, (IPath)Path.EMPTY);
                            libraries.add(library);
                        }
                        catch (IOException e) {
                            LaunchingPlugin.log(e);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return libraries;
    }

    protected File getDefaultExtensionDirectory(File installLocation) {
        File jre = null;
        jre = installLocation.getName().equalsIgnoreCase("jre") ? installLocation : new File(installLocation, "jre");
        File lib = new File(jre, "lib");
        File ext = new File(lib, "ext");
        return ext;
    }

    protected File getDefaultEndorsedDirectory(File installLocation) {
        File lib = new File(installLocation, "lib");
        File ext = new File(lib, "endorsed");
        return ext;
    }

    protected String getDefaultRootPath() {
        return this.fDefaultRootPath;
    }

    protected void setDefaultRootPath(String defaultRootPath) {
        this.fDefaultRootPath = defaultRootPath;
    }

    public IStatus validateInstallLocation(File javaHome) {
        File javaExecutable;
        Status status = null;
        status = Platform.getOS().equals("macosx") ? new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.getString("StandardVMType.Standard_VM_not_supported_on_MacOS._1"), null) : ((javaExecutable = StandardVMType.findJavaExecutable(javaHome)) == null ? new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.getString("StandardVMType.Not_a_JDK_Root;_Java_executable_was_not_found_1"), null) : (this.canDetectDefaultSystemLibraries(javaHome, javaExecutable) ? new Status(0, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.getString("StandardVMType.ok_2"), null) : new Status(4, LaunchingPlugin.getUniqueIdentifier(), 0, LaunchingMessages.getString("StandardVMType.Not_a_JDK_root._System_library_was_not_found._1"), null)));
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected LibraryInfo generateLibraryInfo(File javaHome, File javaExecutable) {
        LibraryInfo info;
        block12: {
            info = null;
            IPath classesZip = new Path(javaHome.getAbsolutePath()).append("lib").append("classes.zip");
            if (classesZip.toFile().exists()) {
                return new LibraryInfo("1.1.x", new String[]{classesZip.toOSString()}, new String[0], new String[0]);
            }
            File file = LaunchingPlugin.getFileInPlugin((IPath)new Path("lib\\launchingsupport.jar"));
            if (file.exists()) {
                String javaExecutablePath = javaExecutable.getAbsolutePath();
                String[] cmdLine = new String[]{javaExecutablePath, "-classpath", file.getAbsolutePath(), "org.eclipse.jdt.internal.launching.support.LibraryDetector"};
                Process p = null;
                try {
                    try {
                        p = Runtime.getRuntime().exec(cmdLine);
                        IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)"Library Detection");
                        int i = 0;
                        while (i < 200 && !process.isTerminated()) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++i;
                        }
                        info = this.parseLibraryInfo(process);
                    }
                    catch (IOException ioe) {
                        LaunchingPlugin.log(ioe);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (p != null) {
                        p.destroy();
                    }
                    throw throwable;
                }
                {
                    Object var11_14 = null;
                    if (p == null) break block12;
                    p.destroy();
                }
            }
        }
        if (info == null) {
            LaunchingPlugin.log(MessageFormat.format("Failed to retrieve default libraries for {0}", javaHome.getAbsolutePath()));
        }
        return info;
    }

    protected LibraryInfo parseLibraryInfo(IProcess process) {
        int index;
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        String text = null;
        if (streamsProxy != null) {
            text = streamsProxy.getOutputStreamMonitor().getContents();
        }
        if (text != null && text.length() > 0 && (index = text.indexOf("|")) > 0) {
            String version = text.substring(0, index);
            if ((index = (text = text.substring(index + 1)).indexOf("|")) > 0) {
                String bootPaths = text.substring(0, index);
                String[] bootPath = this.parsePaths(bootPaths);
                if ((index = (text = text.substring(index + 1)).indexOf("|")) > 0) {
                    String extDirPaths = text.substring(0, index);
                    String endorsedDirsPath = text.substring(index + 1);
                    String[] extDirs = this.parsePaths(extDirPaths);
                    String[] endDirs = this.parsePaths(endorsedDirsPath);
                    return new LibraryInfo(version, bootPath, extDirs, endDirs);
                }
            }
        }
        return null;
    }

    protected String[] parsePaths(String paths) {
        String path;
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        int index = paths.indexOf(File.pathSeparatorChar, pos);
        while (index > 0) {
            path = paths.substring(pos, index);
            list.add(path);
            pos = index + 1;
            index = paths.indexOf(File.pathSeparatorChar, pos);
        }
        path = paths.substring(pos);
        if (!path.equals("null")) {
            list.add(path);
        }
        return list.toArray(new String[list.size()]);
    }

    public void disposeVMInstall(String id) {
        IVMInstall vm = this.findVMInstall(id);
        if (vm != null) {
            LaunchingPlugin.setLibraryInfo(vm.getInstallLocation().getAbsolutePath(), null);
        }
        super.disposeVMInstall(id);
    }

    public URL getDefaultJavadocLocation(File installLocation) {
        String version;
        LibraryInfo libInfo;
        File javaExecutable = StandardVMType.findJavaExecutable(installLocation);
        if (javaExecutable != null && (libInfo = this.getLibraryInfo(installLocation, javaExecutable)) != null && (version = libInfo.getVersion()) != null) {
            try {
                if (version.startsWith("1.4.2")) {
                    return new URL("http://java.sun.com/j2se/1.4.2/docs/api");
                }
                if (version.startsWith("1.4.1")) {
                    return new URL("http://java.sun.com/j2se/1.4.1/docs/api");
                }
                if (version.startsWith("1.4.0")) {
                    return new URL("http://java.sun.com/j2se/1.4/docs/api");
                }
                if (version.startsWith("1.3")) {
                    return new URL("http://java.sun.com/j2se/1.3/docs/api");
                }
                if (version.startsWith("1.2")) {
                    return new URL("http://java.sun.com/products/jdk/1.2/docs/api");
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }
}

