/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.commands.CommandEvent;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandListener;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.commands.NotHandledException;
import org.eclipse.ui.internal.commands.MutableCommandManager;
import org.eclipse.ui.internal.util.Util;

final class Command
implements ICommand {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL;
    private String categoryId;
    private List commandListeners;
    private Set commandsWithListeners;
    private boolean defined;
    private String description;
    private IHandler handler;
    private transient int hashCode;
    private transient boolean hashCodeComputed;
    private String id;
    private List keySequenceBindings;
    private IKeySequenceBinding[] keySequenceBindingsAsArray;
    private String name;
    private transient String string;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.Command");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    Command(Set commandsWithListeners, String id) {
        if (commandsWithListeners == null || id == null) {
            throw new NullPointerException();
        }
        this.commandsWithListeners = commandsWithListeners;
        this.id = id;
    }

    public void addCommandListener(ICommandListener commandListener) {
        if (commandListener == null) {
            throw new NullPointerException();
        }
        if (this.commandListeners == null) {
            this.commandListeners = new ArrayList();
        }
        if (!this.commandListeners.contains(commandListener)) {
            this.commandListeners.add(commandListener);
        }
        this.commandsWithListeners.add(this);
    }

    public int compareTo(Object object) {
        Command castedObject = (Command)object;
        int compareTo = Util.compare((Comparable)((Object)this.categoryId), (Comparable)((Object)castedObject.categoryId));
        if (compareTo == 0 && (compareTo = Util.compare(this.defined, castedObject.defined)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.description), (Comparable)((Object)castedObject.description))) == 0 && (compareTo = Util.compare(this.handler, castedObject.handler)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)castedObject.id))) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)castedObject.name));
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Command)) {
            return false;
        }
        Command castedObject = (Command)object;
        boolean equals = true;
        equals &= Util.equals(this.categoryId, castedObject.categoryId);
        equals &= Util.equals(this.defined, castedObject.defined);
        equals &= Util.equals(this.description, castedObject.description);
        equals &= Util.equals(this.handler, castedObject.handler);
        equals &= Util.equals(this.id, castedObject.id);
        equals &= Util.equals(this.keySequenceBindings, castedObject.keySequenceBindings);
        return equals &= Util.equals(this.name, castedObject.name);
    }

    public Object execute(Map parameterValuesByName) throws ExecutionException, NotHandledException {
        IHandler handler = this.handler;
        if (MutableCommandManager.DEBUG_COMMAND_EXECUTION) {
            System.out.print("KEYS >>>     executing ");
            if (handler == null) {
                System.out.print("no handler");
            } else {
                System.out.print("'");
                System.out.print(handler.getClass().getName());
                System.out.print("' (");
                System.out.print(handler.hashCode());
                System.out.print(")");
            }
            System.out.println();
        }
        if (handler != null) {
            return handler.execute(parameterValuesByName);
        }
        throw new NotHandledException("There is no handler to execute.");
    }

    void fireCommandChanged(CommandEvent commandEvent) {
        if (commandEvent == null) {
            throw new NullPointerException();
        }
        if (this.commandListeners != null) {
            int i = 0;
            while (i < this.commandListeners.size()) {
                ((ICommandListener)this.commandListeners.get(i)).commandChanged(commandEvent);
                ++i;
            }
        }
    }

    public Map getAttributeValuesByName() throws NotHandledException {
        IHandler handler = this.handler;
        if (handler != null) {
            return handler.getAttributeValuesByName();
        }
        throw new NotHandledException("There is no handler from which to retrieve attributes.");
    }

    public String getCategoryId() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException("Cannot get category identifier from an undefined command.");
        }
        return this.categoryId;
    }

    public String getDescription() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException("Cannot get a description from an undefined command.");
        }
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public List getKeySequenceBindings() {
        return this.keySequenceBindings;
    }

    public String getName() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException("Cannot get the name from an undefined command.");
        }
        return this.name;
    }

    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.categoryId);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.defined);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.description);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.handler);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.keySequenceBindings);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.name);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public boolean isHandled() {
        if (this.handler == null) {
            return false;
        }
        Map attributeValuesByName = this.handler.getAttributeValuesByName();
        return !attributeValuesByName.containsKey("handled") || Boolean.TRUE.equals(attributeValuesByName.get("handled"));
    }

    public void removeCommandListener(ICommandListener commandListener) {
        if (commandListener == null) {
            throw new NullPointerException();
        }
        if (this.commandListeners != null) {
            this.commandListeners.remove(commandListener);
            if (this.commandListeners.isEmpty()) {
                this.commandsWithListeners.remove(this);
            }
        }
    }

    boolean setCategoryId(String categoryId) {
        if (!Util.equals(categoryId, this.categoryId)) {
            this.categoryId = categoryId;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDefined(boolean defined) {
        if (defined != this.defined) {
            this.defined = defined;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDescription(String description) {
        if (!Util.equals(description, this.description)) {
            this.description = description;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setHandler(IHandler handler) {
        if (handler != this.handler) {
            this.handler = handler;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            if (MutableCommandManager.DEBUG_HANDLERS && (MutableCommandManager.DEBUG_HANDLERS_COMMAND_ID == null || MutableCommandManager.DEBUG_HANDLERS_COMMAND_ID.equals(this.id))) {
                System.out.print("HANDLERS >>> Command('" + this.id + "' has changed to ");
                if (handler == null) {
                    System.out.println("no handler");
                } else {
                    System.out.print("'");
                    System.out.print(handler);
                    System.out.println("' as its handler");
                }
            }
            return true;
        }
        return false;
    }

    boolean setKeySequenceBindings(List keySequenceBindings) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.commands.IKeySequenceBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Util.equals(keySequenceBindings = Util.safeCopy(keySequenceBindings, (Class)clazz), this.keySequenceBindings)) {
            this.keySequenceBindings = keySequenceBindings;
            this.keySequenceBindingsAsArray = this.keySequenceBindings.toArray(new IKeySequenceBinding[this.keySequenceBindings.size()]);
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setName(String name) {
        if (!Util.equals(name, this.name)) {
            this.name = name;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.categoryId);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.handler);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.keySequenceBindings);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

