/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.gestures;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.gestures.Capture;
import org.eclipse.ui.internal.gestures.CaptureEvent;
import org.eclipse.ui.internal.gestures.ICaptureListener;
import org.eclipse.ui.internal.gestures.Point;
import org.eclipse.ui.keys.SWTKeySupport;

public final class GestureSupport {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz;
        Display display = new Display();
        Rectangle bounds = display.getBounds();
        Shell shell = new Shell(display);
        if (bounds.height >= 300 && bounds.width >= 400) {
            shell.setBounds((bounds.x + bounds.width - 400) / 2, (bounds.y + bounds.height - 300) / 2, 400, 300);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.gestures.GestureSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        shell.setText(clazz.getName());
        shell.open();
        Capture capture = new Capture();
        capture.addCaptureListener(new ICaptureListener(){

            public void capture(CaptureEvent captureEvent) {
                System.out.println("Pen: " + captureEvent.getPen() + " Key Stroke: " + SWTKeySupport.convertAcceleratorToKeyStroke(captureEvent.getData()) + " Points: " + captureEvent.getPoints().length + " Gesture: " + GestureSupport.recognize(captureEvent.getPoints(), 20));
            }
        });
        capture.setControl((Control)shell);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static String recognize(Point[] points, int sensitivity) {
        char stroke = '\u0000';
        StringBuffer sequence = new StringBuffer();
        int x0 = 0;
        int y0 = 0;
        int i = 0;
        while (i < points.length) {
            Point point = points[i];
            if (i == 0) {
                x0 = point.getX();
                y0 = point.getY();
            } else {
                int x1 = point.getX();
                int y1 = point.getY();
                int dx = (x1 - x0) / sensitivity;
                int dy = (y1 - y0) / sensitivity;
                if (dx != 0 || dy != 0) {
                    if (dx > 0 && stroke != 'E') {
                        stroke = 'E';
                        sequence.append('E');
                    } else if (dx < 0 && stroke != 'W') {
                        stroke = 'W';
                        sequence.append('W');
                    } else if (dy > 0 && stroke != 'S') {
                        stroke = 'S';
                        sequence.append('S');
                    } else if (dy < 0 && stroke != 'N') {
                        stroke = 'N';
                        sequence.append('N');
                    }
                    x0 = x1;
                    y0 = y1;
                }
            }
            ++i;
        }
        return sequence.toString();
    }

    private GestureSupport() {
    }
}

