/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import mergedoc.MergeDocException;
import mergedoc.core.Preference;
import mergedoc.ui.ComponentFactory;
import mergedoc.ui.EntryCheckBox;
import mergedoc.ui.FileChooserField;
import mergedoc.ui.MessageDialog;
import mergedoc.ui.PreviewScrollPane;
import mergedoc.ui.TitledPanel;
import mergedoc.xml.ConfigManager;
import mergedoc.xml.Persister;
import mergedoc.xml.ReplaceEntry;

public class PreferencePanel
extends JPanel {
    private FileChooserField docField = new FileChooserField();
    private FileChooserField srcField = new FileChooserField();
    private FileChooserField outField = new FileChooserField();
    private PreviewScrollPane previewScrollPane;
    private JSplitPane splitPane = new JSplitPane();
    private List entryCheckList = new ArrayList();
    private MessageDialog dialog;

    public PreferencePanel(MessageDialog messageDialog) throws MergeDocException {
        this.dialog = messageDialog;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.setMaximumSize(ComponentFactory.createMaxDimension());
        this.add(this.createUpperPanel());
        this.add(ComponentFactory.createSpacer(0, 7));
        this.add(this.createLowerPanel());
    }

    private JComponent createUpperPanel() throws MergeDocException {
        this.docField.getLabel().setText("API \u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        this.srcField.getLabel().setText("\u5165\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb");
        this.outField.getLabel().setText("\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb");
        this.docField.setDirectoryOnly(true);
        this.docField.setCharset(Charset.forName("ISO-2022-JP"));
        this.docField.setChooseListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencePanel.this.resolveFilePath();
            }
        });
        TitledPanel titledPanel = new TitledPanel("\u57fa\u672c\u8a2d\u5b9a");
        ((Container)titledPanel).add(this.docField);
        ((Container)titledPanel).add(this.srcField);
        ((Container)titledPanel).add(this.outField);
        String string = System.getProperty("target.directory");
        if (string != null) {
            File file = new File(string);
            if (!file.exists() || file.isFile()) {
                throw new MergeDocException("\u30aa\u30d7\u30b7\u30e7\u30f3 target.directory \u306b\u6307\u5b9a\u3055\u308c\u305f\u5024 " + string + " \u306f\n\u5b58\u5728\u3057\u306a\u3044\u304b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
            File file2 = this.searchDocDirectory(file);
            if (file2 != null) {
                this.docField.setFile(file2);
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = fileArray[i].getName();
                if (!string2.equals("src.zip") && !string2.equals("src.jar")) continue;
                String string3 = fileArray[i].getPath();
                String string4 = string3.replaceFirst("src....$", "srcja.zip");
                this.srcField.setFile(new File(string3));
                this.outField.setFile(new File(string4));
            }
        }
        this.loadPersister(this.docField, Persister.DOC_DIR, Persister.DOC_ENC);
        this.loadPersister(this.srcField, Persister.IN_FILE, Persister.IN_ENC);
        this.loadPersister(this.outField, Persister.OUT_FILE, Persister.OUT_ENC);
        return titledPanel;
    }

    private JComponent createLowerPanel() throws MergeDocException {
        JComponent jComponent;
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        List list = ConfigManager.getInstance().getGlobalEntries();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (ReplaceEntry)object2.next();
            jComponent = new EntryCheckBox((ReplaceEntry)object);
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PreferencePanel.this.previewScrollPane.updatePreview(PreferencePanel.this.entryCheckList);
                }
            });
            jPanel.add(jComponent);
            this.entryCheckList.add(jComponent);
        }
        object2 = ComponentFactory.createScrollPane(jPanel);
        ((JScrollPane)object2).getVerticalScrollBar().setUnitIncrement(10);
        this.previewScrollPane = new PreviewScrollPane(this.dialog);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setOrientation(0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setTopComponent((Component)object2);
        this.splitPane.setBottomComponent(this.previewScrollPane);
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 0));
        ((Container)object).add(this.splitPane);
        jComponent = new TitledPanel("\u8a73\u7d30\u8a2d\u5b9a");
        jComponent.setMaximumSize(ComponentFactory.createMaxDimension());
        jComponent.add((Component)object);
        Persister persister = Persister.getInstance();
        int n = persister.getInt(Persister.DETAIL_PANEL_HEIGHT, 88);
        this.splitPane.setDividerLocation(n);
        String[] stringArray = persister.getStrings(Persister.REPLACE_DESCRIPTION_ARRAY);
        Iterator iterator = this.entryCheckList.iterator();
        block1: while (iterator.hasNext()) {
            EntryCheckBox entryCheckBox = (EntryCheckBox)iterator.next();
            ReplaceEntry replaceEntry = entryCheckBox.getReplaceEntry();
            String string = replaceEntry.getDescription();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                entryCheckBox.setSelected(true);
                continue block1;
            }
        }
        this.previewScrollPane.updatePreview(this.entryCheckList);
        return jComponent;
    }

    private void loadPersister(FileChooserField fileChooserField, Persister.Key key, Persister.Key key2) throws MergeDocException {
        String string;
        Persister persister = Persister.getInstance();
        if (fileChooserField.getFile().getPath().equals("") && (string = persister.getString(key, "")).length() > 0) {
            fileChooserField.setFile(new File(string));
        }
        try {
            string = persister.getString(key2);
            fileChooserField.setCharset(Charset.forName(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void resolveFilePath() {
        String string;
        String string2 = this.srcField.getFile().getPath();
        String string3 = this.outField.getFile().getPath();
        if (!string2.equals("") || !string3.equals("")) {
            return;
        }
        for (File file = this.docField.getFile(); file != null; file = file.getParentFile()) {
            string = file + File.separator + "src.";
            File file2 = new File(string + "zip");
            if (file2.exists()) {
                this.srcField.setFile(file2);
                break;
            }
            File file3 = new File(string + "jar");
            if (!file3.exists()) continue;
            this.srcField.setFile(file3);
            break;
        }
        if (!(string2 = this.srcField.getFile().getPath()).equals("")) {
            string = string2.replaceFirst("src....$", "srcja.zip");
            this.outField.setFile(new File(string));
        }
    }

    public void revalidateLabel() {
        int n;
        int n2 = 0;
        JLabel[] jLabelArray = new JLabel[]{this.docField.getLabel(), this.srcField.getLabel(), this.outField.getLabel()};
        for (n = 0; n < jLabelArray.length; ++n) {
            int n3 = (int)jLabelArray[n].getSize().getWidth();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        for (n = 0; n < jLabelArray.length; ++n) {
            JLabel jLabel = jLabelArray[n];
            ComponentFactory.ensureSize(jLabel, n2, jLabel.getHeight());
            jLabel.revalidate();
        }
    }

    private File searchDocDirectory(File file) {
        File file2 = null;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (file3.isFile()) {
                if (file3.getName().equals("package-list")) {
                    file2 = file;
                }
            } else {
                file2 = this.searchDocDirectory(file3);
            }
            if (file2 != null) break;
        }
        return file2;
    }

    public ReplaceEntry[] getSelectedEntries() {
        ArrayList<ReplaceEntry> arrayList = new ArrayList<ReplaceEntry>();
        ReplaceEntry[] replaceEntryArray = this.entryCheckList.iterator();
        while (replaceEntryArray.hasNext()) {
            EntryCheckBox entryCheckBox = (EntryCheckBox)replaceEntryArray.next();
            if (!entryCheckBox.isSelected()) continue;
            ReplaceEntry replaceEntry = entryCheckBox.getReplaceEntry();
            arrayList.add(replaceEntry);
        }
        replaceEntryArray = arrayList.toArray(new ReplaceEntry[arrayList.size()]);
        return replaceEntryArray;
    }

    public Preference getPreference() {
        return new Preference(){
            private File docDir;
            private File srcFile;
            private File outFile;
            private Charset docEnc;
            private Charset srcEnc;
            private Charset outEnc;
            private ReplaceEntry[] entries;
            {
                this.docDir = PreferencePanel.this.docField.getFile();
                this.srcFile = PreferencePanel.this.srcField.getFile();
                this.outFile = PreferencePanel.this.outField.getFile();
                this.docEnc = PreferencePanel.this.docField.getCharset();
                this.srcEnc = PreferencePanel.this.srcField.getCharset();
                this.outEnc = PreferencePanel.this.outField.getCharset();
                this.entries = PreferencePanel.this.getSelectedEntries();
            }

            public File getDocDirectory() {
                return this.docDir;
            }

            public File getInputArchive() {
                return this.srcFile;
            }

            public File getOutputArchive() {
                return this.outFile;
            }

            public Charset getDocEncoding() {
                return this.docEnc;
            }

            public Charset getInputEncoding() {
                return this.srcEnc;
            }

            public Charset getOutputEncoding() {
                return this.outEnc;
            }

            public ReplaceEntry[] getGlobalEntries() {
                return this.entries;
            }
        };
    }

    public void persistent() throws MergeDocException {
        Preference preference = this.getPreference();
        Persister persister = Persister.getInstance();
        persister.setString(Persister.DOC_DIR, preference.getDocDirectory().getPath());
        persister.setString(Persister.IN_FILE, preference.getInputArchive().getPath());
        persister.setString(Persister.OUT_FILE, preference.getOutputArchive().getPath());
        persister.setString(Persister.DOC_ENC, preference.getDocEncoding().toString());
        persister.setString(Persister.IN_ENC, preference.getInputEncoding().toString());
        persister.setString(Persister.OUT_ENC, preference.getOutputEncoding().toString());
        persister.setInt(Persister.DETAIL_PANEL_HEIGHT, this.splitPane.getDividerLocation());
        ReplaceEntry[] replaceEntryArray = preference.getGlobalEntries();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < replaceEntryArray.length; ++i) {
            arrayList.add(replaceEntryArray[i].getDescription());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        persister.setStrings(Persister.REPLACE_DESCRIPTION_ARRAY, stringArray);
    }
}

