/*
 * Copyright (c) 2003 Shinji Kashihara. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies
 * this distribution, and is available at cpl-v10.html.
 */
package mergedoc.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

/**
 * Java ソースをあらわすクラスです。
 * @author Shinji Kashihara
 */
public class Java {

    /** クラス名 */
    private final String className;

    /** ソース文字列 */
    private final String text;

    /** Java ファイル拡張子 */
    public static final String FILE_EXT = ".java";

    /**
     * コンストラクタです。
     * 指定された入力ストリームから Java ソース文字列を読込みます。
     * 入力ストリームはこのインスタンス生成後に呼び出し側でクローズしてください。
     * 
     * @param className クラス名 
     * @param is Java ソース入力ストリーム
     * @param charset 文字セット
     * @throws IOException 入出力例外が発生した場合
     */
    public Java(String className, InputStream is, Charset charset)
        throws IOException
    {
        this.className = className;

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        for (int size = 0; (size = is.read(buf)) > 0;) {
            baos.write(buf, 0, size);
        }
        baos.close();
        String str = baos.toString(charset.name());
        this.text = StringUtils.optimizeLineSeparator(str);
    }
    
    /**
     * Java ソースのクラス名を取得します。
     * @return クラス名
     */
    public String getClassName() {
        return className;
    }
    
    /**
     * Java ソース文字列を取得します。
     * @return Java ソース文字列
     */
    public String getText() {
        return text;
    }
}
