/*
 * Copyright (c) 2003 Shinji Kashihara. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies
 * this distribution, and is available at cpl-v10.html.
 */
package mergedoc.ui;

import javax.swing.JFrame;
import javax.swing.JOptionPane;


/**
 * メッセージダイアログです。
 * @author Shinji Kashihara
 */
public class MessageDialog {
    
    /** 親フレーム */
    private final JFrame frame;
    
    /**
     * コンストラクタです。
     * @param frame 親フレーム
     */
    public MessageDialog(JFrame frame) {
        this.frame = frame;
    }
    
    /**
     * 確認メッセージを表示します．
     * @param message メッセージ
     * @return ユーザの選択結果。JOptionPane の定数フィールドを参照。
     */    
    public int showConfirmMessage(String message) {
        return JOptionPane.showConfirmDialog(
            frame, message, "確認", JOptionPane.YES_NO_OPTION);
    }
    
    /**
     * エラーメッセージを表示します．
     * @param message メッセージ
     */    
    public void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(
            frame, message, "エラー", JOptionPane.ERROR_MESSAGE);
    }
}
