/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.event.ChangeListener;
import mergedoc.MergeDocException;
import mergedoc.core.APIDocument;
import mergedoc.core.Comment;
import mergedoc.core.Java;
import mergedoc.core.JavaBuffer;
import mergedoc.core.Preference;
import mergedoc.core.Signature;
import mergedoc.core.StringUtils;
import mergedoc.core.WorkingState;
import mergedoc.xml.ConfigManager;
import mergedoc.xml.ReplaceEntry;
import mergedoc.xml.ReplaceHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MergeManager {
    private Preference pref;
    private WorkingState workingState = new WorkingState();

    public void setPreference(Preference preference) {
        this.pref = preference;
        this.workingState.initialize();
    }

    public void validate() throws MergeDocException {
        File file;
        File file2 = this.pref.getDocDirectory();
        if (file2 != null && file2.getPath().length() > 0 && !(file = new File(file2, "allclasses-frame.html")).exists()) {
            throw new MergeDocException("\u6b63\u3057\u3044 API \u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\u6307\u5b9a\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u306f allclasses-frame.html \u30d5\u30a1\u30a4\u30eb\u304c\n\u542b\u307e\u308c\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        file = this.pref.getInputArchive();
        if (file == null || file.getPath().equals("")) {
            throw new MergeDocException("\u5165\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.entrySize() == 0) {
            throw new MergeDocException("\u6b63\u3057\u3044\u5165\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        File file3 = this.pref.getOutputArchive();
        if (file3 == null || file3.getPath().equals("")) {
            throw new MergeDocException("\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (file3.equals(file)) {
            throw new MergeDocException("\u5165\u529b\u3001\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u306b\u540c\u3058\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002\n\u6b63\u3057\u3044\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.pref.getOutputArchive().exists()) {
            if (!file3.canWrite()) {
                throw new MergeDocException("\u6307\u5b9a\u3055\u308c\u305f\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u306f\u66f8\u304d\u8fbc\u307f\u4e0d\u53ef\u3067\u3059\u3002\n\u6b63\u3057\u3044\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        } else {
            try {
                file3.createNewFile();
                file3.delete();
            }
            catch (IOException iOException) {
                throw new MergeDocException("\u6b63\u3057\u3044\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MergeDocException, SAXException, IOException {
        ZipOutputStream zipOutputStream;
        block6: {
            if (this.workingState.isCanceled()) {
                return;
            }
            ZipInputStream zipInputStream = null;
            zipOutputStream = null;
            try {
                zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.pref.getInputArchive())));
                zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.pref.getOutputArchive())));
                zipOutputStream.setLevel(1);
                long l = System.currentTimeMillis();
                this.merge(zipInputStream, zipOutputStream);
                long l2 = System.currentTimeMillis();
                this.workingState.setWorkTime((l2 - l) / 1000L);
                Object var8_5 = null;
                if (zipInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
                if (zipOutputStream != null && this.workingState.getChangedCount() > 0) {
                    zipOutputStream.close();
                }
                throw throwable;
            }
            zipInputStream.close();
        }
        if (zipOutputStream != null && this.workingState.getChangedCount() > 0) {
            zipOutputStream.close();
        }
    }

    private void merge(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws MergeDocException, SAXException, IOException {
        String string = System.getProperty("target.class", "");
        string = string.replaceAll("\\.", "/");
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            Object object;
            Object object2;
            if (this.workingState.isCanceled()) {
                return;
            }
            byte[] byArray = null;
            String string2 = zipEntry.getName().replaceFirst("^src/", "");
            if (!string2.startsWith(string)) continue;
            if (string2.endsWith(".java")) {
                object2 = string2.replaceFirst("\\.java$", "").replaceAll("/", "\\.");
                object = new Java((String)object2, zipInputStream, this.pref.getInputEncoding());
                zipInputStream.closeEntry();
                String string3 = this.mergeEntry((Java)object);
                string3 = StringUtils.expand8Tab(string3);
                string3 = this.doFilter(((Java)object).getClassName(), string3);
                byArray = string3.getBytes(this.pref.getOutputEncoding());
                this.workingState.changeWorkingText(((Java)object).getClassName());
            } else {
                object2 = new ByteArrayOutputStream();
                object = new byte[1024];
                int n = 0;
                while ((n = zipInputStream.read((byte[])object)) > 0) {
                    ((ByteArrayOutputStream)object2).write((byte[])object, 0, n);
                }
                ((ByteArrayOutputStream)object2).close();
                byArray = ((ByteArrayOutputStream)object2).toByteArray();
            }
            object2 = new ZipEntry(zipEntry.getName());
            zipOutputStream.putNextEntry((ZipEntry)object2);
            zipOutputStream.write(byArray);
            zipOutputStream.closeEntry();
        }
    }

    private String mergeEntry(Java java) throws IOException {
        Object object;
        APIDocument aPIDocument = new APIDocument(this.pref.getDocDirectory(), java.getClassName(), this.pref.getDocEncoding());
        if (aPIDocument.isEmpty()) {
            return java.getText();
        }
        JavaBuffer javaBuffer = new JavaBuffer(java);
        while (javaBuffer.nextComment()) {
            object = javaBuffer.getSignature();
            Comment comment = aPIDocument.getComment((Signature)object);
            javaBuffer.setLocalizedComment(comment);
        }
        object = javaBuffer.finishToString();
        return object;
    }

    private String doFilter(String string, String string2) throws MergeDocException, SAXException, IOException {
        ReplaceEntry[] replaceEntryArray;
        String string3 = string.replaceAll("\\.", "/") + ".xml";
        ConfigManager configManager = ConfigManager.getInstance();
        File file = configManager.getFile(string3);
        if (file.exists()) {
            replaceEntryArray = configManager.getSAXPerser();
            ReplaceHandler replaceHandler = new ReplaceHandler(string2);
            replaceEntryArray.parse(file, (DefaultHandler)replaceHandler);
            string2 = replaceHandler.getResult();
        }
        replaceEntryArray = this.pref.getGlobalEntries();
        for (int i = 0; i < replaceEntryArray.length; ++i) {
            ReplaceEntry replaceEntry = replaceEntryArray[i];
            string2 = replaceEntry.replace(string2);
        }
        return string2;
    }

    public int entrySize() {
        int n = 0;
        try {
            ZipFile zipFile = new ZipFile(this.pref.getInputArchive());
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().endsWith(".java")) continue;
                ++n;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.workingState.setChangeListener(changeListener);
    }

    public WorkingState getWorkingState() {
        return this.workingState;
    }
}

