/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import mergedoc.ui.ComponentFactory;

public class ProgressPanel
extends JPanel {
    private JProgressBar progressBar = new JProgressBar();
    private JTextArea textArea = new JTextArea(3, 100);

    public ProgressPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.setMaximumSize(ComponentFactory.createMaxDimension());
        int n = (int)ComponentFactory.createMaxDimension().getWidth();
        this.progressBar.setMaximumSize(new Dimension(n, 10));
        this.progressBar.setStringPainted(true);
        this.textArea.setMaximumSize(ComponentFactory.createMaxDimension());
        this.textArea.setEditable(false);
        this.add(this.progressBar);
        this.add(ComponentFactory.createSpacer(0, 5));
        this.add(ComponentFactory.createScrollPane(this.textArea));
    }

    public void init() {
        this.progressBar.setString(null);
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(true);
        this.textArea.setText(null);
    }

    public void setMaximum(int n) {
        this.progressBar.setMaximum(n);
    }

    public void addListText(final String string) {
        if (this.progressBar.isIndeterminate()) {
            this.progressBar.setIndeterminate(false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = ProgressPanel.this.progressBar.getValue() + 1;
                ProgressPanel.this.progressBar.setValue(n);
                if (n > 1) {
                    ProgressPanel.this.textArea.append("\n");
                }
                ProgressPanel.this.textArea.append(string);
            }
        });
    }

    public void setBarText(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressPanel.this.progressBar.setIndeterminate(false);
                ProgressPanel.this.progressBar.setString(string);
            }
        });
    }
}

