/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mergedoc.core.Comment;
import mergedoc.core.Signature;
import mergedoc.core.StringUtils;

public class APIDocument {
    private final Map contextTable = new HashMap();
    private static final Pattern linkPattern = Pattern.compile("<A HREF=\"(.+?)\"><CODE>.+?</CODE></A>");

    public APIDocument(File file, String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(file.getPath());
        stringBuffer.append(File.separator);
        stringBuffer.append(string.replaceAll("\\.", StringUtils.escapeMetaCharactor(File.separator)));
        stringBuffer.append(".html");
        CachedFile cachedFile = new CachedFile(stringBuffer.toString());
        this.load(file, cachedFile, string2);
        String string3 = cachedFile.getName().replaceFirst("\\.html$", "");
        Pattern pattern = Pattern.compile(string3 + "\\..+\\.html$");
        File[] fileArray = ((File)cachedFile).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!pattern.matcher(file2.getName()).matches()) continue;
            this.load(file, file2, string2);
        }
    }

    private void load(File file, File file2, String string) throws IOException {
        String string2 = null;
        if (file2.canRead()) {
            char c;
            FileInputStream fileInputStream = new FileInputStream(file2);
            byte[] byArray = new byte[((InputStream)fileInputStream).available()];
            ((InputStream)fileInputStream).read(byArray);
            ((InputStream)fileInputStream).close();
            if (string.equals("ISO-2022-JP")) {
                for (c = '\u0001'; c < byArray.length; ++c) {
                    if (byArray[c - 1] != 27 || byArray[c] != 27) continue;
                    byArray[c - '\u0001'] = 32;
                    byArray[c] = 27;
                }
            }
            string2 = new String(byArray, string);
            string2 = StringUtils.optimizeLineSeparator(string2);
            c = (char)Integer.decode("0x301c").intValue();
            string2 = string2.replace(c, '\uff5e');
            String string3 = file2.getPath().replaceFirst("\\.html$", "");
            string3 = string3.replaceFirst(StringUtils.escapeMetaCharactor(file.getPath() + File.separator), "");
            string3 = string3.replaceAll(StringUtils.escapeMetaCharactor(File.separator), ".");
            this.parseClassComment(string3, string2);
            this.parseMethodComment(string3, string2);
        }
    }

    public boolean isEmpty() {
        return this.contextTable.isEmpty();
    }

    public Comment getComment(Signature signature) {
        Comment comment = (Comment)this.contextTable.get(signature);
        return comment;
    }

    private void parseClassComment(String string, CharSequence charSequence) {
        String string2 = "<HR>\n(|<B>.+?<P>\n)<DL>\n<DT>(.+?)</B>.*?</DL>\n\n<P>\n(.+?\n<HR>\n)\n<P>\n";
        Pattern pattern = Pattern.compile(string2, 32);
        Matcher matcher = pattern.matcher(charSequence);
        if (matcher.find()) {
            String string3 = matcher.group(2);
            Signature signature = this.createSignature(string, string3);
            Comment comment = new Comment();
            String string4 = matcher.group(1);
            this.parseDeprecatedTag(string, string4, comment);
            String string5 = matcher.group(3);
            Pattern pattern2 = Pattern.compile("(.+?)(|\n<P>\n)\n<P>\n<(DL|HR)>\n", 32);
            Matcher matcher2 = pattern2.matcher(string5);
            if (matcher2.find()) {
                String string6 = matcher2.group(1);
                string6 = this.formatLinkTag(string, string6);
                comment.setDescription(string6);
            }
            this.parseCommonTag(string, string5, comment);
            this.contextTable.put(signature, comment);
        }
    }

    private void parseMethodComment(String string, CharSequence charSequence) {
        String string2 = "<A NAME=.+?<!-- --></A><H3>\n.+?</H3>\n<PRE>\n(.*?)</PRE>\n(.+?)(<HR>|<!-- =)";
        Pattern pattern = Pattern.compile(string2, 32);
        Matcher matcher = pattern.matcher(charSequence);
        while (matcher.find()) {
            String string3;
            String string4;
            Matcher matcher2;
            Pattern pattern2;
            String string5;
            String string6 = matcher.group(1);
            Signature signature = this.createSignature(string, string6);
            Comment comment = new Comment();
            String string7 = matcher.group(2);
            Pattern pattern3 = Pattern.compile("<DL>\n<DD>(.*?)(<DD><DL>\n|</DL>\n|<DL>\n|\n<P>\n+(<DL>|</DL>|<DT>|<DD><DL>))", 32);
            Matcher matcher3 = pattern3.matcher(string7);
            if (matcher3.find()) {
                string5 = matcher3.group(1);
                string5 = string5.replaceFirst("(?s)<B>\u63a8\u5968\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002.*?(\n<P>\n<DD>|$|</B> <DD>)", "");
                string5 = this.formatLinkTag(string, string5);
                comment.setDescription(string5);
            }
            if ((matcher3 = (pattern3 = Pattern.compile("<DT><B>\u30d1\u30e9\u30e1\u30fc\u30bf: </B>(.+?(</DL>|<DT>|\n))")).matcher(string7)).find()) {
                string5 = matcher3.group(1);
                pattern2 = Pattern.compile("<CODE>(.+?)</CODE> - (.*?)(<DD>|</DL>|<DT>|\n)");
                matcher2 = pattern2.matcher(string5);
                while (matcher2.find()) {
                    string4 = matcher2.group(1);
                    string3 = this.formatLinkTag(string, matcher2.group(2));
                    String string8 = string4 + " " + string3;
                    comment.addParam(string8);
                }
            }
            if ((matcher3 = (pattern3 = Pattern.compile("(?s)<DT><B>\u623b\u308a\u5024: </B><DD>(.+?)(</DL>|<DT>)")).matcher(string7)).find()) {
                string5 = matcher3.group(1);
                string5 = this.formatLinkTag(string, string5);
                comment.addReturn(string5);
            }
            if ((matcher3 = (pattern3 = Pattern.compile("(?s)<DT><B>\u4f8b\u5916: </B>\\s*?<DD>(.+?(</DL>|<DT>))")).matcher(string7)).find()) {
                string5 = matcher3.group(1);
                pattern2 = Pattern.compile("<CODE>(.+?)</CODE> - (.*?)(<DD>|</DL>|<DT>|\n)");
                matcher2 = pattern2.matcher(string5);
                while (matcher2.find()) {
                    string4 = matcher2.group(1).replaceAll("(<A .+?>|</A>)", "");
                    string3 = matcher2.group(2);
                    string3 = this.formatLinkTag(string, string3);
                    comment.addThrows(string4 + " " + string3);
                }
            }
            this.parseDeprecatedTag(string, string7, comment);
            this.parseCommonTag(string, string7, comment);
            this.contextTable.put(signature, comment);
        }
    }

    private Signature createSignature(String string, String string2) {
        string2 = string2.replaceAll("\\&nbsp;", " ");
        string2 = string2.replaceAll("<.+?>", " ");
        string2 = string2.replaceFirst("(?s)\\sthrows\\s.*", "");
        Signature signature = new Signature(string, string2);
        return signature;
    }

    private void parseCommonTag(String string, String string2, Comment comment) {
        Pattern pattern = Pattern.compile("(?s)<DT><B>\u95a2\u9023\u9805\u76ee:.+?<DD>(.+?)</DL>");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            Object object;
            Object object2;
            String string3 = matcher.group(1);
            Matcher matcher2 = linkPattern.matcher(string3);
            while (matcher2.find()) {
                object2 = matcher2.group(1);
                object = this.formatClassName(string, (String)object2);
                comment.addSee((String)object);
            }
            object2 = Pattern.compile("<a href=.+?>.+?</a>");
            object = ((Pattern)object2).matcher(string3);
            while (((Matcher)object).find()) {
                comment.addSee(((Matcher)object).group());
            }
        }
        if ((matcher = (pattern = Pattern.compile("(?s)<DT><B>\u5c0e\u5165\u3055\u308c\u305f\u30d0\u30fc\u30b8\u30e7\u30f3:.*?<DD>(.+?)(</DD>)")).matcher(string2)).find()) {
            comment.addSince(matcher.group(1));
        }
    }

    private void parseDeprecatedTag(String string, String string2, Comment comment) {
        Pattern pattern = Pattern.compile("<B>\u63a8\u5968\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002.+?<I>(.+?)</I>");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            String string3 = matcher.group(1);
            string3 = this.formatLinkTag(string, string3);
            comment.addDeprecated(string3);
        }
    }

    private String formatLinkTag(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = linkPattern.matcher(string2);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = this.formatClassName(string, string3);
            String string5 = "{@link " + string4 + "}";
            matcher.appendReplacement(stringBuffer, string5);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String formatClassName(String string, String string2) {
        String string3 = string.replaceFirst(".+\\.", "");
        String string4 = string.replaceFirst("\\." + string3, "");
        string2 = string2.replaceAll("\\.html", "");
        string2 = string2.replaceAll("/", ".");
        string2 = string2.replaceAll("^\\.*", "");
        string2 = string2.replaceAll("java\\.lang\\.", "");
        string2 = string2.replaceAll(string4 + "\\.(\\w+($|#|,|\\)))", "$1");
        string2 = string2.replaceFirst(string3 + "(#)", "$1");
        return string2;
    }

    private static class CachedFile
    extends File {
        private static File cachedDir;
        private static File[] cachedFiles;
        private static final File[] EMPTY_FILES;

        public CachedFile(String string) {
            super(string);
        }

        public File[] listFiles() {
            File file = this.getParentFile();
            if (!file.equals(cachedDir)) {
                cachedDir = file;
                cachedFiles = file.listFiles();
                if (cachedFiles == null) {
                    cachedFiles = EMPTY_FILES;
                }
            }
            return cachedFiles;
        }

        static {
            EMPTY_FILES = new File[0];
        }
    }
}

