/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mergedoc.core.StringUtils;

public class Comment {
    private static final int SMALL_LIST_CAPACITY = 1;
    private static final int LARGE_LIST_CAPACITY = 9;
    private static final int DEFAULT_WIDTH = 80;
    private String sourceComment;
    private Pattern[] importPatterns;
    private String description;
    private String deprecate;
    private List sees;
    private List sinces;
    private List params;
    private List returns;
    private List throwss;
    private List authors;
    private List versions;
    private List serials;
    private List serialFields;
    private List serialDatas;
    private List specs;

    public void setDescription(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = Pattern.compile("(?s)(.)(<p>)(.)").matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1).equals("\n") ? "$1" : "$1\n";
            String string3 = matcher.group(3).equals("\n") ? "$3" : "\n$3";
            matcher.appendReplacement(stringBuffer, string2 + "$2" + string3);
        }
        matcher.appendTail(stringBuffer);
        this.description = stringBuffer.toString();
    }

    public void addDeprecated(String string) {
        this.deprecate = string;
    }

    public void addSee(String string) {
        if (this.sees == null) {
            this.sees = new ArrayList(9);
        }
        this.sees.add(string);
    }

    public void addSince(String string) {
        if (this.sinces == null) {
            this.sinces = new ArrayList(1);
        }
        this.sinces.add(string);
    }

    public void addParam(String string) {
        if (this.params == null) {
            this.params = new ArrayList(9);
        }
        this.params.add(string);
    }

    public void addReturn(String string) {
        if (this.returns == null) {
            this.returns = new ArrayList(1);
        }
        this.returns.add(string);
    }

    public void addThrows(String string) {
        if (this.throwss == null) {
            this.throwss = new ArrayList(9);
        }
        this.throwss.add(string);
    }

    public void mergeSourceComment(String string) {
        this.sourceComment = string;
        Pattern pattern = Pattern.compile("[ \t]+@author[ \t]*(.*)\n");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.addAuthor(matcher.group(1));
        }
        pattern = Pattern.compile("[ \t]+@version[ \t]*(.*)\n");
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.addVersion(matcher.group(1));
        }
        pattern = Pattern.compile("[ \t]+@serial[ \t]*(.*)\n");
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.addSerial(matcher.group(1));
        }
        pattern = Pattern.compile("[ \t]+@serialField[ \t]*(.*)\n");
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.addSerialField(matcher.group(1));
        }
        pattern = Pattern.compile("[ \t]+@serialData[ \t]*(.*)\n");
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.addSerialData(matcher.group(1));
        }
        pattern = Pattern.compile("[ \t]+@spec[ \t]*(.*)\n");
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.addSpec(matcher.group(1));
        }
    }

    private void addAuthor(String string) {
        if (this.authors == null) {
            this.authors = new ArrayList(9);
        }
        this.authors.add(string);
    }

    private void addVersion(String string) {
        if (this.versions == null) {
            this.versions = new ArrayList(1);
        }
        this.versions.add(string);
    }

    private void addSerial(String string) {
        if (this.serials == null) {
            this.serials = new ArrayList(1);
        }
        this.serials.add(string);
    }

    private void addSerialField(String string) {
        if (this.serialFields == null) {
            this.serialFields = new ArrayList(1);
        }
        this.serialFields.add(string);
    }

    private void addSerialData(String string) {
        if (this.serialDatas == null) {
            this.serialDatas = new ArrayList(1);
        }
        this.serialDatas.add(string);
    }

    private void addSpec(String string) {
        if (this.specs == null) {
            this.specs = new ArrayList(1);
        }
        this.specs.add(string);
    }

    public void setImportPaths(List list) {
        if (list == null) {
            return;
        }
        int n = list.size();
        this.importPatterns = new Pattern[n];
        for (int i = 0; i < n; ++i) {
            String string;
            String string2;
            String string3 = (String)list.get(i);
            if (string3.endsWith(".*")) {
                string2 = string3.replaceFirst("\\*$", "");
                string = "(^|\\W)" + string2 + "(\\w+(\\W|$))";
                this.importPatterns[i] = Pattern.compile(string);
                continue;
            }
            string2 = string3.replaceFirst("^(.+?)\\w+$", "$1");
            string = string3.replaceFirst(string2 + "(\\w+)$", "$1");
            String string4 = "(^|\\W)" + string2 + "(" + string + "(\\W|$))";
            this.importPatterns[i] = Pattern.compile(string4);
        }
    }

    public String toString() {
        int n = 2;
        if (this.sourceComment == null) {
            throw new IllegalStateException("Source comment is null. require #setSourceComment.");
        }
        int n2 = StringUtils.heightOf(this.sourceComment);
        if (n2 <= 0) {
            throw new IllegalStateException("Illegal comment height " + n2 + "\n" + this.sourceComment);
        }
        int n3 = n2;
        if (n2 > n) {
            n3 = n2 - n;
        }
        String string = this.sourceComment.replaceFirst("(?s)^([ \t]*?)/\\*\\*.*", "$1");
        if (n2 <= 2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append("/** ");
            if (this.description != null && this.description.length() > 0) {
                String string2 = this.description.replaceAll("\n", "");
                stringBuffer.append(string2);
            } else if (this.sinces != null && this.sinces.size() > 0) {
                stringBuffer.append("@since ");
                String string3 = (String)this.sinces.get(0);
                string3 = string3.replaceAll("\n", "");
                stringBuffer.append(string3);
            }
            if (n2 == 2) {
                stringBuffer.append("\n");
                stringBuffer.append(string);
            }
            stringBuffer.append(" */\n");
            return stringBuffer.toString();
        }
        int n4 = 80 - string.length() - " * ".length();
        OutputComment outputComment = new OutputComment(n3, n4);
        String string4 = outputComment.toString();
        if (string4.length() > 0) {
            if (outputComment.resultHeight() != outputComment.originHeight) {
                string4 = this.resizeComment(outputComment, string4);
            }
            string4 = string4.replaceAll("(?m)^(.+)", string + "$1");
        }
        return string4;
    }

    private String resizeComment(OutputComment outputComment, String string) {
        int n;
        if (outputComment.resultHeight() > outputComment.originHeight) {
            this.shrinkComment(outputComment);
            if (outputComment.resultHeight() > outputComment.originHeight && this.description != null && (n = this.description.indexOf(12290)) != -1) {
                this.description = this.description.substring(0, n + 1);
                outputComment.resetWidth();
                outputComment.rebuild();
                if (outputComment.resultHeight() > outputComment.originHeight) {
                    this.shrinkComment(outputComment);
                }
            }
            string = outputComment.toString();
        }
        if (outputComment.resultHeight() < outputComment.originHeight) {
            n = outputComment.originHeight - outputComment.resultHeight();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("\n");
            }
            string = stringBuffer + string;
        }
        return string;
    }

    private void shrinkComment(OutputComment outputComment) {
        int n;
        String string = "(?s)\\s*/\\*\\*\\s*\\*\\s*@.*";
        if (this.sourceComment.matches(string)) {
            this.description = null;
            outputComment.rebuild();
            if (outputComment.resultHeight() <= outputComment.originHeight) {
                return;
            }
        }
        boolean bl = this.shrinkTagList("@see", this.sees);
        boolean bl2 = this.shrinkTagList("@(throws|exception)", this.throwss);
        boolean bl3 = this.shrinkTagList("@param", this.params);
        boolean bl4 = this.shrinkTagList("@return", this.returns);
        if (bl || bl2 || bl3 || bl4) {
            outputComment.rebuild();
            if (outputComment.resultHeight() <= outputComment.originHeight) {
                return;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("(<.+?>)\n(<.+?>)");
        Matcher matcher = pattern.matcher(outputComment.comment);
        for (n = outputComment.resultHeight(); n > outputComment.originHeight && matcher.find(); --n) {
            matcher.appendReplacement(stringBuffer, "$1$2");
        }
        matcher.appendTail(stringBuffer);
        outputComment.comment = stringBuffer.toString();
        if (n <= outputComment.originHeight) {
            return;
        }
        Pattern pattern2 = Pattern.compile("(?m)^\\s*?\n");
        Matcher matcher2 = pattern2.matcher(outputComment.comment);
        stringBuffer = new StringBuffer();
        while (n > outputComment.originHeight && matcher2.find()) {
            matcher2.appendReplacement(stringBuffer, "");
            --n;
        }
        matcher2.appendTail(stringBuffer);
        outputComment.comment = stringBuffer.toString();
        if (n <= outputComment.originHeight) {
            return;
        }
        this.shrinkHTMLPTag(outputComment);
        if (outputComment.resultHeight() <= outputComment.originHeight) {
            return;
        }
        this.shrinkHTMLPreTag(outputComment);
        if (outputComment.resultHeight() <= outputComment.originHeight) {
            return;
        }
        String string2 = "(?s)\\s*/\\*\\*\\s*\n.*";
        if (!this.sourceComment.matches(string2)) {
            outputComment.enabledFirstLine = true;
            if (outputComment.resultHeight() <= outputComment.originHeight) {
                return;
            }
        }
        while (outputComment.resultHeight() > outputComment.originHeight && outputComment.width < 160) {
            outputComment.width += 4;
            outputComment.rebuild();
            if (outputComment.resultHeight() <= outputComment.originHeight) {
                return;
            }
            outputComment.comment = pattern.matcher(outputComment.comment).replaceAll("$1$2");
            if (outputComment.resultHeight() <= outputComment.originHeight) {
                return;
            }
            outputComment.comment = pattern2.matcher(outputComment.comment).replaceAll("");
            if (outputComment.resultHeight() <= outputComment.originHeight) {
                return;
            }
            this.shrinkHTMLPTag(outputComment);
            if (outputComment.resultHeight() <= outputComment.originHeight) {
                return;
            }
            this.shrinkHTMLPreTag(outputComment);
        }
    }

    private boolean shrinkTagList(String string, List list) {
        int n;
        if (list != null && (n = this.sourceComment.split("\\s" + string + "\\s", -1).length - 1) == 0) {
            list.clear();
            return true;
        }
        return false;
    }

    private void shrinkHTMLPTag(OutputComment outputComment) {
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("(\n\\s*<p>\\s*?)\n(.)");
        Matcher matcher = pattern.matcher(outputComment.comment);
        int n = outputComment.resultHeight();
        while (n > outputComment.originHeight && matcher.find()) {
            String string = matcher.group(2);
            if (string.equals("@")) continue;
            matcher.appendReplacement(stringBuffer, "$1$2");
            --n;
        }
        matcher.appendTail(stringBuffer);
        outputComment.comment = stringBuffer.toString();
    }

    private void shrinkHTMLPreTag(OutputComment outputComment) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("(\n\\s*</pre>\\s*?)\n(.)");
        Matcher matcher = pattern.matcher(outputComment.comment);
        int n = outputComment.resultHeight();
        while (n > outputComment.originHeight && matcher.find()) {
            object = matcher.group(2);
            if (((String)object).equals("@")) continue;
            matcher.appendReplacement(stringBuffer, "$1$2");
            --n;
        }
        matcher.appendTail(stringBuffer);
        outputComment.comment = stringBuffer.toString();
        if (n <= outputComment.originHeight) {
            return;
        }
        stringBuffer = new StringBuffer();
        object = Pattern.compile("\n\\s*(<pre>)");
        Matcher matcher2 = ((Pattern)object).matcher(outputComment.comment);
        for (n = outputComment.resultHeight(); n > outputComment.originHeight && matcher2.find(); --n) {
            matcher2.appendReplacement(stringBuffer, "$1");
        }
        matcher2.appendTail(stringBuffer);
        outputComment.comment = stringBuffer.toString();
    }

    private String buildComment(int n, int n2) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.description != null && this.description.length() > 0) {
            string = this.omitPackageName(this.description);
            string = string.replaceAll("(?m)^ (</pre>)", "$1");
            if (n2 == 1) {
                stringBuffer.append(string.replaceAll("\n", ""));
                stringBuffer.append("\n");
                return stringBuffer.toString();
            }
            stringBuffer.append(this.adjust(string, n));
            stringBuffer.append("\n");
        }
        if (this.deprecate != null && this.deprecate.length() > 0) {
            string = this.omitPackageName(this.deprecate);
            string = "@deprecated " + string;
            stringBuffer.append(this.adjust(string, n));
            stringBuffer.append("\n");
        }
        this.appendTo("@author  ", this.authors, stringBuffer, n);
        this.appendTo("@version ", this.versions, stringBuffer, n);
        if (this.params != null && this.params.size() > 0) {
            int n3;
            CharSequence charSequence;
            int n4 = this.params.size();
            int[] nArray = new int[n4];
            int n5 = 3;
            for (int i = 0; i < n4; ++i) {
                String string2 = (String)this.params.get(i);
                charSequence = string2.replaceFirst("(?s)(\\w+)\\s.*", "$1");
                nArray[i] = ((String)charSequence).length();
                if (nArray[i] <= n5 || nArray[i] >= 12) continue;
                n5 = nArray[i];
            }
            String string3 = "@param   ";
            charSequence = new StringBuffer(n3);
            for (n3 = string3.length() + n5 + 1; n3 > 0; --n3) {
                ((StringBuffer)charSequence).append(' ');
            }
            for (int i = 0; i < n4; ++i) {
                StringBuffer stringBuffer2 = new StringBuffer();
                for (int j = n5 - nArray[i]; j > 0; --j) {
                    stringBuffer2.append(' ');
                }
                String string4 = (String)this.params.get(i);
                string4 = string4.replaceFirst("(?s)(\\w+)\\s+(.*)", "$1" + stringBuffer2 + " $2");
                string4 = this.omitPackageName(string4);
                string4 = this.adjust(string4, n - string3.length());
                StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n");
                stringBuffer.append(string3);
                if (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken());
                }
                stringBuffer.append("\n");
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append((StringBuffer)charSequence);
                    stringBuffer.append(stringTokenizer.nextToken());
                    stringBuffer.append("\n");
                }
            }
        }
        this.appendTo("@return  ", this.returns, stringBuffer, n);
        this.appendTo("@throws  ", this.throwss, stringBuffer, n);
        this.appendTo("@serialField", this.serialFields, stringBuffer, n);
        this.appendTo("@serialData", this.serialDatas, stringBuffer, n);
        this.appendTo("@see     ", this.sees, stringBuffer, n);
        this.appendTo("@since   ", this.sinces, stringBuffer, n);
        this.appendTo("@serial  ", this.serials, stringBuffer, n);
        this.appendTo("@spec    ", this.specs, stringBuffer, n);
        String string5 = stringBuffer.toString();
        string5 = string5.replaceFirst("\n\n$", "\n");
        return string5;
    }

    private void appendTo(String string, List list, StringBuffer stringBuffer, int n) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string2 = this.omitPackageName(string2);
            string2 = this.adjust(string2, n - string.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            stringBuffer.append(string);
            if (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            stringBuffer.append("\n");
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string.replaceAll(".", " "));
                stringBuffer.append(stringTokenizer.nextToken());
                stringBuffer.append("\n");
            }
        }
    }

    private String omitPackageName(String string) {
        if (this.importPatterns == null) {
            return string;
        }
        int n = this.importPatterns.length;
        for (int i = 0; i < n; ++i) {
            Matcher matcher = this.importPatterns[i].matcher(string);
            string = matcher.replaceAll("$1$2");
        }
        return string;
    }

    private String adjust(String string, int n) {
        if (string.getBytes().length < n) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n2 = n - 20;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.matches("^\\s*</pre>.*")) {
                bl = false;
            }
            if (string2.matches("^\\s*<pre>.*")) {
                bl = true;
            }
            if (bl) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
                if (!string2.matches(".*</pre>\\s*$")) continue;
                bl = false;
                continue;
            }
            if (string2.matches(".*<pre>\\s*$")) {
                bl = true;
            }
            String string3 = string2.replaceAll("\\s?(\\p{Graph}{" + n2 + ",})", "\n$1");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "\n");
            while (stringTokenizer2.hasMoreTokens()) {
                String string4 = stringTokenizer2.nextToken();
                this.adjustLine(string4, stringBuffer, n);
            }
        }
        return stringBuffer.toString();
    }

    private void adjustLine(String string, StringBuffer stringBuffer, int n) {
        int n2 = n - 10;
        int n3 = n + 10;
        int n4 = n + 4;
        int n5 = string.length() - 1;
        StringBuffer stringBuffer2 = new StringBuffer();
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            boolean bl;
            char c;
            block9: {
                int n7;
                int n8;
                block12: {
                    block11: {
                        block10: {
                            String string2;
                            if (n6 == 0 && (n8 = (string2 = string.substring(i, n5)).getBytes().length) <= n4) {
                                stringBuffer2.append(string2);
                                break;
                            }
                            c = string.charAt(i);
                            n8 = String.valueOf(c).getBytes().length;
                            bl = false;
                            if ((n6 += n8) <= n2) break block9;
                            if (c != ' ') break block10;
                            bl = true;
                            stringBuffer2.append('\n');
                            break block9;
                        }
                        if ("\u3002\u3001\u300d".indexOf(c) == -1) break block11;
                        bl = true;
                        stringBuffer2.append(c);
                        stringBuffer2.append('\n');
                        break block9;
                    }
                    if ("\u306f\u304c\u306e\u3092\u306b\u3078\u3068\u3089\u3066\u308b".indexOf(c) == -1) break block12;
                    n7 = string.charAt(i + 1);
                    if ("\u3002\u3001\u300d".indexOf(n7) != -1 || n7 == 32) break block9;
                    bl = true;
                    stringBuffer2.append(c);
                    stringBuffer2.append('\n');
                    break block9;
                }
                if (n6 > n) {
                    if (c == '<' || n8 > 1) {
                        bl = true;
                        stringBuffer2.append('\n');
                        stringBuffer2.append(c);
                    } else if (n6 > n3) {
                        for (n7 = stringBuffer2.length() - 1; n7 > 0; --n7) {
                            char c2 = stringBuffer2.charAt(n7);
                            if (c2 == ' ') {
                                stringBuffer2.replace(n7, n7 + 1, "\n");
                                n6 = stringBuffer2.substring(n7 + 1).getBytes().length;
                                break;
                            }
                            int n9 = String.valueOf(c2).getBytes().length;
                            if (n9 <= 1) continue;
                            stringBuffer2.insert(n7 + 1, '\n');
                            n6 = stringBuffer2.substring(n7 + 2).getBytes().length;
                            break;
                        }
                    }
                }
            }
            if (bl) {
                stringBuffer.append(stringBuffer2);
                stringBuffer2 = new StringBuffer();
                n6 = 0;
                continue;
            }
            stringBuffer2.append(c);
        }
        stringBuffer2.append(string.charAt(n5));
        stringBuffer.append(stringBuffer2);
        stringBuffer.append('\n');
    }

    private class OutputComment {
        static final String LINE_PREFIX = " * ";
        final int originHeight;
        final int initWidth;
        int width;
        String comment;
        boolean enabledFirstLine;

        OutputComment(int n, int n2) {
            this.originHeight = n;
            this.initWidth = n2;
            this.width = n2;
            this.rebuild();
        }

        void rebuild() {
            this.comment = Comment.this.buildComment(this.width, this.originHeight);
        }

        int resultHeight() {
            if (this.enabledFirstLine) {
                return StringUtils.heightOf(this.comment) - 1;
            }
            return StringUtils.heightOf(this.comment);
        }

        void resetWidth() {
            this.width = this.initWidth;
        }

        public String toString() {
            String string = this.comment;
            if (string.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                string = string.replaceAll("(?m)^", LINE_PREFIX);
                if (this.enabledFirstLine) {
                    stringBuffer.append("/**");
                    string = string.replaceFirst("^ \\*", "");
                } else {
                    stringBuffer.append("/**\n");
                }
                stringBuffer.append(string);
                stringBuffer.append(" */\n");
                string = stringBuffer.toString();
            }
            return string;
        }
    }
}

