/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.SAXParser;
import mergedoc.MergeDocException;
import mergedoc.core.ArchiveInputStream;
import mergedoc.core.Merger;
import mergedoc.core.Preference;
import mergedoc.core.StringUtils;
import mergedoc.core.WorkingState;
import mergedoc.xml.ConfigManager;
import mergedoc.xml.ReplaceEntry;
import mergedoc.xml.ReplaceHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MergeManager {
    private Preference pref;
    private WorkingState workingState = new WorkingState();

    public void setPreference(Preference preference) {
        this.pref = preference;
        this.workingState.initialize();
    }

    public void validate() throws MergeDocException {
        File file;
        File file2 = this.pref.getDocDirectory();
        if (file2 != null && file2.getPath().length() > 0 && !(file = new File(file2, "allclasses-frame.html")).exists()) {
            throw new MergeDocException("\u6b63\u3057\u3044 API \u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\u6307\u5b9a\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u306f allclasses-frame.html \u30d5\u30a1\u30a4\u30eb\u304c\n\u542b\u307e\u308c\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        file = this.pref.getInputArchive();
        if (file == null || file.getPath().equals("")) {
            throw new MergeDocException("\u5165\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.entrySize() == 0) {
            throw new MergeDocException("\u6b63\u3057\u3044\u5165\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        File file3 = this.pref.getOutputArchive();
        if (file3 == null || file3.getPath().equals("")) {
            throw new MergeDocException("\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (file3.equals(file)) {
            throw new MergeDocException("\u5165\u529b\u3001\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u306b\u540c\u3058\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002\n\u6b63\u3057\u3044\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.pref.getOutputArchive().exists()) {
            if (!file3.canWrite()) {
                throw new MergeDocException("\u6307\u5b9a\u3055\u308c\u305f\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u306f\u66f8\u304d\u8fbc\u307f\u4e0d\u53ef\u3067\u3059\u3002\n\u6b63\u3057\u3044\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        } else {
            try {
                file3.createNewFile();
                file3.delete();
            }
            catch (IOException iOException) {
                throw new MergeDocException("\u6b63\u3057\u3044\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MergeDocException, SAXException, IOException {
        ZipOutputStream zipOutputStream;
        block6: {
            if (this.workingState.isCanceled()) {
                return;
            }
            ArchiveInputStream archiveInputStream = null;
            zipOutputStream = null;
            try {
                archiveInputStream = ArchiveInputStream.create(this.pref.getInputArchive());
                zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.pref.getOutputArchive())));
                zipOutputStream.setLevel(1);
                long l = System.currentTimeMillis();
                this.merge(archiveInputStream, zipOutputStream);
                long l2 = System.currentTimeMillis();
                this.workingState.setWorkTime((l2 - l) / 1000L);
                Object var8_5 = null;
                if (archiveInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (archiveInputStream != null) {
                    archiveInputStream.close();
                }
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                throw throwable;
            }
            archiveInputStream.close();
        }
        if (zipOutputStream != null) {
            zipOutputStream.close();
        }
    }

    private void merge(ArchiveInputStream archiveInputStream, ZipOutputStream zipOutputStream) throws MergeDocException, SAXException, IOException {
        Merger merger = new Merger(this.pref.getDocDirectory());
        merger.setDocEncoding(this.pref.getDocEncoding());
        ArchiveInputStream.Entry entry = null;
        while ((entry = archiveInputStream.getNextEntry()) != null) {
            Object object;
            if (this.workingState.isCanceled()) {
                return;
            }
            String string = entry.getName();
            zipOutputStream.putNextEntry(new ZipEntry(string));
            this.workingState.changeWorkingText(string);
            if (string.endsWith(".java")) {
                object = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = archiveInputStream.read(byArray)) > 0) {
                    ((ByteArrayOutputStream)object).write(byArray, 0, n);
                }
                String string2 = ((ByteArrayOutputStream)object).toString(this.pref.getInputEncoding());
                String string3 = merger.merge(string2);
                string3 = StringUtils.expand8Tab(string3);
                string3 = this.doFilter(merger.getMergedClassName(), string3);
                byte[] byArray2 = string3.getBytes(this.pref.getOutputEncoding());
                zipOutputStream.write(byArray2);
                continue;
            }
            object = new byte[1024];
            int n = 0;
            while ((n = archiveInputStream.read((byte[])object)) > 0) {
                zipOutputStream.write((byte[])object);
            }
        }
    }

    private String doFilter(String string, String string2) throws MergeDocException, SAXException, IOException {
        Object object;
        Object object2;
        if (string != null) {
            object2 = string.replaceAll("\\.", "/") + ".xml";
            ConfigManager configManager = ConfigManager.getInstance();
            object = configManager.getFile((String)object2);
            if (((File)object).exists()) {
                SAXParser sAXParser = configManager.getSAXPerser();
                ReplaceHandler replaceHandler = new ReplaceHandler(string2);
                sAXParser.parse((File)object, (DefaultHandler)replaceHandler);
                string2 = replaceHandler.getResult();
            }
        }
        object2 = this.pref.getGlobalEntries();
        for (int i = 0; i < ((ReplaceEntry[])object2).length; ++i) {
            object = object2[i];
            string2 = ((ReplaceEntry)object).replace(string2);
        }
        return string2;
    }

    public int entrySize() throws MergeDocException {
        int n = 0;
        try {
            ArchiveInputStream archiveInputStream = ArchiveInputStream.create(this.pref.getInputArchive());
            ArchiveInputStream.Entry entry = null;
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                ++n;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.workingState.setChangeListener(changeListener);
    }

    public WorkingState getWorkingState() {
        return this.workingState;
    }
}

