/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mergedoc.MergeDocException;
import mergedoc.core.MergeManager;
import mergedoc.core.Preference;
import mergedoc.core.WorkingState;
import mergedoc.ui.ButtonBar;
import mergedoc.ui.ComponentFactory;
import mergedoc.ui.MessageDialog;
import mergedoc.ui.PreferencePanel;
import mergedoc.ui.ProgressPanel;
import mergedoc.xml.ConfigManager;
import mergedoc.xml.Persister;

public class MergeDocFrame
extends JFrame {
    private JPanel mainPanel = new JPanel();
    private PreferencePanel preferencePanel;
    private ProgressPanel progressPanel = new ProgressPanel();
    private ButtonBar buttonBar = new ButtonBar();
    private MessageDialog dialog = new MessageDialog(this);
    private MergeManager mergeManager;
    private MergeThread mergeThread = new MergeThread();

    public MergeDocFrame() {
        try {
            this.initComponent();
        }
        catch (MergeDocException mergeDocException) {
            this.dialog.showErrorMessage(mergeDocException.getMessage());
            System.exit(0);
        }
    }

    private void initComponent() throws MergeDocException {
        this.preferencePanel = new PreferencePanel();
        this.mergeManager = new MergeManager();
        this.mainPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 0));
        this.mainPanel.add(this.preferencePanel);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.mainPanel);
        jPanel.add(ComponentFactory.createSpacer(0, 7));
        jPanel.add(this.buttonBar);
        this.getContentPane().add(jPanel);
        this.initListener();
        this.buttonBar.setState(this.buttonBar.INIT_STATE);
        ConfigManager configManager = ConfigManager.getInstance();
        String string = configManager.getFile("icon.png").toString();
        Image image = Toolkit.getDefaultToolkit().createImage(string);
        this.setIconImage(image);
        this.setTitle("MergeDoc");
        Persister persister = Persister.getInstance();
        this.setLocation(persister.getInt(Persister.WINDOW_X, 0), persister.getInt(Persister.WINDOW_Y, 0));
        this.setSize(persister.getInt(Persister.WINDOW_WIDTH, 600), persister.getInt(Persister.WINDOW_HEIGHT, 570));
        int n = persister.getInt(Persister.WINDOW_STATE, 0);
        if ((n & 1) != 1) {
            this.setExtendedState(n);
        }
        this.setVisible(true);
    }

    private void initListener() {
        this.buttonBar.setRunListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MergeDocFrame.this.mergeThread.notifyWorker();
            }
        });
        this.buttonBar.setCancelListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MergeDocFrame.this.buttonBar.setEnabled(false);
                MergeDocFrame.this.mergeManager.getWorkingState().cancel();
            }
        });
        this.buttonBar.setBackListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MergeDocFrame.this.back();
            }
        });
        this.buttonBar.setEndListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MergeDocFrame.this.end();
            }
        });
        this.mergeManager.setChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                WorkingState workingState = MergeDocFrame.this.mergeManager.getWorkingState();
                MergeDocFrame.this.progressPanel.addListText(workingState.getWorkingText());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MergeDocFrame.this.persistent();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MergeDocFrame.this.end();
            }
        });
    }

    public void execute() {
        this.buttonBar.setEnabled(false);
        Preference preference = this.preferencePanel.getPreference();
        if (this.isCancelByConfirm(preference)) {
            this.buttonBar.setEnabled(true);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MergeDocFrame.this.mainPanel.remove(MergeDocFrame.this.preferencePanel);
                MergeDocFrame.this.progressPanel.init();
                MergeDocFrame.this.mainPanel.add(MergeDocFrame.this.progressPanel);
                MergeDocFrame.this.progressPanel.repaint();
            }
        });
        this.buttonBar.setState(this.buttonBar.WORKING_STATE);
        try {
            this.mergeManager.setPreference(preference);
            this.mergeManager.validate();
            this.progressPanel.setMaximum(this.mergeManager.entrySize());
        }
        catch (MergeDocException mergeDocException) {
            this.dialog.showErrorMessage(mergeDocException.getMessage());
            this.back();
            return;
        }
        try {
            this.mergeManager.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.dialog.showErrorMessage(exception.getMessage());
            this.buttonBar.setState(this.buttonBar.FINISH_STATE);
            this.progressPanel.setBarText("\u7570\u5e38\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        WorkingState workingState = this.mergeManager.getWorkingState();
        if (workingState.isCanceled()) {
            this.buttonBar.setState(this.buttonBar.CANCEL_STATE);
            this.progressPanel.setBarText("\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3057\u305f\u3002");
        } else {
            this.buttonBar.setState(this.buttonBar.FINISH_STATE);
            String string = " " + workingState.getWorkTime() + "\u79d2";
            this.progressPanel.setBarText("\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002" + string);
        }
    }

    private boolean isCancelByConfirm(Preference preference) {
        int n;
        if (preference.getDocDirectory().getPath().length() == 0 && (n = this.dialog.showConfirmMessage("Javadoc API \u53c2\u7167\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u8a2d\u5b9a\u3055\u308c\u3066\n\u3044\u306a\u3044\u305f\u3081\u30b3\u30e1\u30f3\u30c8\u306e\u65e5\u672c\u8a9e\u5316\u306f\u884c\u308f\u308c\u307e\u305b\u3093\u3002\n\u8a73\u7d30\u8a2d\u5b9a\u306f\u9069\u7528\u3055\u308c\u307e\u3059\u3002\u5b9f\u884c\u3057\u307e\u3059\u304b\uff1f")) != 0) {
            return true;
        }
        return preference.getOutputArchive().exists() && (n = this.dialog.showConfirmMessage("\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\n\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b\uff1f")) != 0;
    }

    private void back() {
        this.buttonBar.setState(this.buttonBar.INIT_STATE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MergeDocFrame.this.mainPanel.remove(MergeDocFrame.this.progressPanel);
                MergeDocFrame.this.mainPanel.add(MergeDocFrame.this.preferencePanel);
                MergeDocFrame.this.mainPanel.repaint();
            }
        });
    }

    private void end() {
        this.persistent();
        try {
            this.preferencePanel.persistent();
            Persister.getInstance().store();
        }
        catch (MergeDocException mergeDocException) {
            this.dialog.showErrorMessage(mergeDocException.getMessage());
        }
        System.exit(0);
    }

    private void persistent() {
        try {
            Persister persister = Persister.getInstance();
            int n = this.getExtendedState();
            persister.setInt(Persister.WINDOW_STATE, n);
            if (n == 0) {
                persister.setInt(Persister.WINDOW_WIDTH, (int)this.getSize().getWidth());
                persister.setInt(Persister.WINDOW_HEIGHT, (int)this.getSize().getHeight());
                persister.setInt(Persister.WINDOW_X, (int)this.getLocation().getX());
                persister.setInt(Persister.WINDOW_Y, (int)this.getLocation().getY());
            }
        }
        catch (MergeDocException mergeDocException) {
            this.dialog.showErrorMessage(mergeDocException.getMessage());
        }
    }

    private class MergeThread
    extends Thread {
        public MergeThread() {
            this.start();
        }

        public void run() {
            while (true) {
                this.waitWorker();
            }
        }

        private synchronized void waitWorker() {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            MergeDocFrame.this.execute();
        }

        public synchronized void notifyWorker() {
            this.notify();
        }
    }
}

