/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import mergedoc.MergeDocException;
import mergedoc.core.Preference;
import mergedoc.ui.ComponentFactory;
import mergedoc.ui.EntryCheckBox;
import mergedoc.ui.FileChooserField;
import mergedoc.ui.PreviewScrollPane;
import mergedoc.ui.TitledPanel;
import mergedoc.xml.ConfigManager;
import mergedoc.xml.Persister;
import mergedoc.xml.ReplaceEntry;

public class PreferencePanel
extends JPanel {
    private FileChooserField docField = new FileChooserField();
    private FileChooserField srcField = new FileChooserField();
    private FileChooserField outField = new FileChooserField();
    private JSplitPane splitPane = new JSplitPane();
    private List entryCheckList = new ArrayList();
    private PreviewScrollPane previewScrollPane;

    public PreferencePanel() throws MergeDocException {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.setMaximumSize(ComponentFactory.createMaxDimension());
        this.add(this.createUpperPanel());
        this.add(ComponentFactory.createSpacer(0, 7));
        this.add(this.createLowerPanel());
    }

    private JComponent createUpperPanel() throws MergeDocException {
        JLabel jLabel = this.docField.getLabel();
        JLabel jLabel2 = this.srcField.getLabel();
        JLabel jLabel3 = this.outField.getLabel();
        jLabel.setText("API \u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        jLabel2.setText("\u5165\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb");
        jLabel3.setText("\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb");
        JComponent[] jComponentArray = new JLabel[]{jLabel, jLabel2, jLabel3};
        ComponentFactory.ensureMaxFontWidth(jComponentArray);
        JComboBox jComboBox = this.docField.getComboBox();
        JComboBox jComboBox2 = this.srcField.getComboBox();
        JComboBox jComboBox3 = this.outField.getComboBox();
        jComboBox.addItem("JISAutoDetect");
        jComboBox2.addItem("JISAutoDetect");
        jComboBox.setSelectedItem("ISO-2022-JP");
        jComboBox2.setSelectedItem(FileChooserField.ENCODING_DEFAULT);
        jComboBox3.setSelectedItem(FileChooserField.ENCODING_DEFAULT);
        JComponent[] jComponentArray2 = new JComboBox[]{jComboBox, jComboBox2, jComboBox3};
        ComponentFactory.ensureMaxFontWidth(jComponentArray2);
        this.docField.setSelectionMode(FileChooserField.DIRECTORIES);
        this.srcField.setSelectionMode(FileChooserField.ZIP_TARGZ_FILES);
        this.outField.setSelectionMode(FileChooserField.ZIP_FILES);
        this.docField.setChooseListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencePanel.this.resolveArchivePath(PreferencePanel.this.docField.getFile());
            }
        });
        TitledPanel titledPanel = new TitledPanel("\u57fa\u672c\u8a2d\u5b9a");
        ((Container)titledPanel).add(this.docField);
        ((Container)titledPanel).add(this.srcField);
        ((Container)titledPanel).add(this.outField);
        String string = System.getProperty("target.directory");
        if (string != null) {
            File file = new File(string);
            if (!file.exists() || file.isFile()) {
                throw new MergeDocException("\u30aa\u30d7\u30b7\u30e7\u30f3 target.directory \u306b\u6307\u5b9a\u3055\u308c\u305f\u5024 " + string + " \u306f\n\u5b58\u5728\u3057\u306a\u3044\u304b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
            File file2 = this.searchDocDirectory(file);
            if (file2 != null) {
                this.docField.setFile(file2);
            }
            this.srcField.setFile(new File(""));
            this.outField.setFile(new File(""));
            this.resolveArchivePath(file);
        }
        this.loadPersister(this.docField, Persister.DOC_DIR, Persister.DOC_ENC);
        this.loadPersister(this.srcField, Persister.IN_FILE, Persister.IN_ENC);
        this.loadPersister(this.outField, Persister.OUT_FILE, Persister.OUT_ENC);
        return titledPanel;
    }

    private JComponent createLowerPanel() throws MergeDocException {
        JComponent jComponent;
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        List list = ConfigManager.getInstance().getGlobalEntries();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (ReplaceEntry)object2.next();
            jComponent = new EntryCheckBox((ReplaceEntry)object);
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PreferencePanel.this.previewScrollPane.updatePreview(PreferencePanel.this.entryCheckList);
                }
            });
            jPanel.add(jComponent);
            this.entryCheckList.add(jComponent);
        }
        object2 = ComponentFactory.createScrollPane(jPanel);
        ((JScrollPane)object2).getVerticalScrollBar().setUnitIncrement(10);
        this.previewScrollPane = new PreviewScrollPane();
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setOrientation(0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setTopComponent((Component)object2);
        this.splitPane.setBottomComponent(this.previewScrollPane);
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 0));
        ((Container)object).add(this.splitPane);
        jComponent = new TitledPanel("\u8a73\u7d30\u8a2d\u5b9a");
        jComponent.setMaximumSize(ComponentFactory.createMaxDimension());
        jComponent.add((Component)object);
        Persister persister = Persister.getInstance();
        int n = persister.getInt(Persister.DETAIL_PANEL_HEIGHT, 88);
        this.splitPane.setDividerLocation(n);
        String[] stringArray = persister.getStrings(Persister.REPLACE_DESCRIPTION_ARRAY);
        Iterator iterator = this.entryCheckList.iterator();
        block1: while (iterator.hasNext()) {
            EntryCheckBox entryCheckBox = (EntryCheckBox)iterator.next();
            ReplaceEntry replaceEntry = entryCheckBox.getReplaceEntry();
            String string = replaceEntry.getDescription();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                entryCheckBox.setSelected(true);
                continue block1;
            }
        }
        this.previewScrollPane.updatePreview(this.entryCheckList);
        return jComponent;
    }

    private void resolveArchivePath(File file) {
        Object object;
        String string = this.srcField.getFile().getPath();
        String string2 = this.outField.getFile().getPath();
        if (!string.equals("") || !string2.equals("")) {
            return;
        }
        for (object = file; object != null; object = ((File)object).getParentFile()) {
            File file2 = new File((File)object, "src.zip");
            if (file2.exists()) {
                this.srcField.setFile(file2);
                break;
            }
            File file3 = new File((File)object, "src.jar");
            if (!file3.exists()) continue;
            this.srcField.setFile(file3);
            break;
        }
        if (!(string = this.srcField.getFile().getPath()).equals("")) {
            object = string.replaceFirst("\\.(zip|jar)$", "ja.zip");
            this.outField.setFile(new File((String)object));
        }
    }

    private File searchDocDirectory(File file) {
        File file2 = null;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (file3.isFile()) {
                if (file3.getName().equals("allclasses-frame.html")) {
                    file2 = file;
                }
            } else {
                file2 = this.searchDocDirectory(file3);
            }
            if (file2 != null) break;
        }
        return file2;
    }

    private void loadPersister(FileChooserField fileChooserField, Persister.Key key, Persister.Key key2) throws MergeDocException {
        String string;
        Persister persister = Persister.getInstance();
        if (fileChooserField.getFile().getPath().equals("") && (string = persister.getString(key, "")).length() > 0) {
            fileChooserField.setFile(new File(string));
        }
        try {
            string = persister.getString(key2);
            fileChooserField.getComboBox().setSelectedItem(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public ReplaceEntry[] getSelectedEntries() {
        ArrayList<ReplaceEntry> arrayList = new ArrayList<ReplaceEntry>();
        ReplaceEntry[] replaceEntryArray = this.entryCheckList.iterator();
        while (replaceEntryArray.hasNext()) {
            EntryCheckBox entryCheckBox = (EntryCheckBox)replaceEntryArray.next();
            if (!entryCheckBox.isSelected()) continue;
            ReplaceEntry replaceEntry = entryCheckBox.getReplaceEntry();
            arrayList.add(replaceEntry);
        }
        replaceEntryArray = arrayList.toArray(new ReplaceEntry[arrayList.size()]);
        return replaceEntryArray;
    }

    public Preference getPreference() {
        return new Preference(){
            File docDir;
            File srcFile;
            File outFile;
            String docEnc;
            String srcEnc;
            String outEnc;
            ReplaceEntry[] entries;
            {
                this.docDir = PreferencePanel.this.docField.getFile();
                this.srcFile = PreferencePanel.this.srcField.getFile();
                this.outFile = PreferencePanel.this.outField.getFile();
                this.docEnc = PreferencePanel.this.docField.getComboBox().getSelectedItem().toString();
                this.srcEnc = PreferencePanel.this.srcField.getComboBox().getSelectedItem().toString();
                this.outEnc = PreferencePanel.this.outField.getComboBox().getSelectedItem().toString();
                this.entries = PreferencePanel.this.getSelectedEntries();
            }

            public File getDocDirectory() {
                return this.docDir;
            }

            public File getInputArchive() {
                return this.srcFile;
            }

            public File getOutputArchive() {
                return this.outFile;
            }

            public String getDocEncoding() {
                return this.docEnc;
            }

            public String getInputEncoding() {
                return this.srcEnc;
            }

            public String getOutputEncoding() {
                return this.outEnc;
            }

            public ReplaceEntry[] getGlobalEntries() {
                return this.entries;
            }
        };
    }

    public void persistent() throws MergeDocException {
        Preference preference = this.getPreference();
        Persister persister = Persister.getInstance();
        persister.setString(Persister.DOC_DIR, preference.getDocDirectory().getPath());
        persister.setString(Persister.IN_FILE, preference.getInputArchive().getPath());
        persister.setString(Persister.OUT_FILE, preference.getOutputArchive().getPath());
        persister.setString(Persister.DOC_ENC, preference.getDocEncoding());
        persister.setString(Persister.IN_ENC, preference.getInputEncoding());
        persister.setString(Persister.OUT_ENC, preference.getOutputEncoding());
        persister.setInt(Persister.DETAIL_PANEL_HEIGHT, this.splitPane.getDividerLocation());
        ReplaceEntry[] replaceEntryArray = preference.getGlobalEntries();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < replaceEntryArray.length; ++i) {
            arrayList.add(replaceEntryArray[i].getDescription());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        persister.setStrings(Persister.REPLACE_DESCRIPTION_ARRAY, stringArray);
    }
}

