/*
 * Copyright (c) 2003 Shinji Kashihara. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies
 * this distribution, and is available at cpl-v10.html.
 */
package mergedoc.core;


/**
 * 文字列ユーティリティです。
 * @author Shinji Kashihara
 */
public class StringUtils {

    /**
     * コンストラクタです。生成不可。
     */
    private StringUtils() {
    }

    /**
     * メタ文字を \ でエスケープします。
     * 対象となるメタ文字はエスケープ文字 \ および前方参照の部分参照を示す $ です。
     * @param str 対象文字列
     * @return エスケープした文字列
     */
    public static String escapeMetaCharactor(String str) {
        return str.replaceAll("(\\$|\\\\)", "\\\\$1");
    }
    
    /**
     * 改行文字を最適化します。<p>
     * ・CRLF → LF<br>
     * ・CR → LF
     * @param str 対象文字列
     * @return 最適化した文字列
     */
    public static String optimizeLineSeparator(String str) {
        return str.replaceAll("(\r\n|\r)", "\n");
    }

    /**
     * 文字列に含まれるタブをスペース 8 文字分に展開します。
     * @param str 文字列
     * @return タブをスペースに展開した文字列
     */
    public static String expand8Tab(String str) {
        final int TAB_WIDTH = 8;
        StringBuffer sb = new StringBuffer();
        for (int pos = 0, hPos = -1; pos < str.length(); pos++) {
            char c = str.charAt(pos);
            hPos = (c == '\n') ? -1 : hPos + 1;
            if (c == '\t') {
                int fillSize = TAB_WIDTH - hPos % TAB_WIDTH;
                for (int f = 0; f < fillSize; f++) {
                    sb.append(' ');
                }
                hPos = hPos + fillSize - 1;
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    /**
     * 文字列の高さ（行数）を求めます。
     * この値は文字列中に含まれる改行の数と等価です。
     * @param str 文字列
     * @return 高さ（行数）
     */
    public static int heightOf(String str) {
        return str.split("\n", -1).length - 1;
    }
}
