/*
 * Decompiled with CFR 0.152.
 */
package mergedoc;

import java.awt.Toolkit;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import mergedoc.ui.MergeDocFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Application {
    private static final Log log = LogFactory.getLog(Application.class);

    public static void main(String[] args) {
        try {
            Application.initSystemLookAndFeel();
        }
        catch (Exception e) {
            log.warn("Look & Feel \u306e\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        new MergeDocFrame();
    }

    private static void initSystemLookAndFeel() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        String osName = System.getProperty("os.name", "");
        if (osName.indexOf("Windows") != -1) {
            FontUIResource propoFont = new FontUIResource("MS UI Gothic", 0, 12);
            FontUIResource fixedFont = new FontUIResource("MS Gothic", 0, 12);
            for (Object keyObj : UIManager.getLookAndFeelDefaults().keySet()) {
                String key = keyObj.toString();
                if (!key.endsWith("font") && !key.endsWith("Font")) continue;
                UIManager.put(key, propoFont);
            }
            UIManager.put("OptionPane.messageFont", fixedFont);
            UIManager.put("TextPane.font", fixedFont);
            UIManager.put("TextArea.font", fixedFont);
        }
    }
}

