/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mergedoc.core.PatternCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastStringUtils {
    private static final Log log = LogFactory.getLog(FastStringUtils.class);

    private FastStringUtils() {
    }

    public static String replace(String input, String target, String replacement) {
        Pattern pattern = PatternCache.getLiteralPattern(target);
        return pattern.matcher(input).replaceAll(Matcher.quoteReplacement(replacement));
    }

    public static String replaceFirst(String input, String regex, String replacement) {
        Pattern pattern = PatternCache.getPattern(regex);
        return pattern.matcher(input).replaceFirst(replacement);
    }

    public static String replaceAll(String input, String regex, String replacement) {
        Pattern pattern = PatternCache.getPattern(regex);
        return pattern.matcher(input).replaceAll(replacement);
    }

    public static boolean matches(String input, String regex) {
        Pattern pattern = PatternCache.getPattern(regex);
        return pattern.matcher(input).matches();
    }

    public static String[] split(String input, String regex, int limit) {
        Pattern pattern = PatternCache.getPattern(regex);
        return pattern.split(input, limit);
    }

    public static String quoteReplacement(String str) {
        if (!str.contains("\\") && !str.contains("$")) {
            return str;
        }
        int size = str.length();
        int expectSize = (int)((double)size * 1.1);
        StringBuilder sb = new StringBuilder(expectSize);
        for (int i = 0; i < size; ++i) {
            char c = str.charAt(i);
            if (c == '\\' || c == '$') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String optimizeLineSeparator(String str) {
        str = str + " ";
        int size = str.length();
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size - 1; ++i) {
            char c = str.charAt(i);
            if (c == '\r') {
                if (str.charAt(i + 1) == '\n') continue;
                sb.append('\n');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String untabify(String str) {
        int TAB_WIDTH = 8;
        int size = str.length();
        int expectSize = (int)((double)size * 1.2);
        StringBuilder sb = new StringBuilder(expectSize);
        int hPos = -1;
        for (int pos = 0; pos < size; ++pos) {
            char c = str.charAt(pos);
            int n = hPos = c == '\n' ? -1 : hPos + 1;
            if (c == '\t') {
                int fillSize = 8 - hPos % 8;
                for (int f = 0; f < fillSize; ++f) {
                    sb.append(' ');
                }
                hPos = hPos + fillSize - 1;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int heightOf(String str) {
        int height = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '\n') continue;
            ++height;
        }
        return height;
    }

    public static List<String> splitLine(String str) {
        LinkedList<String> list = new LinkedList<String>();
        int size = str.length();
        int expectSize = 120;
        StringBuilder sb = new StringBuilder(expectSize);
        for (int i = 0; i < size; ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                list.add(sb.toString());
                sb = new StringBuilder(expectSize);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list;
    }
}

