/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.SAXParser;
import mergedoc.MergeDocException;
import mergedoc.core.ArchiveInputStream;
import mergedoc.core.FastStringUtils;
import mergedoc.core.Merger;
import mergedoc.core.Preference;
import mergedoc.core.WorkingState;
import mergedoc.xml.ConfigManager;
import mergedoc.xml.ReplaceEntry;
import mergedoc.xml.ReplaceHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MergeManager {
    private static final Log log = LogFactory.getLog(MergeManager.class);
    private Preference pref;
    private WorkingState workingState = new WorkingState();
    private byte[] byteBuffer = new byte[4096];
    private ExecutorService entrySizeGetExecutor = Executors.newSingleThreadExecutor();
    private Future<Integer> entrySizeFuture;

    public void setPreference(final Preference pref) {
        this.pref = pref;
        this.workingState.initialize();
        this.entrySizeFuture = this.entrySizeGetExecutor.submit(new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                ArchiveInputStream is = null;
                try {
                    is = ArchiveInputStream.create(pref.getInputArchive());
                    int size = 0;
                    while (is.getNextEntry() != null) {
                        ++size;
                    }
                    Integer n = size;
                    return n;
                }
                catch (Exception e) {
                    Integer n = 0;
                    return n;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        });
    }

    public void validate() throws MergeDocException, IOException, InterruptedException, ExecutionException {
        File rootFile;
        File docDir = this.pref.getDocDirectory();
        if (docDir != null && docDir.getPath().length() > 0 && !(rootFile = new File(docDir, "allclasses-frame.html")).exists()) {
            throw new MergeDocException("\u6b63\u3057\u3044 API \u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\u6307\u5b9a\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u306f allclasses-frame.html \u30d5\u30a1\u30a4\u30eb\u304c\n\u542b\u307e\u308c\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        File inFile = this.pref.getInputArchive();
        if (inFile == null || inFile.getPath().equals("")) {
            throw new MergeDocException("\u5165\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.entrySize() == 0) {
            throw new MergeDocException("\u6b63\u3057\u3044\u5165\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        File outFile = this.pref.getOutputArchive();
        if (outFile == null || outFile.getPath().equals("")) {
            throw new MergeDocException("\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (outFile.equals(inFile)) {
            throw new MergeDocException("\u5165\u529b\u3001\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u306b\u540c\u3058\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002\n\u6b63\u3057\u3044\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.pref.getOutputArchive().exists()) {
            if (!outFile.canWrite()) {
                throw new MergeDocException("\u6307\u5b9a\u3055\u308c\u305f\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u306f\u66f8\u304d\u8fbc\u307f\u4e0d\u53ef\u3067\u3059\u3002\n\u6b63\u3057\u3044\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        } else {
            try {
                outFile.createNewFile();
                outFile.delete();
            }
            catch (IOException e) {
                throw new MergeDocException("\u6b63\u3057\u3044\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MergeDocException, SAXException, IOException {
        if (this.workingState.isCanceled()) {
            return;
        }
        ArchiveInputStream in = null;
        ZipOutputStream out = null;
        try {
            in = ArchiveInputStream.create(this.pref.getInputArchive());
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.pref.getOutputArchive())));
            out.setLevel(1);
            long start = System.currentTimeMillis();
            this.merge(in, out);
            long end = System.currentTimeMillis();
            this.workingState.setWorkTime((end - start) / 1000L);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private void merge(ArchiveInputStream in, ZipOutputStream out) throws MergeDocException, SAXException, IOException {
        Merger merger = new Merger(this.pref.getDocDirectory());
        merger.setDocEncoding(this.pref.getDocEncoding());
        ArchiveInputStream.Entry inEntry = null;
        while ((inEntry = in.getNextEntry()) != null) {
            if (this.workingState.isCanceled()) {
                return;
            }
            String entryName = inEntry.getName();
            out.putNextEntry(new ZipEntry(entryName));
            this.workingState.changeWorkingText(entryName);
            if (entryName.endsWith(".java")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.copyStream(in, baos);
                String source = baos.toString(this.pref.getInputEncoding());
                source = FastStringUtils.optimizeLineSeparator(source);
                source = FastStringUtils.untabify(source);
                String result = merger.merge(source);
                String className = merger.getMergedClassName();
                if (className != null) {
                    result = this.doFilter(className, result);
                }
                byte[] resultBuf = result.getBytes(this.pref.getOutputEncoding());
                out.write(resultBuf);
                continue;
            }
            this.copyStream(in, out);
        }
    }

    private void copyStream(ArchiveInputStream in, OutputStream out) throws IOException {
        int size = 0;
        while ((size = in.read(this.byteBuffer)) > 0) {
            out.write(this.byteBuffer, 0, size);
        }
    }

    private String doFilter(String className, String source) throws MergeDocException, SAXException, IOException {
        String path = FastStringUtils.replaceAll(className, "\\.", "/") + ".xml";
        ConfigManager config = ConfigManager.getInstance();
        File entryXML = config.getFile(path);
        if (entryXML.exists()) {
            SAXParser saxParser = config.getSAXPerser();
            ReplaceHandler handler = new ReplaceHandler(source);
            saxParser.parse(entryXML, (DefaultHandler)handler);
            source = handler.getResult();
        }
        for (ReplaceEntry entry : this.pref.getGlobalEntries()) {
            source = entry.replace(source);
        }
        return source;
    }

    public int entrySize() throws InterruptedException, ExecutionException {
        return this.entrySizeFuture.get();
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.workingState.setChangeListener(changeListener);
    }

    public WorkingState getWorkingState() {
        return this.workingState;
    }
}

