/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.filechooser.FileFilter;
import mergedoc.ui.ComponentFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileChooserField
extends JPanel {
    private static final Log log = LogFactory.getLog(FileChooserField.class);
    private final JLabel label = new JLabel();
    private final JTextField textField = new JTextField();
    private final JButton button = new JButton();
    private final JComboBox combo = new JComboBox();
    private JFileChooser chooser = new JFileChooser();
    private ActionListener chooseListener;
    public static final String ENCODING_DEFAULT = System.getProperty("file.encoding");
    public static final String ENCODING_AUTO = "JISAutoDetect";
    public static final SelectionMode DIRECTORIES = new SelectionMode(){

        public void apply(JFileChooser chooser) {
            chooser.setFileSelectionMode(1);
            chooser.removeChoosableFileFilter(chooser.getFileFilter());
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory();
                }

                public String getDescription() {
                    return "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u307f";
                }
            });
        }
    };
    public static final SelectionMode ZIP_FILES = new SelectionMode(){

        public void apply(JFileChooser chooser) {
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".zip") || f.getName().endsWith(".jar");
                }

                public String getDescription() {
                    return "*.zip, *.jar";
                }
            });
        }
    };
    public static final SelectionMode ZIP_TGZ_FILES = new SelectionMode(){

        public void apply(JFileChooser chooser) {
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".zip") || f.getName().endsWith(".jar") || f.getName().endsWith(".tgz") || f.getName().endsWith(".tar.gz");
                }

                public String getDescription() {
                    return "*.zip, *.jar, *.tgz, *.tar.gz";
                }
            });
        }
    };

    public FileChooserField() {
        this.setLayout(new BoxLayout(this, 0));
        int maxWidth = (int)ComponentFactory.createMaxDimension().getWidth();
        this.textField.setMaximumSize(new Dimension(maxWidth, 20));
        this.textField.setTransferHandler(new FileDropHandler());
        ComponentFactory.ensureSize(this.button, 20, 18);
        this.button.setText("...");
        CharsetSortedModel charsetModel = new CharsetSortedModel();
        charsetModel.add("EUC-JP");
        charsetModel.add("EUC-JP-LINUX");
        charsetModel.add("ISO-2022-JP");
        charsetModel.add("MS932");
        charsetModel.add("Shift_JIS");
        charsetModel.add("UTF-16");
        charsetModel.add("UTF-16BE");
        charsetModel.add("UTF-16LE");
        charsetModel.add("UTF-8");
        charsetModel.add(FileChooserField.ENCODING_DEFAULT);
        charsetModel.fireAdded();
        this.add(this.label);
        this.add(ComponentFactory.createSpacer(10, 0));
        this.add(this.textField);
        this.add(this.button);
        this.add(ComponentFactory.createSpacer(5, 0));
        this.add(this.combo);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int result = FileChooserField.this.chooser.showOpenDialog(FileChooserField.this);
                if (result == 0) {
                    FileChooserField.this.setFile(FileChooserField.this.chooser.getSelectedFile());
                    if (FileChooserField.this.chooseListener != null) {
                        FileChooserField.this.chooseListener.actionPerformed(e);
                    }
                }
            }
        });
    }

    public void setSelectionMode(SelectionMode mode) {
        this.chooser = new JFileChooser();
        mode.apply(this.chooser);
    }

    public void setChooseListener(ActionListener chooseListener) {
        this.chooseListener = chooseListener;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setFile(File file) {
        this.textField.setText(file.getPath());
        this.chooser.setSelectedFile(file);
    }

    public File getFile() {
        return new File(this.textField.getText());
    }

    public JComboBox getComboBox() {
        return this.combo;
    }

    private class FileDropHandler
    extends TransferHandler {
        TransferHandler originHandler;

        private FileDropHandler() {
            this.originHandler = FileChooserField.this.textField.getTransferHandler();
        }

        public void exportToClipboard(JComponent comp, Clipboard clipboard, int action) {
            this.originHandler.exportToClipboard(comp, clipboard, action);
        }

        public int getSourceActions(JComponent comp) {
            return this.originHandler.getSourceActions(comp);
        }

        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            for (DataFlavor flavor : flavors) {
                if (!flavor.isFlavorJavaFileListType()) continue;
                return true;
            }
            return this.originHandler.canImport(comp, flavors);
        }

        public boolean importData(JComponent comp, Transferable t) {
            boolean imported = false;
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                try {
                    List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    File file = (File)files.get(0);
                    FileChooserField.this.setFile(file);
                    FileChooserField.this.textField.repaint();
                    imported = true;
                }
                catch (UnsupportedFlavorException e) {
                }
                catch (IOException e) {}
            } else {
                imported = this.originHandler.importData(comp, t);
            }
            if (imported && FileChooserField.this.chooseListener != null && FileChooserField.this.getFile().exists()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileChooserField.this.chooseListener.actionPerformed(null);
                    }
                });
            }
            return imported;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CharsetSortedModel
    extends DefaultComboBoxModel {
        private final Set<Object> charsetNames;

        private CharsetSortedModel() {
            this.charsetNames = new TreeSet<Object>();
        }

        private CharsetSortedModel(Set<Object> set) {
            super(set.toArray());
            this.charsetNames = set;
        }

        private boolean isSupported(Object charset) {
            try {
                new String(new byte[0], charset.toString());
            }
            catch (UnsupportedEncodingException e) {
                return false;
            }
            return true;
        }

        private void add(Object charset) {
            if (this.isSupported(charset)) {
                this.charsetNames.add(charset);
            }
        }

        private void fireAdded() {
            FileChooserField.this.combo.setModel(new CharsetSortedModel(this.charsetNames));
        }

        @Override
        public void addElement(Object charset) {
            if (this.isSupported(charset) && !this.charsetNames.contains(charset)) {
                this.charsetNames.add(charset);
                this.fireAdded();
            }
        }

        @Override
        public void setSelectedItem(Object charset) {
            if (charset != null) {
                if (!this.charsetNames.contains(charset)) {
                    this.addElement(charset);
                }
                super.setSelectedItem(charset);
            }
        }
    }

    private static interface SelectionMode {
        public void apply(JFileChooser var1);
    }
}

