/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mergedoc.MergeDocException;
import mergedoc.core.MergeManager;
import mergedoc.core.Preference;
import mergedoc.core.WorkingState;
import mergedoc.ui.ButtonBar;
import mergedoc.ui.ComponentFactory;
import mergedoc.ui.MessageDialog;
import mergedoc.ui.PreferencePanel;
import mergedoc.ui.ProgressPanel;
import mergedoc.xml.ConfigManager;
import mergedoc.xml.Persister;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MergeDocFrame
extends JFrame {
    private static final Log log = LogFactory.getLog(MergeDocFrame.class);
    private static final String SETTING_TITLE = "\u8a2d\u5b9a";
    private JPanel mainPanel = new JPanel();
    private PreferencePanel preferencePanel;
    private ProgressPanel progressPanel = new ProgressPanel();
    private ButtonBar buttonBar = new ButtonBar();
    private MessageDialog dialog = new MessageDialog(this);
    private MergeManager mergeManager;
    private ExecutorService mergeExecutor = Executors.newSingleThreadExecutor();

    public MergeDocFrame() {
        try {
            this.initComponent();
        }
        catch (Exception e) {
            this.dialog.showErrorMessage(e.getMessage());
            System.exit(0);
        }
    }

    private void initComponent() throws MergeDocException {
        this.preferencePanel = new PreferencePanel();
        this.mergeManager = new MergeManager();
        this.mainPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 0));
        this.mainPanel.add(this.preferencePanel);
        JPanel outerPanel = new JPanel();
        outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        outerPanel.add(this.mainPanel);
        outerPanel.add(ComponentFactory.createSpacer(0, 7));
        outerPanel.add(this.buttonBar);
        this.getContentPane().add(outerPanel);
        this.initListener();
        this.buttonBar.setState(this.buttonBar.INIT_STATE);
        ConfigManager config = ConfigManager.getInstance();
        String iconPath = config.getFile("icon.png").toString();
        Image icon = Toolkit.getDefaultToolkit().createImage(iconPath);
        this.setIconImage(icon);
        this.setTitle(SETTING_TITLE);
        Persister psst = Persister.getInstance();
        this.setLocation(psst.getInt(Persister.WINDOW_X, 0), psst.getInt(Persister.WINDOW_Y, 0));
        this.setSize(psst.getInt(Persister.WINDOW_WIDTH, 700), psst.getInt(Persister.WINDOW_HEIGHT, 570));
        int state = psst.getInt(Persister.WINDOW_STATE, 0);
        if ((state & 1) != 1) {
            this.setExtendedState(state);
        }
        this.setVisible(true);
    }

    private void initListener() {
        this.buttonBar.setRunListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MergeDocFrame.this.mergeExecutor.submit(new Runnable(){

                    public void run() {
                        MergeDocFrame.this.execute();
                    }
                });
            }
        });
        this.buttonBar.setCancelListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MergeDocFrame.this.buttonBar.setEnabled(false);
                MergeDocFrame.this.mergeManager.getWorkingState().cancel();
            }
        });
        this.buttonBar.setBackListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MergeDocFrame.this.back();
            }
        });
        this.buttonBar.setEndListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MergeDocFrame.this.end();
            }
        });
        this.mergeManager.setChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WorkingState state = MergeDocFrame.this.mergeManager.getWorkingState();
                MergeDocFrame.this.progressPanel.addListText(state.getWorkingText());
                MergeDocFrame.this.setTitle(MergeDocFrame.this.progressPanel.getBarText());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                MergeDocFrame.this.persistent();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MergeDocFrame.this.end();
            }
        });
    }

    public void execute() {
        this.buttonBar.setEnabled(false);
        Preference pref = this.preferencePanel.getPreference();
        this.mergeManager.setPreference(pref);
        if (this.isCancelByConfirm(pref)) {
            this.buttonBar.setEnabled(true);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MergeDocFrame.this.mainPanel.remove(MergeDocFrame.this.preferencePanel);
                MergeDocFrame.this.progressPanel.init();
                MergeDocFrame.this.mainPanel.add(MergeDocFrame.this.progressPanel);
                MergeDocFrame.this.progressPanel.repaint();
            }
        });
        this.buttonBar.setState(this.buttonBar.WORKING_STATE);
        try {
            this.mergeManager.validate();
            this.progressPanel.setMaximum(this.mergeManager.entrySize());
        }
        catch (MergeDocException e) {
            this.dialog.showErrorMessage(e.getMessage());
            this.back();
            return;
        }
        catch (Exception e) {
            String msg = "\u8a2d\u5b9a\u5024\u306e\u691c\u8a3c\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
            log.error(msg, e);
            this.dialog.showErrorMessage(msg + "\n" + e);
            this.back();
            return;
        }
        try {
            this.mergeManager.execute();
        }
        catch (Exception e) {
            this.setTitle("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
            String msg = "\u30de\u30fc\u30b8\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
            log.error(msg, e);
            this.dialog.showErrorMessage(msg + "\n" + e);
            this.buttonBar.setState(this.buttonBar.FINISH_STATE);
            this.progressPanel.setBarText("\u7570\u5e38\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        WorkingState state = this.mergeManager.getWorkingState();
        String message = null;
        if (state.isCanceled()) {
            this.buttonBar.setState(this.buttonBar.CANCEL_STATE);
            message = "\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3057\u305f\u3002";
        } else {
            this.buttonBar.setState(this.buttonBar.FINISH_STATE);
            message = "\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002 " + state.getWorkTime() + "\u79d2";
        }
        this.progressPanel.setBarText(message);
        this.setTitle(message);
    }

    private boolean isCancelByConfirm(Preference pref) {
        int result;
        if (pref.getDocDirectory().getPath().length() == 0 && (result = this.dialog.showConfirmMessage("Javadoc API \u53c2\u7167\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u30de\u30fc\u30b8\u306f\u884c\u308f\u308c\u307e\u305b\u3093\u3002\n\u6587\u5b57\u30b3\u30fc\u30c9\u5909\u63db\u304a\u3088\u3073\u8a73\u7d30\u8a2d\u5b9a\u306f\u9069\u7528\u3055\u308c\u307e\u3059\u3002\u5b9f\u884c\u3057\u307e\u3059\u304b\uff1f")) != 0) {
            return true;
        }
        return pref.getOutputArchive().exists() && (result = this.dialog.showConfirmMessage("\u51fa\u529b\u30bd\u30fc\u30b9\u30a2\u30fc\u30ab\u30a4\u30d6\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\n\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b\uff1f")) != 0;
    }

    private void back() {
        this.buttonBar.setState(this.buttonBar.INIT_STATE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MergeDocFrame.this.mainPanel.remove(MergeDocFrame.this.progressPanel);
                MergeDocFrame.this.mainPanel.add(MergeDocFrame.this.preferencePanel);
                MergeDocFrame.this.mainPanel.repaint();
            }
        });
        this.setTitle(SETTING_TITLE);
    }

    private void end() {
        this.persistent();
        try {
            this.preferencePanel.persistent();
            Persister.getInstance().store();
        }
        catch (MergeDocException e) {
            this.dialog.showErrorMessage(e.getMessage());
        }
        System.exit(0);
    }

    private void persistent() {
        try {
            Persister psst = Persister.getInstance();
            int state = this.getExtendedState();
            psst.setInt(Persister.WINDOW_STATE, state);
            if (state == 0) {
                psst.setInt(Persister.WINDOW_WIDTH, (int)this.getSize().getWidth());
                psst.setInt(Persister.WINDOW_HEIGHT, (int)this.getSize().getHeight());
                psst.setInt(Persister.WINDOW_X, (int)this.getLocation().getX());
                psst.setInt(Persister.WINDOW_Y, (int)this.getLocation().getY());
            }
        }
        catch (MergeDocException e) {
            this.dialog.showErrorMessage(e.getMessage());
        }
    }

    public void setTitle(final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MergeDocFrame.super.setTitle("MergeDoc - " + title);
            }
        });
    }
}

