/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import mergedoc.MergeDocException;
import mergedoc.core.FastStringUtils;
import mergedoc.core.PatternCache;
import mergedoc.ui.EntryCheckBox;
import mergedoc.ui.MessageDialog;
import mergedoc.xml.ConfigManager;
import mergedoc.xml.ReplaceEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreviewScrollPane
extends JScrollPane {
    private final String originPreviewText;
    private final JTextPane textPane = new JTextPane();
    private final MessageDialog dialog = new MessageDialog(this);

    public PreviewScrollPane() throws MergeDocException {
        JViewport viewport = this.getViewport();
        viewport.setScrollMode(2);
        viewport.setView(this.textPane);
        this.textPane.setEditable(false);
        this.originPreviewText = ConfigManager.getInstance().getPrevewTemplate();
    }

    public void updatePreview(List<EntryCheckBox> entryCheckList) {
        String text = this.originPreviewText;
        for (EntryCheckBox cb : entryCheckList) {
            if (!cb.isSelected()) continue;
            ReplaceEntry entry = cb.getReplaceEntry();
            try {
                text = entry.replace(text);
            }
            catch (IllegalStateException e) {
                this.dialog.showErrorMessage(e.getMessage());
            }
        }
        text = FastStringUtils.optimizeLineSeparator(text);
        int tabSize = 4;
        int tabChar = 35;
        char[] fakeTab = new char[4];
        Arrays.fill(fakeTab, '#');
        text = FastStringUtils.replaceAll(text, "\t", String.valueOf(fakeTab));
        this.textPane.setText(text);
        final JScrollBar bar = this.getVerticalScrollBar();
        final int pos = bar.getValue();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                bar.setValue(pos);
            }
        });
        this.updateColor("(?s)(/\\*[^\\*].+?\\*/)", new Color(63, 127, 95));
        this.updateColor("(?s)(/\\*\\*.+?\\*/)", new Color(63, 95, 191));
        this.updateColor("(class|public|private|void|extends|super)", new Color(127, 0, 85));
        this.updateColor("(?m).*?[ #](//.*)", new Color(63, 127, 95));
        this.updateColor(" (\".*?\")", new Color(42, 0, 255));
        this.updateColor(" (@\\w*) ", new Color(127, 159, 191));
        StyledDocument doc = this.textPane.getStyledDocument();
        SimpleAttributeSet atr = new SimpleAttributeSet();
        Color tabColor = new Color(255, 255, 200);
        StyleConstants.setForeground(atr, tabColor);
        StyleConstants.setBackground(atr, tabColor);
        Pattern pat = PatternCache.getPattern("#{4}");
        Matcher mat = pat.matcher(this.textPane.getText());
        while (mat.find()) {
            int start = mat.start();
            int len = mat.end() - start;
            doc.setCharacterAttributes(start, len, atr, false);
        }
    }

    private void updateColor(String pattern, Color color) {
        StyledDocument doc = this.textPane.getStyledDocument();
        SimpleAttributeSet atr = new SimpleAttributeSet();
        Pattern pat = PatternCache.getPattern(pattern);
        Matcher mat = pat.matcher(this.textPane.getText());
        while (mat.find()) {
            int start = mat.start(1);
            int len = mat.end(1) - start;
            StyleConstants.setForeground(atr, color);
            doc.setCharacterAttributes(start, len, atr, false);
        }
    }
}

