/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.awt.Toolkit;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import jp.sourceforge.mergedoc.pleiades.aspect.AgentOption;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherTransformer;
import jp.sourceforge.mergedoc.pleiades.log.FileLogger;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

public class Agent {
    private static Logger log;
    public static final File configurationPath;
    private static Agent agent;
    private Instrumentation instrumentation;
    private AgentOption agentOption;

    static {
        configurationPath = Agent.getConfigurationPath();
    }

    private static File getConfigurationPath() {
        File baseDir;
        String base;
        Matcher mat;
        String configAreaKey;
        File eclipseHome = FileSystem.resourceRoot.getParentFile().getParentFile().getParentFile();
        File configPath = new File(eclipseHome, "configuration");
        Properties configIni = FileSystem.loadProperties(new File(configPath, "config.ini"));
        String configArea = configIni.getProperty(configAreaKey = "osgi.configuration.area");
        if (configArea == null) {
            configArea = System.getProperty(configAreaKey);
        }
        File userConfigPath = null;
        if (configArea != null && (mat = Pattern.compile("^@([\\w\\.]+)(.+)$").matcher(configArea)).find() && (base = System.getProperty(mat.group(1))) != null && (baseDir = new File(base)).exists()) {
            String childPath = mat.group(2);
            userConfigPath = new File(baseDir, childPath);
        }
        if (userConfigPath == null) {
            userConfigPath = configPath;
        }
        File pleiadesConfigPath = new File(userConfigPath, "jp.sourceforge.mergedoc.pleiades/");
        pleiadesConfigPath.mkdirs();
        return pleiadesConfigPath;
    }

    public static void premain(String agentArg, Instrumentation inst) throws Throwable {
        System.setProperty("pleiades.logger.class.name", FileLogger.class.getName());
        System.setProperty("pleiades.log.file.name", new File(configurationPath, "pleiades.log").getAbsolutePath());
        log = Logger.getLogger(Agent.class);
        try {
            agent = new Agent();
            agent.run(agentArg, inst);
        }
        catch (Throwable e) {
            log.fatal("Pleiades \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u306e\u8d77\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public static Agent getInstance() {
        return agent;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public AgentOption getAgentOption() {
        return this.agentOption;
    }

    private void run(String agentArg, Instrumentation inst) throws Throwable {
        this.agentOption = new AgentOption(agentArg);
        this.instrumentation = inst;
        this.instrumentation.addTransformer(new LauncherTransformer());
        log.info("Pleiades AOP \u7ffb\u8a33\u30b3\u30f3\u30c6\u30ca\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u5f15\u6570=" + agentArg);
        this.initSwingFont();
    }

    private void initSwingFont() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        FontUIResource propoFont = new FontUIResource("MS UI Gothic", 0, 12);
        FontUIResource fixedFont = new FontUIResource("MS Gothic", 0, 12);
        String osName = System.getProperty("os.name", "");
        if (!osName.contains("Windows")) {
            propoFont = new FontUIResource("sansserif", 0, 12);
            fixedFont = new FontUIResource("sansserif", 0, 12);
        }
        for (Object keyObj : UIManager.getLookAndFeelDefaults().keySet()) {
            String key = keyObj.toString();
            if (!key.endsWith("font") && !key.endsWith("Font")) continue;
            UIManager.put(key, propoFont);
        }
        UIManager.put("TextPane.font", fixedFont);
        UIManager.put("TextArea.font", fixedFont);
    }
}

