/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.security.ProtectionDomain;

import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.DictionaryFactory;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationExcludeProperties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * |󏈗𖄂ߍނ߂̃oCgR[hϊsgXtH[}[łB
 * <p>
 * @author C/pHeR
 */
public class TranslationTransformer extends AbstractTransformer {

	/** K[ */
	@SuppressWarnings("unused")
	private static final Logger log = Logger.getLogger(TranslationTransformer.class);
	
	/**
	 * |gXtH[}[\z܂B
	 */
	public TranslationTransformer() {
		
		// AXyNg`[h
		AspectMapping.getInstance();
		
		// |󏜊OLbV[h
		ExcludesClassCache.getInstance();
		
		// |vpeB[[h
		DictionaryFactory.create();
		
		// |svvpeB[[h
		TranslationExcludeProperties.getInstance();
		
		// K\|vpeB[[h
		RegexDictionary.getInstance();
	}
	
	/**
	 * oCgR[hϊ܂B
	 * <p>
	 * {@link TranslationEditor |GfB^[} gpAoCgR[hϊ܂B
	 * A{@link ExcludesClassCache AXyNgOLbV}
	 * ɏNX܂܂ꍇAs܂B
	 */
	protected byte[] transform(
			ClassLoader loader,
			String className,
			ProtectionDomain protectionDomain,
			byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {
		
		boolean isClean = Agent.getInstance().getAgentOption().isClean();
		ExcludesClassCache excludeList = ExcludesClassCache.getInstance();
		if (!isClean && excludeList.remove(className)) {
			return null;
		}
		
		CtClass ctClass = createCtClass(bytecode, protectionDomain);
		TranslationEditor editor = new TranslationEditor(ctClass);
		
		for (CtBehavior ctBehavior : ctClass.getDeclaredBehaviors()) {
			ctBehavior.instrument(editor);
			editor.editBehavior(ctBehavior);
		}
		CtConstructor ctInitializer = ctClass.getClassInitializer();
		if (ctInitializer != null) {
			ctInitializer.instrument(editor);
		}
		byte[] editedBytecode = editor.toBytecode();
		
		if (isClean && editedBytecode == null) {
			excludeList.add(className);
		}
		return editedBytecode;
	}
	
	/**
	 * |gXtH[}[j܂B
	 */
	public static void destroy() {
		
		if (Agent.getInstance().getAgentOption().isClean()) {
			
			// |󏜊OLbVۑ
			ExcludesClassCache.getInstance().store();
			
			// |vpeB[LbVƂĕۑ
			DictionaryFactory.storeCache();
		}
	}
}
