/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipInputStream;

import jp.sourceforge.mergedoc.pleiades.aspect.Agent;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.io.IOUtils;

/**
 * LbVgpłB
 * <p>
 * @author C/pHeR
 */
public class CachedDictionary extends AbstractDictionary {
	
	/** K[ */
	private static final Logger log = Logger.getLogger(CachedDictionary.class);
	
	/** ̎̃LbVt@C */
	public static final File cacheFile =
		new File(Agent.configurationPath, "translation.properties.cache");
	
	/**
	 * ̎\z܂B
	 */
	CachedDictionary() {
		super();
	}
	
	/* ( Javadoc)
	 * @see AbstractDictionary#load()
	 */
	@Override
	@SuppressWarnings("unchecked")
	protected void load() {
		
		if (!cacheFile.exists()) {
			Exception e = new FileNotFoundException(cacheFile.getPath());
			log.fatal(e.toString(), e);
			throw new IllegalStateException(e);
		}
		
		ZipInputStream in = null;
		try {
			in = new ZipInputStream(new BufferedInputStream(new FileInputStream(cacheFile)));
			in.getNextEntry();
			Properties prop = new Properties();
			prop.load(in);
			getMap().putAll((Map<? extends String, ? extends String>) prop);

		} catch (IOException e) {
			log.error(cacheFile.toString(), e);
			throw new IllegalArgumentException(cacheFile.toString(), e);

		} finally {
			IOUtils.closeQuietly(in);
		}
		log.info("|LbV[h܂B" + getMap().size());
	}

	/*
	 * ( Javadoc)
	 * @see AbstractDictionary#lookup(String)
	 */
	// ȑO͖|󌋉ʂLbVĂAĂяopbP[Wɂ
	// |󏜊Oł邽߁ALbVȂB
	// ʏ̖|vpeB[̂݃LbVB
	//@Override
	//public String lookup(String enValue) {
	//	String result = getMap().get(enValue);
	//	if (result == null) {
	//		result = super.lookup(enValue);
	//	}
	//	return result;
	//}
}
