/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.generator;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Map.Entry;

import jp.sourceforge.mergedoc.pleiades.aspect.resource.AbstractDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;
import jp.sourceforge.mergedoc.pleiades.util.UnMnemonicProperties;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/**
 *  NLS }[WAЂƂ̃vpeB[Et@C쐬
 * WFl[^[łB
 * <p>
 * @author C/pHeR
 */
public class Generator {

	/** K[ */
	private static final Logger log = Logger.getLogger(Generator.class);

	/** K\L[vtBbNX */
	private static final String REGEX_KEY_PREFIX = "%REGEX%";

	/** |󏜊OL[vtBbNX */
	private static final String EXCLUDE_KEY_PREFIX = "%EXCLUDE%";

	/** NIvV -clean w肳Ăꍇ true */
	private static boolean isClean;

	/**
	 * WFl[^[Jn邽߂ main \bhłB
	 * <p>
	 * @param args N
	 * @throws IOException o͗Oꍇ
	 */
	public static void main(String... args) throws IOException {
		isClean = ArrayUtils.contains(args, "-clean");
		new Generator().run();
	}

	/** NLS tH_[ */
	private final File nlsFolder = FileSystem.getResourceFile("nls");

	/** NLS }[Wʂi[vpeB[ */
	private Properties nlsAllProp;

	/** NLS }[Wʂi[vpeB[Et@C */
	private final File nlsAllPropFile = FileSystem.getResourceFile("nls/all.properties");

	/** NLS }[Wɓ{vpeB[Gg[i[vpeB[ */
	private Properties nlsPropNotFound = new UnMnemonicProperties();

	/** NLS 擾vOCmFfobOEOo͗p̉pꃊ\[X */
	private final String debugEnValue = "";

	/**
	 * WFl[^[s܂B
	 * <p>
	 * @throws IOException o͗Oꍇ
	 */
	private void run() throws IOException {

		Properties preProp = new Properties();
		Properties regexProp = new Properties();
		Properties excludeProp = new Properties();

		// IWi̖[h (NLS ɓ̂̂Ώ㏑)
		File[] files = FileSystem.getResourceFile("custom/pre").listFiles();
		Arrays.sort(files); // 

		for (File file : files) {
			if (file.isFile() && file.getName().endsWith(".properties")) {

				// |vpeB֕ۊ
				Properties prop = new UnMnemonicProperties(file);
				preProp.putAll(prop);

				// % Ŏn܂vpeB𒊏oAʃvpeB֐U蕪
				for (Object keyObj : prop.keySet()) {

					String key = keyObj.toString();

					if (key.startsWith(REGEX_KEY_PREFIX)) {

						// K\vpeB
						String newKey = key.replaceFirst("^" + REGEX_KEY_PREFIX, "");
						Object value = preProp.remove(key);
						regexProp.put(newKey, value);

					} else if (key.startsWith(EXCLUDE_KEY_PREFIX)) {

						// |󏜊OvpeB
						String newKey = key.replaceFirst("^" + EXCLUDE_KEY_PREFIX, "");
						Object value = preProp.remove(key);
						Object existsValue = excludeProp.get(newKey);
						if (existsValue != null) {
							value = existsValue + "," + value;
						}
						excludeProp.put(newKey, value);
					}
				}
			}
		}

		// NLS SvpeB[[h
		if (isClean) {
			log.info("-clean [hBׂĂ NLS vpeB[č\z܂B");
			nlsAllProp = new UnMnemonicProperties();
			generate(nlsFolder);
			FileSystem.storeProperties(nlsAllProp, nlsAllPropFile);
		} else {
			log.info(" -clean [hBvpeB[̃}[Ŵ݂s܂B");
			nlsAllProp = FileSystem.loadProperties(nlsAllPropFile);
		}

		// IWi̖[h (NLS ɓ̂̂Ώ㏑)
		Properties postProp = new UnMnemonicProperties("custom/post");

		// }[W
		Properties resultProp = new Properties();
		resultProp.putAll(preProp);
		resultProp.putAll(nlsAllProp);
		resultProp.putAll(postProp);

		if (StringUtils.isNotEmpty(debugEnValue)) {
			log.info("> pꃊ\[X: " + debugEnValue);
			log.info("> preProp:  " + preProp.get(debugEnValue));
			log.info("> nlsProp:  " + nlsAllProp.get(debugEnValue));
			log.info("> postProp: " + postProp.get(debugEnValue));
		}

		// |󃋁[ɂuvpeB̃[h
		File replacePropFile = FileSystem.getResourceFile("custom/replace.properties");
		Properties replaceProp = FileSystem.loadProperties(replacePropFile);

		for (Entry entry : new HashMap<Object, Object>(resultProp).entrySet()) {

			String key = (String) entry.getKey();
			String value = (String) entry.getValue();

			// L[ƒl͍̂폜
			if (key.equals(value)) {
				resultProp.remove(entry.getKey());
				continue;
			}

			// |󃋁[ɂuiFj
			for (Entry e : new HashMap<Object, Object>(replaceProp).entrySet()) {

				String k = (String) e.getKey();
				String v = (String) e.getValue();

				if (value.contains(k)) {
					resultProp.put(key, value.replaceAll(k, v));
				}
			}
		}

		// ۑ
		FileSystem.storeProperties(resultProp, FileSystem.getResourceFile(
			AbstractDictionary.DEFAULT_PROPERTIES_FILE_NAME));
		FileSystem.storeProperties(regexProp, FileSystem.getResourceFile(
			"translation-regex.properties"));
		FileSystem.storeProperties(excludeProp, FileSystem.getResourceFile(
			"translation-exclude.properties"));
		FileSystem.storeProperties(nlsPropNotFound, FileSystem.getResourceFile(
			"nls/notfound.properties"));

		// Oo
		String msg = "%-30s %5d";
		log.info(String.format(msg, "Pre load custom properties.", preProp.size()));
		log.info(String.format(msg, "Generated nls properties.", nlsAllProp.size()));
		log.info(String.format(msg, "Post load custom properties.", postProp.size()));
		log.info(String.format(msg, "All properties summary.", resultProp.size()));
		log.info(String.format(msg, "Regex custom properties.", regexProp.size()));
		log.info(String.format(msg, "Exclude custom properties.", excludeProp.size()));
		log.info(String.format(msg, "Not found properties.", nlsPropNotFound.size()));
	}

	/**
	 * w肳ꂽtH_[ɑ݂ NLS ċAIɃ[hA
	 * vpeB[𐶐܂B
	 * <p>
	 * @param nlsFolder NLS tH_[
	 * @throws IOException o͗Oꍇ
	 */
	private void generate(File nlsFolder) throws IOException {

		File[] files = nlsFolder.listFiles();
		Arrays.sort(files); // 

		for (File file : files) {

			if (file.isFile()) continue;
			String name = file.getName();
			if (name.equals("plugins") || name.equals("features")) {
				generatePlugins(file);
			} else {
				generate(file); // ċA
			}
		}
	}

	/**
	 * w肳ꂽvOCEtH_[ɑ݂ NLS [hA
	 * vpeB[𐶐܂B
	 * <p>
	 * @param pluginFolder vOCEtH_[
	 * @throws IOException o͗Oꍇ
	 */
	private void generatePlugins(File pluginFolder) throws IOException {

		Map<String, PropertiesUnit> plugins =
			new HashMap<String, PropertiesUnit>();

		File[] files = pluginFolder.listFiles();
		Arrays.sort(files); // 

		// {Ɖp̃vpeB[[h
		for (File file : files) {

			Plugin plugin = (pluginFolder.getName().equals("plugins"))
				? new Plugin(file) : new Feature(file);

			String msg = "%-46s en:%4d ja:%4d %s";
			log.debug(String.format(msg,
					plugin.getId(),
					plugin.getEnProperties().size(),
					plugin.getJaProperties().size(),
					FileSystem.relativePath(nlsFolder, file)));

			String pluginId = plugin.getId();
			PropertiesUnit propUnit = plugins.get(pluginId);
			if (propUnit == null) {
				propUnit = new PropertiesUnit();
				plugins.put(pluginId, propUnit);
			}
			propUnit.getEnProperties().putAll(plugin.getEnProperties());
			propUnit.getJaProperties().putAll(plugin.getJaProperties());
		}

		// {Ɖp̃vpeB[ŃL[v̂vpeB[쐬
		for (PropertiesUnit propUnit : plugins.values()) {

			Properties enProp = propUnit.getEnProperties();
			Properties jaProp = propUnit.getJaProperties();

			for (Entry jaEntry : jaProp.entrySet()) {

				String key = (String) jaEntry.getKey();
				String enValue = (String) enProp.get(key);
				String jaValue = (String) jaEntry.getValue();

				if (StringUtils.isNotEmpty(enValue) && !enValue.equals(jaValue)) {

					if (jaValue.matches("\\p{ASCII}+")) {
						continue;
					}
					// ɂȂ NLS ŗL̖󒍂܂܂Ă̂͏O
					if (jaValue.contains("̖|łł") || jaValue.contains("̂߂̃hCc")) {
						continue;
					}
					nlsAllProp.put(enValue, jaValue);

					if (debugEnValue.length() > 0 &&
						debugEnValue.equals(UnMnemonicProperties.removeMnemonic(enValue))) {

						log.info("> 擾vOC: " +
								pluginFolder + " " + key + "=" + jaValue);
					}
				}
			}

			// {vpeB݂Ȃꍇ̃vpeB[쐬
			for (Entry enEntry : enProp.entrySet()) {

				String jaValue = (String) jaProp.get(enEntry.getKey());
				String enValue = enEntry.getValue().toString();

				if (jaValue == null &&
					enValue.matches(".*[a-zA-Z].*") &&
					enValue.length() > 1) {

					nlsPropNotFound.put(enValue, "");
				}
			}
		}
	}
}
