/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

import org.apache.commons.io.IOUtils;

/**
 * t@Cɏo͂郍K[łB
 * <p>
 * @author C/pHeR
 */
public class FileLogger extends Logger {
	
	/** OEt@CVXeEvpeB[̃L[ */
	public static final String LOG_FILE_NAME = "pleiades.log.file.name";
	
	/** t@C PrintStream */
	private static PrintStream out;

	/** t@C PrintStream ̏ */
	static {
		
		String logFileName = System.getProperty(LOG_FILE_NAME);
		try {
			File logFile = new File(logFileName);
			logFile.getParentFile().mkdirs();
			logFile.delete();
			out = new PrintStream(
					new BufferedOutputStream(new FileOutputStream(logFile)),
					true);
			
		} catch (FileNotFoundException e) {
			
			throw new RuntimeException("vpeBɎw肳ꂽ " + LOG_FILE_NAME +
					"=" + logFileName + " słB", e);
		}
		
		// VM Vbg_EEtbNƂăt@C PrintStream ̃N[Yo^
		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() {
				IOUtils.closeQuietly(out);
			}
		});
	}
	
	/**
	 * t@CEK[\z܂B
	 * <p>
	 * @param clazz NX
	 */
	FileLogger(Class clazz) {
		super(clazz);
	}
	
	/*
	 * ( Javadoc)
	 * @see Logger#getOut()
	 */
	protected PrintStream getOut() {
		return out;
	}
}
