/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.io.IOUtils;

/**
 * NXELbVłB
 * <p>
 * @author cypher256
 */
abstract public class AbstractClassCache {

	/** K[ */
	private final Logger log = Logger.getLogger(getClass());

	/** NXELbVEt@C */
	private final File file = getFile();

	/** ϊς݃NXE}bv */
	private final Map<String, byte[]> map = new HashMap<String, byte[]>();

	/** [h̎TCY */
	private int loadedSize;

	/**
	 * LbVۑt@C擾܂B
	 * @return LbVEt@C
	 */
	abstract protected File getFile();

	/**
	 * OȂǂ̃bZ[WɎgpLbV擾܂B
	 * @return LbV
	 */
	abstract protected String getName();

	/**
	 * NXELbV\z܂B
	 */
	protected AbstractClassCache() {

		if (Pleiades.getPleiadesOption().isClean()) {
			log.info("-clean ɂ" + getName() + "̓[h܂B");

		} else if (!file.exists()) {
			log.info(getName() + "݂܂B");

		} else {

			ZipInputStream in = null;
			try {
				in = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
				ZipEntry inEntry = null;
				while ((inEntry = in.getNextEntry()) != null) {
					byte[] bytecode = IOUtils.toByteArray(in);
					map.put(inEntry.getName(), bytecode);
				}
				log.info(getName() + "[h܂B" + map.size());

			} catch (IOException e) {
				String msg = getName() + " ̃[hɎs܂B";
				Exception ise = new IllegalStateException(msg, e);
				Pleiades.abort(ise);

			} finally {
				IOUtils.closeQuietly(in);
			}
		}

		// [h̎TCYۑ
		loadedSize = map.size();
	}

	/**
	 * ǉꂽNXLbVƂĉi܂B
	 */
	public void store() {

		if (map.size() > loadedSize) {

			ZipOutputStream out = null;
			try {
				out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
				out.setLevel(Deflater.BEST_SPEED);

				for (Entry<String, byte[]> entry : map.entrySet()) {
					out.putNextEntry(new ZipEntry(entry.getKey()));
					out.write(entry.getValue());
				}
				log.info(getName() + "ۊǂ܂B" +
						loadedSize + " -> " + map.size());

			} catch (IOException e) {
				log.error(getName() + "̕ۊǂɎs܂B", e);

			} finally {
				IOUtils.closeQuietly(out);
			}
		}
	}

	/**
	 * LbVփoCgR[hǉ܂B
	 * <p>
	 * @param className NX
	 * @param bytecode oCgR[h
	 */
	public void put(String className, byte[] bytecode) {
		map.put(className, bytecode);
	}

	/**
	 * LbVoCgR[h擾܂B
	 * <p>
	 * @param className NX
	 * @return oCgR[h
	 */
	public byte[] get(String className) {
		return map.get(className);
	}
}
