/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

/**
 * oCgR[hϊs߂̒ۃNXłB
 * <p>
 * @author cypher256
 */
abstract public class AbstractTransformer implements ClassFileTransformer {

	/** K[ */
	private static final Logger log = Logger.getLogger(AbstractTransformer.class);

	/** ֘ANXpXiSWTAOSGI Ȃǁj */
	private Set<String> relatedClassPathSet = new HashSet<String>();

	/**
	 * oCgR[hϊ܂B
	 * <p>
	 * @see ClassFileTransformer#transform(ClassLoader, String, Class,
	 *          java.security.ProtectionDomain, byte[])
	 */
	public byte[] transform(
			ClassLoader loader,
			String internalName,
			Class<?> classBeingRedefined,
			ProtectionDomain protectionDomain,
			byte[] bytecode) throws IllegalClassFormatException {

		if (loader == null ||
			internalName.startsWith("java/") ||
			internalName.startsWith("javax/") ||
			internalName.startsWith("sun/") ||
			internalName.startsWith("com/sun/") ||
			internalName.startsWith("org/apache/commons") ||
			internalName.startsWith("jp/sourceforge/mergedoc/pleiades/")) {

			// JDK  Pleiades g̓oCgR[hϊȂ
			return null;
		}

		try {
			if (protectionDomain != null) {

				URL location = protectionDomain.getCodeSource().getLocation();
				if (location != null) {

					String locationPath = location.getPath();
					if (locationPath.contains("org.apache.jasper_")) {

						// Eclipse wv HTTP 500 G[
						// jasper vOC̓oCgR[hϊȂ
						return null;

					} else if (
						locationPath.contains("org.eclipse.osgi_") ||
						locationPath.contains("org.eclipse.core.resources_") ||
						locationPath.contains("org.eclipse.ui.workbench_") ||
						locationPath.contains("org.eclipse.jface_") ||
						locationPath.contains("org.eclipse.jdt.core_") ||
						locationPath.contains("org.eclipse.jdt.ui_") ||
						locationPath.contains("org.eclipse.swt.") ||
						locationPath.contains("mergedoc.jstyle.swt"))
					{
						// oCgR[hϊɕKvȊ֘ANXpXۊ
						String classPath = FileSystem.decodePath(locationPath);
						synchronized (this) {
							relatedClassPathSet.add(classPath);
						}
					}
				}
			}

			// oCgR[hϊev[gE\bȟĂяo
			String className = internalName.replace('/', '.');
			return transform(loader, className, protectionDomain, bytecode);

		} catch (Throwable e) {

			String msg = "oCgR[hϊɎs܂B" + internalName;
			log.error(msg, e);
			throw new IllegalClassFormatException(msg + " :" + e);
		}
	}

	/**
	 * oCgR[hϊ邽߂̃ev[gE\bhłB
	 * <p>
	 * @param loader NXE[_[
	 * @param className NX
	 * @param protectionDomain veNVEhC
	 * @param bytecode oCgR[h
	 * @return ϊ̃oCgR[hBϊKvꍇ nullB
	 * @throws CannotCompileException NXRpCoȂꍇ
	 * @throws NotFoundException NXȂꍇ
	 * @throws IOException o͗Oꍇ
	 */
	abstract protected byte[] transform(
			ClassLoader loader,
			String className,
			ProtectionDomain protectionDomain,
			byte[] bytecode
	) throws CannotCompileException, NotFoundException, IOException;

	/**
	 * oCgR[hw肵 CtClass IuWFNg쐬܂B
	 * <p>
	 * @param bytecode oCgR[h
	 * @param protectionDomain veNVEhC
	 * @return CtClass IuWFNg
	 * @throws IOException o͗Oꍇ
	 * @throws NotFoundException NXȂꍇ
	 */
	protected CtClass createCtClass(
			byte[] bytecode,
			ProtectionDomain protectionDomain) throws IOException, NotFoundException {

		// NXv[̍쐬
		ClassPool classPool = new ClassPool();
		classPool.appendSystemPath();
		synchronized (this) {
			for (String relatedClassPath : relatedClassPathSet) {
				classPool.appendClassPath(relatedClassPath);
			}
		}

		// CtClass IuWFNg쐬
		return classPool.makeClass(new ByteArrayInputStream(bytecode));
	}

	/**
	 * w肳ꂽ CtClass IuWFNgׂẴRXgN^
	 * \bhLqqOɏo͂܂B
	 * <p>
	 * @param ctClass CtClass IuWFNg
	 */
	protected void logDescriptor(CtClass ctClass) {
		for (CtBehavior behavior : ctClass.getDeclaredBehaviors()) {
			log.info("DESCRIPTOR: " +
					ctClass.getName() + "#" +
					behavior.getName() + " " +
					behavior.getMethodInfo().getDescriptor());
		}
	}
}
