/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;

import jp.sourceforge.mergedoc.pleiades.log.FileLogger;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.log.PopupFileLogger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

/**
 * Pleiades N邽߂̃G[WFgłB
 * <p>
 * @author cypher256
 */
public class Pleiades {

	/** K[ */
	private static Logger log;

	/** Pleiades NIvV */
	private static PleiadesOption pleiadesOption;

	/** RtBO[VEpX */
	private static File configurationPath;

	/** CXgDe[V */
	private static Instrumentation instrumentation;

	/** 񓯊^XNsT[rX */
	private static ExecutorService executorService;

	/** fobO̎ԌvK[̃Xg */
	private static List<ITimingLogger> timeingLoggers;

	/**
	 * NGg[E|CgƂȂ premain \bhłB
	 * <p>
	 * @param option -javaagent N
	 * @param inst CXgDe[V
	 * @throws Throwable
	 * @throws Throwable łȂG[ꍇ
	 */
	public static void premain(final String option, final Instrumentation inst) throws Throwable {
		
		try {
			// Pleiades NIvV쐬
			pleiadesOption = new PleiadesOption(option);

			// CXgDe[V
			instrumentation = inst;

			// K[̏
			File logFile = new File(getConfigurationPath(), "pleiades.log");
			System.setProperty(FileLogger.LOG_FILE_NAME, logFile.getAbsolutePath());
			System.setProperty(Logger.LOGGER_CLASS_NAME, PopupFileLogger.class.getName());
			System.setProperty(Logger.LOG_LEVEL, pleiadesOption.getLogLevel());
			log = Logger.getLogger(Pleiades.class);

		} catch (Throwable e) {

			e.printStackTrace();
			throw e;
		}
		
		try {
			// 񓯊^XNsT[rX̐
			executorService = new SafetyExecutorService();
			executorService.execute(new Runnable(){
				public void run() {
					
					// Swing ̃tHgB
					try {
						initSwingFont();
					} catch (Throwable e) {
						// ̏T|[gȂ̏ꍇB
						// Fedora6, 7 ł NPE B
						log.debug("Swing  LookAndFeel ݒɎs܂B" + e);
					}
					
					// VXeEvpeB[OƂďo (񓯊s)
					if (log.isDebugEnabled()) {
						File file = new File(getConfigurationPath(), "system.properties");
						FileSystem.storeProperties(
								System.getProperties(), file, "sVXeEvpeB[");
					}
				}
			});

			// NgXtH[}[Jn
			if (log.isDebugEnabled()) {
				inst.addTransformer(new LauncherLoggingTransformer());
			} else {
				inst.addTransformer(new LauncherTransformer());
			}
			log.info("Pleiades AOP |Rei[Jn܂BPleiades NIvV:" + option);
			
		} catch (Throwable e) {
			
			abort(e);
		}
	}
	
	/**
	 * I܂B
	 * @param e O
	 */
	public static void abort(Throwable e) {
		try {
			log.fatal("Pleiades AOP |Rei[̋NɎs܂B\n" +
					"NIvV -clean w肵ċNĂB", e);
			executorService.shutdownNow();
		} finally {
			System.exit(-1);
		}
	}

	/**
	 * RtBO[VEpX擾܂B
	 * @return RtBO[VEpX
	 */
	public static File getConfigurationPath() {

		if (configurationPath != null) {
			return configurationPath;
		}

		File eclipseHome = FileSystem.resourceRoot.getParentFile().getParentFile().getParentFile();
		File configPath = new File(eclipseHome, "configuration");
		Properties configIni = FileSystem.loadProperties(new File(configPath, "config.ini"));

		final String CONFIG_AREA_KEY = "osgi.configuration.area";
		String configArea = configIni.getProperty(CONFIG_AREA_KEY);
		if (configArea == null) {
			configArea = System.getProperty(CONFIG_AREA_KEY);
		}

		File userConfigPath = null;
		if (configArea != null) {
			Matcher mat = Pattern.compile("^@([\\w\\.]+)(.+)$").matcher(configArea);
			if (mat.find()) {
				String base = System.getProperty(mat.group(1));
				if (base != null) {
					File baseDir = new File(base);
					if (baseDir.exists()) {
						String childPath = mat.group(2);
						userConfigPath = new File(baseDir, childPath);
					}
				}
			}
		}
		if (userConfigPath == null) {
			userConfigPath = configPath;
		}
		configurationPath = new File(userConfigPath, "jp.sourceforge.mergedoc.pleiades/");
		configurationPath.mkdirs();
		return configurationPath;
	}

	/**
	 * Swing ŎgptHg܂B
	 * Eclipse ̃vOC͒ʏ SWT gpĂ܂A
	 * ꕔ̃vOCł Swing pĂ܂B
	 * <p>
	 * @throws ClassNotFoundException LookAndFeel NXȂꍇ
	 * @throws InstantiationException NX̐VCX^X𐶐łȂꍇ
	 * @throws IllegalAccessException NX܂͏qɃANZXłȂꍇ
	 * @throws UnsupportedLookAndFeelException lnf.isSupportedLookAndFeel()  false ̏ꍇ
	 */
	private static void initSwingFont() throws
		ClassNotFoundException,
		InstantiationException,
		IllegalAccessException,
		UnsupportedLookAndFeelException
	{
		String osName = System.getProperty("os.name", "").toLowerCase();
		
		// Mac OSX ł͔񓯊ōsƋI邽߉ȂB
		// ł^C~OɂCxgfBXpb`Xbh NPE B
		if (osName.contains("mac")) {
			return;
		}
		
		// LookAndFeel ̐ݒ
		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		Toolkit.getDefaultToolkit().setDynamicLayout(true);

		// tHgݒ
		Object propoFont = new FontUIResource("MS UI Gothic", Font.TRUETYPE_FONT, 12);
		Object fixedFont = new FontUIResource("MS Gothic", Font.TRUETYPE_FONT, 12);
		if (!osName.contains("windows")) {

			// Windows ȊO͘_tHgŎw
			propoFont = new FontUIResource("sansserif", Font.TRUETYPE_FONT, 12);
			fixedFont = new FontUIResource("sansserif", Font.TRUETYPE_FONT, 12);
		}

		// UׂẴR|[lg̃tHgv|[ViɂB
		// tHg\[X̔͒l擾 instanceof FontUIResource 
		// SAUIDefaults  Lazy Value 𐶂ߖ̕ŔB
		for (Object keyObj : UIManager.getLookAndFeelDefaults().keySet()) {
			String key = keyObj.toString();
			if (key.endsWith("font") || key.endsWith("Font")) {
				UIManager.put(key, propoFont);
			}
		}

		// R|[lg̃tHg𓙕ɂ
		UIManager.put("TextPane.font", fixedFont);
		UIManager.put("TextArea.font", fixedFont);
	}

	/**
	 * CXgDe[V擾܂B
	 * <p>
	 * @return CXgDe[V
	 */
	public static Instrumentation getInstrumentation() {
		return instrumentation;
	}

	/**
	 * Pleiades NIvV擾܂B
	 * <p>
	 * @return Pleiades NIvV
	 */
	public static PleiadesOption getPleiadesOption() {
		return pleiadesOption;
	}

	/**
	 * 񓯊^XNsT[rX擾܂B
	 * @return 񓯊^XNsT[rX
	 */
	public static ExecutorService getExecutorService() {
		return executorService;
	}

	/**
	 * ԌvK[o^܂B
	 * <p>
	 * @param timeingLogger ԌvK[
	 */
	public static void registTimingLogger(ITimingLogger timeingLogger) {
		getTimeingLoggers().add(timeingLogger);
	}

	/**
	 * ԌvK[̃Xg擾܂B
	 * <p>
	 * @return ԌvK[̃Xg
	 */
	public static List<ITimingLogger> getTimeingLoggers() {
		if (timeingLoggers == null) {
			timeingLoggers = new LinkedList<ITimingLogger>();
		}
		return timeingLoggers;
	}
}
