/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.advice;

import java.util.LinkedList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * |CgEJbgłB
 * <p>
 * @author cypher256
 */
public class PointCut {

	/** ^C~O enum */
	public static enum Timing {
		/** O */
		AROUND,
		/** O */
		BEFORE,
		/**  */
		AFTER
	}

	/** ^C~O */
	private Timing timing;

	/** AhoCX */
	private String advice;

	/** WCgE|Cg */
	private JointPoint jointPoint;

	/** OWCgE|CgEXg */
	private List<JointPoint> excludeWheres;

	/** WCgE|CgEXg */
	private List<JointPoint> includeWheres;

	/** Og[XEWCgE|CgEXg */
	private List<JointPoint> excludeTrace;

	/** g[XEWCgE|CgEXg */
	private List<JointPoint> includeTrace;

	/**
	 * |CgEJbg\z܂B
	 */
	public PointCut() {
	}

	/**
	 * |CgEJbg\z܂B<br>
	 * ̃V[ERs[sRXgN^łB
	 * <p>
	 * @param pointCut |CgJbg
	 */
	public PointCut(PointCut pointCut) {
		timing = pointCut.timing;
		advice = pointCut.advice;
	}

	/**
	 * AhoCX擾܂B
	 * <p>
	 * @return AhoCX
	 */
	public String getAdvice() {
		return "{" + advice + "}";
	}

	/**
	 * AhoCXZbg܂B
	 * <p>
	 * @param advice AhoCX
	 */
	public void setAdvice(String advice) {
		this.advice = advice;
	}

	/**
	 * ^C~O擾܂B
	 * <p>
	 * @return ^C~O
	 */
	public Timing getTiming() {
		return timing;
	}

	/**
	 * ^C~OZbg܂B
	 * <p>
	 * @param timing ^C~O
	 */
	public void setTiming(String timing) {
		try {
			this.timing = Timing.valueOf(timing.toUpperCase());
		} catch (RuntimeException e) {
			throw new IllegalArgumentException(
				timing + " is illegal timing. " +
				StringUtils.join(Timing.values(), " or "));
		}
	}

	/**
	 * WCgE|Cg擾܂B
	 * <p>
	 * @return WCgE|Cg
	 */
	public JointPoint getJointPoint() {
		return jointPoint;
	}

	/**
	 * WCgE|CgZbg܂B
	 * <p>
	 * @param jointPoint WCgE|Cg
	 */
	public void setJointPoint(JointPoint jointPoint) {
		this.jointPoint = jointPoint;
	}

	/**
	 * OWCgE|CgEXg擾܂B
	 * <p>
	 * @return OWCgE|CgEXg
	 */
	public List<JointPoint> getExcludeWheres() {
		if (excludeWheres == null) {
			excludeWheres = new LinkedList<JointPoint>();
		}
		return excludeWheres;
	}

	/**
	 * WCgE|CgEXg擾܂B
	 * <p>
	 * @return WCgE|CgEXg
	 */
	public List<JointPoint> getIncludeWheres() {
		if (includeWheres == null) {
			includeWheres = new LinkedList<JointPoint>();
		}
		return includeWheres;
	}

	/**
	 * Og[XEWCgE|CgEXg擾܂B
	 * <p>
	 * @return Og[XEWCgE|CgEXg
	 */
	public List<JointPoint> getExcludeTrace() {
		if (excludeTrace == null) {
			excludeTrace = new LinkedList<JointPoint>();
		}
		return excludeTrace;
	}

	/**
	 * g[XEWCgE|CgEXg擾܂B
	 * <p>
	 * @return g[XEWCgE|CgEXg
	 */
	public List<JointPoint> getIncludeTrace() {
		if (includeTrace == null) {
			includeTrace = new LinkedList<JointPoint>();
		}
		return includeTrace;
	}

	/**
	 * ̃IuWFNg̕\擾܂B
	 */
	@Override
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append("timing", this.timing)
			.append("advice", getAdvice())
			.append("excludeWheres", this.excludeWheres)
			.append("includeWheres", this.includeWheres)
			.append("excludeTrace", this.excludeTrace)
			.append("includeTrace", this.includeTrace)
			.toString();
	}
}
