/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.AbstractTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;
import jp.sourceforge.mergedoc.pleiades.util.UnMnemonicProperties;

/**
 * LbV@\юsO@\|󎫏NXłB
 * Eclipse s̓I|ɗpNXłB
 * <p>
 * @author cypher256
 */
public class DynamicTranslationDictionary extends AbstractTranslationDictionary {

	//////////////////////////////////////////////////////////////////////////
	// X^eBbN

	/** K[ */
	private static final Logger log = Logger.getLogger(DynamicTranslationDictionary.class);

	/** |LbVEvpeB[Et@C */
	private static final File cacheFile = new File(
			Pleiades.getConfigurationPath(), "translation-cached.properties");

	/** ̃NX̃VOgECX^X */
	private static final DynamicTranslationDictionary singleton;
	static {
		if (log.isDebugEnabled()) {
			singleton = new DynamicTranslationLoggingDictionary();
		} else {
			singleton = new DynamicTranslationDictionary();
		}
	}

	/**
	 * |󎫏CX^X擾܂B
	 * <p>
	 * @return |󎫏CX^X
	 */
	public static DynamicTranslationDictionary getInstance() {
		return singleton;
	}

	//////////////////////////////////////////////////////////////////////////
	// CX^XEtB[h

	/** [h̎TCY */
	private int loadedSize;

	//////////////////////////////////////////////////////////////////////////
	// I[o[Ch

	@Override
	protected String getValue(String enNoMnemonic) {

		// e̓\bhĂяo
		String result = super.getValue(enNoMnemonic);

		// ̋NpɃLbV
		getMap().put(enNoMnemonic, result);

		return result;
	}

	@Override
	protected String editMnemonicEnToJa(String en, String enNoMnemonic,
			String jaNoMnemonic) {

		// j[jbNȂ̎w肪ꍇ͉Ȃ
		if (Pleiades.getPleiadesOption().isNoMnemonic()) {
			return jaNoMnemonic;
		}
		// e̓\bhĂяo
		return super.editMnemonicEnToJa(en, enNoMnemonic, jaNoMnemonic);
	}

	@Override
	protected void load() {

		// -clean ̏ꍇA|󎫏[h
		if (Pleiades.getPleiadesOption().isClean() || !cacheFile.exists()) {
			
			super.load();
		}
		// -clean łȂꍇA|󎫏LbV[h
		else {
			Map<String, String> map = getMap();
			map.putAll(loadProperties(cacheFile));
			log.info("|󎫏LbV[h܂B" + map.size());
		}

		// [h̎TCYۑ
		loadedSize = getMap().size();
	}

	//////////////////////////////////////////////////////////////////////////
	// J\bh

	/**
	 * |vpeB[LbVƂĉi܂B
	 */
	public void store() {

		Map<String, String> map = getMap();

		if (map.size() > loadedSize) {
			Properties prop = new Properties();
			prop.putAll(map);
			FileSystem.storeProperties(prop, cacheFile, "|󎫏LbVEvpeB[");
			log.info("|󎫏LbVۊǂ܂B" +
					loadedSize + " -> " + prop.size());
		}
	}

	/**
	 * w肵pꃊ\[X񂩂{ꃊ\[XT܂B
	 * j[jbN͓{pɕϊ܂B
	 * <p>
	 * @param en pꃊ\[X
	 * @param jointPoint WCgE|Cg
	 * @return {ꃊ\[X
	 */
	public String lookup(String en, JointPoint jointPoint) {

		// (&A) ̂悤ȓ{p̃j[jbNɊ܂܂Ăꍇ
		// |ς݂ł邽߁AȂ
		if (UnMnemonicProperties.hasJaMnemonic(en)) {
			return en;
		}

		// pꃊ\[X񂩂j[jbN䕶 & 
		String enNoMnemonic = UnMnemonicProperties.removeEnMnemonic(en);

		// |svȏꍇ́Â܂ܕԂ
		if (isNoTranslation(enNoMnemonic, jointPoint)) {
			return enNoMnemonic;
		}

		// |vpeB[{擾
		String jaNoMnemonic = getValue(enNoMnemonic);

		// j[jbN{pɕϊB
		// ̕ϊ͖ꂪȂꍇsB
		String ja = editMnemonicEnToJa(en, enNoMnemonic, jaNoMnemonic);

		return ja;
	}

	/**
	 * w肵pꃊ\[X񂩂{ꃊ\[XT܂B
	 * j[jbN͏܂B
	 * <p>
	 * @param en pꃊ\[X
	 * @param jointPoint WCgE|Cg
	 * @return {ꃊ\[X
	 */
	public String lookupIgnoreMnemonic(String en, JointPoint jointPoint) {

		// (&A) ̂悤ȓ{p̃j[jbNɊ܂܂Ăꍇ
		// |ς݂ł邽߁AȂ
		if (UnMnemonicProperties.hasJaMnemonic(en)) {
			return en;
		}

		// |svȏꍇ́Â܂ܕԂ
		if (isNoTranslation(en, jointPoint)) {
			return en;
		}

		// |vpeB[{擾
		String ja = getValue(en);

		return ja;
	}

	//////////////////////////////////////////////////////////////////////////
	// [JE\bh

	/**
	 * |󂪕sv肵܂B
	 * ĂяõpbP[WNXɔ肳܂B
	 * <p>
	 * @param enNoMnemonic pꃊ\[Xij[jbNj
	 * @param jointPoint WCgE|Cg
	 * @return |󂪕svȏꍇ true
	 */
	protected boolean isNoTranslation(String enNoMnemonic, JointPoint jointPoint) {

		final int TRACE_MAX = 30;
		StackTraceElement[] stes = null;

		// xml [exclludeTrace] Ăяog[Xɂ鏜OiċAIɑkj
		if (jointPoint != null) {

			PointCut pointCut = AspectMapping.getInstance().getPointCut(jointPoint);
			if (pointCut != null) {

				List<JointPoint> excludeTrace = pointCut.getExcludeTrace();
				if (excludeTrace.size() > 0) {

					stes = Thread.currentThread().getStackTrace();
					for (JointPoint jp : excludeTrace) {

						for (int i = 0; i < TRACE_MAX && i < stes.length; i++) {

							StackTraceElement ste = stes[i];
							String className = jp.getClassName();
							if (className.equals(ste.getClassName())) {

								String methodName = jp.getMethodName();
								if (methodName == null || methodName.equals(ste.getMethodName())) {
									return true;
								}
							}
						}
					}
				}
			}
		}

		// properties [%EXCULUDE%] Ăяoɂ鏜OiƃpbP[WPʁj
		Set<String> noTransPathEntries = TranslationExcludeProperties
				.getInstance().getPathEntries(enNoMnemonic);

		if (noTransPathEntries != null) {
			if (stes == null) {
				stes = Thread.currentThread().getStackTrace();
			}
			for (int i = 0; i < TRACE_MAX && i < stes.length; i++) {

				StackTraceElement ste = stes[i];
				String className = ste.getClassName();

				for (String noTransPath : noTransPathEntries) {
					if (className.startsWith(noTransPath)) {
						return true;
					}
				}
			}
		}
		return false;
	}
}
