/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.lang.reflect.Field;

import jp.sourceforge.mergedoc.pleiades.aspect.ITimingLogger;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * ԌvO@\t̎łB
 * <p>
 * @author cypher256
 */
public class DynamicTranslationLoggingDictionary extends DynamicTranslationDictionary implements ITimingLogger {

	/** K[ */
	private static final Logger log = Logger.getLogger(DynamicTranslationLoggingDictionary.class);

	/** convert \bh̏v */
	private volatile long applyConverterTime;

	/** convert \bȟĂяo */
	private volatile long applyConverterCall;

	/** lookup \bh̏v */
	private volatile long lookupTime;

	/** lookup \bȟĂяo */
	private volatile long lookupCall;

	/** lookupNoMnemonic \bh̏v */
	private volatile long lookupIgnoreMnemonicTime;

	/** lookupNoMnemonic \bȟĂяo */
	private volatile long lookupIgnoreMnemonicCall;

	/** getJaValue \bh̏v */
	private volatile long getValueTime;

	/** getJaValue \bȟĂяo */
	private volatile long getValueCall;

	/** getJaValueByRegex \bh̏v */
	private volatile long getValueToTrimTime;

	/** getJaValueByRegex \bȟĂяo */
	private volatile long getValueToTrimCall;

	/** getJaValueByRegex \bh̏v */
	private volatile long getValueByRegexTime;

	/** getJaValueByRegex \bȟĂяo */
	private volatile long getValueByRegexCall;

	/** isNoTranslation \bh̏v */
	private volatile long isNoTranslationTime;

	/** isNoTranslation \bȟĂяo */
	private volatile long isNoTranslationCall;

	/** editMnemonicEnToJa \bh̏v */
	private volatile long editMnemonicEnToJaTime;

	/** editMnemonicEnToJa \bȟĂяo */
	private volatile long editMnemonicEnToJaCall;

	/**
	 * ̎\z܂B
	 */
	DynamicTranslationLoggingDictionary() {
		Pleiades.registTimingLogger(this);
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected void applyConverter() {

		long startTime = System.currentTimeMillis();
		super.applyConverter();
		synchronized (this) {
			applyConverterTime += System.currentTimeMillis() - startTime;
			applyConverterCall++;
		}
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	public String lookup(String enValue, JointPoint jointPoint) {

		long startTime = System.currentTimeMillis();
		String result = super.lookup(enValue, jointPoint);
		synchronized (this) {
			lookupTime += System.currentTimeMillis() - startTime;
			lookupCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	public String lookupIgnoreMnemonic(String enValue, JointPoint jointPoint) {

		long startTime = System.currentTimeMillis();
		String result = super.lookupIgnoreMnemonic(enValue, jointPoint);
		synchronized (this) {
			lookupIgnoreMnemonicTime += System.currentTimeMillis() - startTime;
			lookupIgnoreMnemonicCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected String getValue(String enNoMnemonic) {

		long startTime = System.currentTimeMillis();
		String result = super.getValue(enNoMnemonic);
		synchronized (this) {
			getValueTime += System.currentTimeMillis() - startTime;
			getValueCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected String getValueToTrim(String enNoMnemonic) {

		long startTime = System.currentTimeMillis();
		String result = super.getValueToTrim(enNoMnemonic);
		synchronized (this) {
			getValueToTrimTime += System.currentTimeMillis() - startTime;
			getValueToTrimCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected String getValueByRegex(String enNoMnemonic) {

		long startTime = System.currentTimeMillis();
		String result = super.getValueByRegex(enNoMnemonic);
		synchronized (this) {
			getValueByRegexTime += System.currentTimeMillis() - startTime;
			getValueByRegexCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected boolean isNoTranslation(String enValueNonMnemonic, JointPoint jointPoint) {

		long startTime = System.currentTimeMillis();
		boolean result = super.isNoTranslation(enValueNonMnemonic, jointPoint);
		synchronized (this) {
			isNoTranslationTime += System.currentTimeMillis() - startTime;
			isNoTranslationCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected String editMnemonicEnToJa(String enValue,
			String enValueNonMnemonic, String result) {

		long startTime = System.currentTimeMillis();
		String jaResult = super.editMnemonicEnToJa(enValue, enValueNonMnemonic, result);
		synchronized (this) {
			editMnemonicEnToJaTime += System.currentTimeMillis() - startTime;
			editMnemonicEnToJaCall++;
		}
		return jaResult;
	}

	/**
	 * ԌvOo͂܂B
	 * @return vԍv (b)
	 */
	public long logTime() {

		String msg = "%-30s %8d ďov %6.3f b";

		log.debug(String.format(msg, "applyConverter", applyConverterCall, applyConverterTime / 1000d));
		log.debug(String.format(msg, "lookupIgnoreMnemonic", lookupIgnoreMnemonicCall, lookupIgnoreMnemonicTime / 1000d));
		log.debug(String.format(msg, "lookup", lookupCall, lookupTime / 1000d));
		log.debug(String.format(msg, "  editMnemonicEnToJa", editMnemonicEnToJaCall, editMnemonicEnToJaTime / 1000d));
		log.debug(String.format(msg, "  getValue", getValueCall, getValueTime / 1000d));
		log.debug(String.format(msg, "    isNoTranslation", isNoTranslationCall, isNoTranslationTime / 1000d));
		log.debug(String.format(msg, "    getValueToTrim", getValueToTrimCall, getValueToTrimTime / 1000d));
		log.debug(String.format(msg, "      getValueByRegex", getValueByRegexCall, getValueByRegexTime / 1000d));

		long summuryTime =
			applyConverterTime + lookupIgnoreMnemonicTime + lookupTime +
			editMnemonicEnToJaTime + getValueTime + isNoTranslationTime +
			getValueToTrimTime + getValueByRegexTime;

		log.debug(String.format("NXv %6.3f b", summuryTime / 1000d));

		return summuryTime;
	}

	/**
	 * vlZbg܂B
	 */
	public void reset() {

		synchronized (this) {
			Field[] fields = getClass().getDeclaredFields();
			for (int i = 0; i < fields.length; i++) {
				Field field = fields[i];
				if (field.getType() == Long.TYPE) {
					try {
						field.setAccessible(true);
						field.set(this, 0L);
					} catch (Exception e) {
						log.error("tB[h̏Ɏs܂B", e);
					}
				}
			}
		}
	}
}
