/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Map.Entry;

import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;
import jp.sourceforge.mergedoc.pleiades.util.UnMnemonicProperties;

/**
 * ۖ|󎫏NXłB
 * <p>
 * @author cypher256
 */
abstract public class AbstractTranslationDictionary {

	/** K[ */
	private static final Logger log = Logger.getLogger(AbstractTranslationDictionary.class);

	/** ftHg|vpeB[Et@C */
	public static final String PROP_FILE_NAME = "translation.properties";

	/** |vpeB[ǉfBNg[ */
	private static final String ADDITIONS_DIRECTORY = "additions";

	/** ϊvpeB[Et@C */
	public static final String CONVERTER_PROPERTIES_FILE_NAME = "translation-converter.properties";

	/** |vpeB[ێ}bv */
	private final Map<String, String> map = new HashMap<String, String>();

	/**
	 * ftHg\z܂B
	 */
	protected AbstractTranslationDictionary() {
		load();
	}

	/**
	 * t@C[h܂B
	 */
	protected void load() {

		File propFile = FileSystem.getResourceFile(PROP_FILE_NAME);
		if (!propFile.exists()) {
			Exception e = new FileNotFoundException(propFile.getPath());
			Exception ise = new IllegalStateException("|󎫏܂B", e);
			Pleiades.abort(ise);
		}
		map.putAll(loadProperties(propFile));

		File additions = FileSystem.getResourceFile(ADDITIONS_DIRECTORY);
		if (additions.exists()) {

			File[] files = additions.listFiles();
			Arrays.sort(files); // 

			for (File file : files) {
				if (file.isFile() && file.getName().endsWith(".properties")) {
					map.putAll(loadProperties(file));
				}
			}
		}
		log.info("|󎫏[h܂B" + map.size());

		// ϊvpeB[Kp
		applyConverter();
	}

	/**
	 * ϊvpeB[Kp܂B
	 */
	protected void applyConverter() {

		File convFile = FileSystem.getResourceFile(CONVERTER_PROPERTIES_FILE_NAME);
		if (convFile.exists()) {

			Map<String, String> convMap = new HashMap<String, String>();
			convMap.putAll(loadProperties(convFile));

			for (Entry<String, String> entry : map.entrySet()) {

				String key = entry.getKey();
				String value = entry.getValue();
				String resultValue = value;

				// uiF{Ɂق܂Ɂj
				for (Entry<String, String> e : convMap.entrySet()) {
					String convKey = e.getKey();
					String convValue = e.getValue();
					resultValue = resultValue.replaceAll(convKey, convValue);
				}
				if (!value.equals(resultValue)) {
					map.put(key, resultValue);
				}
			}
		}
	}

	/**
	 * |vpeB[ێ}bv擾܂B
	 * @return |vpeB[ێ}bv
	 */
	protected Map<String, String> getMap() {
		return map;
	}

	/**
	 * w肵vpeB[Et@C[h܂B
	 * <p>
	 * @param file vpeB[Et@C
	 * @return }bv
	 */
	@SuppressWarnings("unchecked")
	protected Map<? extends String, ? extends String> loadProperties(File file) {

		Properties prop = FileSystem.loadProperties(file);
		return (Map<? extends String, ? extends String>) prop;
	}

	/**
	 * {擾܂B
	 * <p>
	 * @param enNoMnemonic pꃊ\[Xij[jbNj
	 * @return {ꃊ\[Xij[jbNjB|łȂꍇ enNoMnemonicB
	 */
	protected String getValue(String enNoMnemonic) {

		// |vpeB[{擾
		String result = map.get(enNoMnemonic);

		// |vpeB[擾łȂꍇ
		if (result == null) {

			// trim čēx擾
			result = getValueToTrim(enNoMnemonic);
		}

		// DEBUG
		//if (enNoMnemonic.equals("workspace2")) {
		//	String s = System.currentTimeMillis() + " [" + enNoMnemonic + "]  [" + result + "]";
		//	log.debug("fobO|ǐՃX^bNg[X", new Exception(s));
		//	return s;
		//}

		// Ȃꍇ͂̂܂ܕԂ
		if (result == null) {
			result = enNoMnemonic;
		}

		return result;
	}

	/**
	 * trim ē{ꃊ\[X擾܂B
	 * <p>
	 * @param enNoMnemonic pꃊ\[Xij[jbNj
	 * @return {ꃊ\[Xij[jbNjB|łȂꍇ nullB
	 */
	protected String getValueToTrim(String enNoMnemonic) {

		// 擪Xy[Xޔ
		StringBuilder leading = new StringBuilder();
		char[] cArray = enNoMnemonic.toCharArray();
		for (int i = 0; i < cArray.length; i++) {
			char c = cArray[i];
			if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
				leading.append(c);
			} else {
				break;
			}
		}
		if (leading.length() == enNoMnemonic.length()) {
			return null;
		}

		// Xy[XA:A... ޔ
		StringBuilder trailing = new StringBuilder();
		for (int i = cArray.length - 1; i > 0; i--) {
			char c = cArray[i];
			if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == ':') {
				trailing.insert(0, c);
			} else if (c == '.' && i > 2 && cArray[i - 1] == '.' && cArray[i - 2] == '.') {
				trailing.insert(0, "...");
				i -= 2;
			} else {
				break;
			}
		}

		// OXy[X
		String enTrimmed = enNoMnemonic.substring(
				leading.length(), enNoMnemonic.length() - trailing.length());

		// ēxA|vpeB[{擾
		String result = map.get(enTrimmed);

		// DEBUG
		//if (result != null && !result.equals(enTrimmed)) {
		//	log.debug("OXy[X[" + enTrimmed + "] [" + enNoMnemonic +
		//			"] |󌋉[" + leading + result + trailing + "]");
		//}

		// |vpeB[擾łȂꍇ
		if (result == null) {

			// K\vpeB[{擾
			result = getValueByRegex(enTrimmed);

			// 󂪌Ȃꍇ̃Oo
			if (result == null) {
				TranslationNotFoundProperties.getInstance().println(enNoMnemonic);
			}
		}

		// OXy[X𕜌
		if (result != null) {
			result = leading + result + trailing;
		}

		return result;
	}

	/**
	 * K\{ꃊ\[X擾܂B
	 * <p>
	 * @param enTrimmed pꃊ\[Xij[jbNj
	 * @return {ꃊ\[Xij[jbNjB|łȂꍇ nullB
	 */
	protected String getValueByRegex(String enTrimmed) {
		return RegexDictionary.getInstance().lookup(enTrimmed);
	}

	/**
	 * j[jbNpp{pɕҏW܂B<br>
	 * j&x  (&X)
	 * <p>
	 * @param en				pꃊ\[X  ij[jbNLj
	 * @param enNoMnemonic		pꃊ\[X  ij[jbNj
	 * @param jaNoMnemonic		{ꃊ\[Xij[jbNj
	 * @return					{ꃊ\[Xij[jbNLj
	 */
	protected String editMnemonicEnToJa(String en,
			String enNoMnemonic, String jaNoMnemonic) {

		if (en.equals(enNoMnemonic)) {
			return jaNoMnemonic;
		}
		String mnemonicChar = en.replaceFirst(
				"(?s)^.*?\\&(" + UnMnemonicProperties.MNEMONIC_CHARS + ").*$",
				"$1");

		if (mnemonicChar.length() != 1) {
			log.error("Mnemonic invalid length: " + mnemonicChar.length());
			log.error(" enValue:            " + en);
			log.error(" enValueNonMnemonic: " + enNoMnemonic);
			log.error(" mnemonicChar:       " + mnemonicChar);
			return en;
		}
		String mnemonicJa = "(&" + mnemonicChar.toUpperCase() + ")";

		// j
		// hoge @Ctrl+X		-> hoge(&H) @Ctrl+X
		// '@Override'		-> '@Override'(&O)

		// modified 2008.03.29 &Left ->  ̂悤ɖꂪ 1 ̏ꍇɑΉ
		//String ja = jaNoMnemonic.replaceFirst("(?s)^(.{2,}?)(" +
		String ja = jaNoMnemonic.replaceFirst("(?s)^(.+?)(" +
				"@\\p{ASCII}+|" +			// j @Ctrl+Shift+X
				"\\s*|" +					// j 
				":\\s*|" +					// j :
				":\\s+\\{[0-9]\\}\\s*|" +	// j :{}
				"\\.{3,4}(</a>|)\\s*|" +	// j ... ܂ ....
				"(:|)\\s+\\(.+\\)\\s*" +	// j :()
				")$", "$1" + mnemonicJa + "$2");

		return ja;
	}
}
