/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.util;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;

/**
 * L[AlɊ܂܂j[jbNi[ɏ Properties łB
 * <p>
 * @author cypher256
 */
public class UnMnemonicProperties extends Properties {

	/** VAEo[W ID */
	private static final long serialVersionUID = -4066795589235888438L;

	/** j[jbN̐K\ubN */
	public static final String MNEMONIC_CHARS = "[\\w\\.@]";

	/**
	 * j[jbNvpeB[\z܂B
	 */
	public UnMnemonicProperties() {
	}

	/**
	 * pXw肵ăj[jbNvpeB[\z܂B<br>
	 * pXfBNg[̏ꍇ́A̒ɂvpeB[Et@C
	 * ׂă[h܂B
	 * <p>
	 * @param path pX
	 */
	public UnMnemonicProperties(String path) {
		this(FileSystem.getResourceFile(path));
	}

	/**
	 * [gpXw肵ăj[jbNvpeB[\z܂B<br>
	 * pXfBNg[̏ꍇ́A̒ɂvpeB[Et@C
	 * ׂă[h܂B
	 * <p>
	 * @param root [gpX
	 */
	public UnMnemonicProperties(File root) {

		// fBNg[̏ꍇ
		if (root.isDirectory()) {

			File[] files = root.listFiles();
			Arrays.sort(files); // 

			for (File file : files) {
				if (file.isFile() && file.getName().endsWith(".properties")) {
					Properties prop = FileSystem.loadProperties(file);
					putAll(prop);
				}
			}
		}
		// t@C̏ꍇ
		else {
			Properties prop = FileSystem.loadProperties(root);
			putAll(prop);
		}
	}
	
	/**
	 * w肵L[ƒlj[jbNA
	 * vpeB[ɃZbg܂B
	 */
	@Override
	public synchronized Object put(Object key, Object value) {
		return super.put(
				removeMnemonic(key),
				removeMnemonic(value));
	}

	/**
	 * w肵lɊ܂܂ &a  (&A) ̂悤ȃj[jbN܂B
	 * <p>
	 * @param value l
	 * @return j[jbN̒l
	 */
	private String removeMnemonic(Object value) {

		String strValue = value.toString();

		// {j[jbN̏
		strValue = strValue.replaceFirst("\\(\\&" + MNEMONIC_CHARS + "\\)", "");

		// {j[jbÑoO (&)
		strValue = strValue.replaceFirst("\\(\\&\\)", "");

		// pj[jbN̏ (& ̂ݏ͎̂c)
		strValue = removeEnMnemonic(strValue);

		return strValue;
	}

	//////////////////////////////////////////////////////////////////////////
	// ȉApublic static [eBeB[E\bh

	/**
	 * pꃊ\[X񂩂j[jbN䕶 & ܂B
	 * <p>
	 * @param enValue pꃊ\[X
	 * @return j[jbN䕶̕
	 */
	public static String removeEnMnemonic(String enValue) {

		if (hasEnMnemonic(enValue)) {
			return enValue.replaceFirst(
					"\\&(" + MNEMONIC_CHARS + ")", "$1");
		}
		return enValue;
	}

	/**
	 * (&A) ̂悤ȓ{p̃j[jbNɊ܂܂Ă邩肵܂B
	 * <p>
	 * @param value \[X
	 * @return ܂܂Ăꍇ true
	 */
	public static boolean hasJaMnemonic(String value) {
		return value.matches(
				"(?s)^.*?\\(\\&" + MNEMONIC_CHARS + "\\).*$");
	}

	/**
	 * pj[jbN܂܂Ă邩肵܂B
	 * &lt; Ȃǂ̓j[jbNł͂Ȃ̂ false Ԃ܂B
	 * <p>
	 * @param value l
	 * @return ܂܂Ăꍇ true
	 */
	public static boolean hasEnMnemonic(String value) {

		// Ȃꍇ͏OvpeB[
		return
			value.contains("&") &&
			!value.contains("&lt;") &&
			!value.contains("&gt;") &&
			!value.contains("&amp;") &&
			!value.contains("&quot;") &&
			!value.contains("K&R "); // CDT R[hEX^CEvt@C
	}

	/**
	 * vpeB[̃L[iӁj\ɕϊ܂B
	 * <p>
	 * @param key 
	 * @return vpeB[̃L[\
	 */
	public static String toPropertyKey(String key) {
		return key
			.replaceAll("[ :=#!\t\\\\]", "\\\\$0")
			.replaceAll("\r", "\\\\r")
			.replaceAll("\n", "\\\\n");
	}

	/**
	 * vpeB[̒liEӁj\ɕϊ܂B
	 * <p>
	 * @param value 
	 * @return vpeB[̒l\
	 */
	public static String toPropertyValue(String value) {
		return value
			.replaceAll("#", "\\\\$0")
			.replaceAll("\r", "\\\\r")
			.replaceAll("\n", "\\\\n");
	}
}
