/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TVHITTESTINFO;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class TreeDragUnderEffect
extends DragUnderEffect {
    private Tree tree;
    private int dropIndex;
    private int scrollIndex;
    private long scrollBeginTime;
    private int expandIndex;
    private long expandBeginTime;
    private boolean clearInsert = false;
    private static final int SCROLL_HYSTERESIS = 150;
    private static final int EXPAND_HYSTERESIS = 300;

    TreeDragUnderEffect(Tree tree) {
        this.tree = tree;
    }

    private int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    void show(int effect, int x, int y) {
        effect = this.checkEffect(effect);
        int handle = this.tree.handle;
        Point coordinates = new Point(x, y);
        coordinates = this.tree.toControl(coordinates);
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = coordinates.x;
        lpht.y = coordinates.y;
        OS.SendMessage(handle, 4369, 0, lpht);
        int hItem = lpht.hItem;
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (hItem != -1 && this.scrollIndex == hItem && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int topItem = OS.SendMessage(handle, 4362, 5, 0);
                int nextItem = OS.SendMessage(handle, 4362, hItem == topItem ? 7 : 6, hItem);
                OS.SendMessage(handle, 4372, 0, nextItem);
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = hItem;
        }
        if ((effect & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandIndex = -1;
        } else if (hItem != -1 && this.expandIndex == hItem && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                OS.SendMessage(handle, 4354, 2, hItem);
                this.expandBeginTime = 0L;
                this.expandIndex = -1;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 300L;
            this.expandIndex = hItem;
        }
        if (this.dropIndex != -1 && (this.dropIndex != hItem || (effect & 1) == 0)) {
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = this.dropIndex;
            tvItem.mask = 8;
            tvItem.stateMask = 8;
            tvItem.state = 0;
            OS.SendMessage(handle, OS.TVM_SETITEM, 0, tvItem);
            this.dropIndex = -1;
        }
        if (hItem != -1 && hItem != this.dropIndex && (effect & 1) != 0) {
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = hItem;
            tvItem.mask = 8;
            tvItem.stateMask = 8;
            tvItem.state = 8;
            OS.SendMessage(handle, OS.TVM_SETITEM, 0, tvItem);
            this.dropIndex = hItem;
        }
        if ((effect & 2) != 0 || (effect & 4) != 0) {
            boolean before = (effect & 2) != 0;
            TreeItem insertItem = (TreeItem)this.tree.getDisplay().findWidget(this.tree.handle, hItem);
            if (insertItem != null) {
                this.tree.setInsertMark(insertItem, before);
                this.clearInsert = true;
            }
        } else {
            if (this.clearInsert) {
                this.tree.setInsertMark(null, false);
            }
            this.clearInsert = false;
        }
    }
}

