/*
 * Copyright(c) 2005- C/pHeR.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at epl-v10.html.
 */
package jp.sorceforge.mergedoc.jstyle;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextLayout.JStyleSWTBridge;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class JStylePlugin extends AbstractUIPlugin implements IStartup {

	/** The shared instance. */
	private static JStylePlugin plugin;
	
	/**
	 * The constructor.
	 */
	public JStylePlugin() {
		super();
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 * @return the shared instance.
	 */
	public static JStylePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("JStyle", path);
	}

	/*
	 * @see IStartup#earlyStartup()
	 */
	public void earlyStartup() {
		applySWT();
	}

	/**
	 * Apply JStyle preference for SWT.
	 */
	public void applySWT() {
		
		JStyleSWTBridge.lineBreakRGB =
			getRGBPreference(JStyleConstants.P_LINE_BREAK);
		JStyleSWTBridge.tabRGB =
			getRGBPreference(JStyleConstants.P_TAB);
		JStyleSWTBridge.fullWidthSpaceRGB =
			getRGBPreference(JStyleConstants.P_FULL_WIDTH_SPACE);
		JStyleSWTBridge.halfWidthSpaceRGB =
			getRGBPreference(JStyleConstants.P_HALF_WIDTH_SPACE);
		JStyleSWTBridge.forceMonospace =
			getBooleanPreference(JStyleConstants.P_FORCE_MONOSPACE);

		StyledText.redrawJStyle();
	}
	
	/**
	 * Returns an RGB preference.
	 * 
	 * @param key Preference key
	 * @return RGB preference
	 */
	private RGB getRGBPreference(String key) {
		
		try {
			IPreferenceStore store = JStylePlugin.getDefault().getPreferenceStore();
			if (store.getBoolean(key + JStyleConstants.SUFFIX_SHOW)) {
				String value = store.getString(key + JStyleConstants.SUFFIX_COLOR);
				if (value != null) {
					return StringConverter.asRGB(value);
				}
			}
			
		} catch (Exception e) {
			setProblemMessage(e.getMessage());
			return StringConverter.asRGB(JStyleConstants.DEFAULT_RGB_STRING);
		}
		return null;
	}
	
	/**
	 * Returns a boolean preference.
	 * 
	 * @param key Preference key
	 * @return boolean preference
	 */
	private boolean getBooleanPreference(String key) {
		IPreferenceStore store = JStylePlugin.getDefault().getPreferenceStore();
		return store.getBoolean(key);
	}
	
	/**
	 * Sets the problem message.
	 * 
	 * @param message a message
	 */
	public void setProblemMessage(final String message) {
		
	    try {
	        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable() {

	            public void run(IProgressMonitor monitor) throws CoreException {
	        		IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
	    			IMarker marker = workspaceRoot.createMarker(IMarker.TASK);
	    			marker.setAttribute(IMarker.MESSAGE, "JStyle: " + message);
	                marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_ERROR);
	    			marker.setAttribute(IMarker.TRANSIENT, false);
	            }
	        }, null);

	    } catch (CoreException e) {
			getLog().log(e.getStatus());
	    }
	}
}
