/*
 * Copyright(c) 2005- C/pHeR.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.jstyle;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */
public class JStylePreferencePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {

    /**
     * Creates a new JStylePreferencePage.
     */
	public JStylePreferencePage() {
		super(GRID);
		setPreferenceStore(JStylePlugin.getDefault().getPreferenceStore());
		setDescription(
				"\鐧䕶̐ݒs܂B" +
				"̐ݒ̓GfB^[AR\[ȂǁA" +
				"ׂẴeLXgEr[ɉe܂B");
	}
	
	/**
	 * Creates the field editors. Field editors are abstractions of
	 * the common GUI blocks needed to manipulate various types
	 * of preferences. Each field editor knows how to save and
	 * restore itself.
	 */
	public void createFieldEditors() {
		
		addField(new SpacerFieldEditor(	getFieldEditorParent()));
		addField(new SpacerFieldEditor(	getFieldEditorParent()));
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_LINE_BREAK,
				"s(&L)",
				getFieldEditorParent()));
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_TAB,
				"^u(&T)",
				getFieldEditorParent()));
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_FULL_WIDTH_SPACE,
				"SpXy[X(&F)",
				getFieldEditorParent()));
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_HALF_WIDTH_SPACE,
				"pXy[X(&H)",
				getFieldEditorParent()));
		
		addField(new SpacerFieldEditor(	getFieldEditorParent()));
		addField(new SpacerFieldEditor(	getFieldEditorParent()));
		
		addField(new BooleanFieldEditor(
				JStyleConstants.P_FORCE_MONOSPACE,
				"𓙕ɂ(&M)",
				getFieldEditorParent()));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
        // do nothing
	}

    public boolean performOk() {
    	boolean ret = super.performOk();
    	JStylePlugin.getDefault().applySWT();
        return ret;
    }
}
