/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.OS;

public class ImageTransfer
extends ByteArrayTransfer {
    private static ImageTransfer _instance = new ImageTransfer();
    private static final String CF_DIB = "CF_DIB";
    private static final int CF_DIBID = 8;

    private ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        ImageData imgData;
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((imgData = (ImageData)object) == null) {
            SWT.error(4);
        }
        int imageSize = imgData.data.length;
        int imageHeight = imgData.height;
        int bytesPerLine = imgData.bytesPerLine;
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biSizeImage = imageSize;
        bmiHeader.biWidth = imgData.width;
        bmiHeader.biHeight = imageHeight;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)imgData.depth;
        bmiHeader.biCompression = 0;
        int colorSize = 0;
        if (bmiHeader.biBitCount <= 8) {
            colorSize += (1 << bmiHeader.biBitCount) * 4;
        }
        byte[] bmi = new byte[BITMAPINFOHEADER.sizeof + colorSize];
        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
        RGB[] rgbs = imgData.palette.getRGBs();
        if (rgbs != null && colorSize > 0) {
            int offset = BITMAPINFOHEADER.sizeof;
            for (int j = 0; j < rgbs.length; ++j) {
                bmi[offset] = (byte)rgbs[j].blue;
                bmi[offset + 1] = (byte)rgbs[j].green;
                bmi[offset + 2] = (byte)rgbs[j].red;
                bmi[offset + 3] = 0;
                offset += 4;
            }
        }
        long newPtr = OS.GlobalAlloc(64, BITMAPINFOHEADER.sizeof + colorSize + imageSize);
        OS.MoveMemory(newPtr, bmi, bmi.length);
        long pBitDest = newPtr + (long)BITMAPINFOHEADER.sizeof + (long)colorSize;
        if (imageHeight <= 0) {
            OS.MoveMemory(pBitDest, imgData.data, imageSize);
        } else {
            int offset = 0;
            pBitDest += (long)(bytesPerLine * (imageHeight - 1));
            byte[] scanline = new byte[bytesPerLine];
            for (int i = 0; i < imageHeight; ++i) {
                System.arraycopy(imgData.data, offset, scanline, 0, bytesPerLine);
                OS.MoveMemory(pBitDest, scanline, bytesPerLine);
                offset += bytesPerLine;
                pBitDest -= (long)bytesPerLine;
            }
        }
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = newPtr;
        transferData.stgmedium.pUnkForRelease = 0L;
        transferData.result = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        ImageData imageData;
        long hMem;
        block16: {
            Object var9_7;
            block15: {
                if (!this.isSupportedType(transferData)) return null;
                if (transferData.pIDataObject == 0L) {
                    return null;
                }
                IDataObject dataObject = new IDataObject(transferData.pIDataObject);
                dataObject.AddRef();
                FORMATETC formatetc = new FORMATETC();
                formatetc.cfFormat = 8;
                formatetc.ptd = 0L;
                formatetc.dwAspect = 1;
                formatetc.lindex = -1;
                formatetc.tymed = 1;
                STGMEDIUM stgmedium = new STGMEDIUM();
                stgmedium.tymed = 1;
                transferData.result = this.getData(dataObject, formatetc, stgmedium);
                if (transferData.result != 0) {
                    return null;
                }
                hMem = stgmedium.unionField;
                dataObject.Release();
                try {
                    long ptr = OS.GlobalLock(hMem);
                    if (ptr == 0L) {
                        var9_7 = null;
                        Object var26_9 = null;
                        break block15;
                    }
                    try {
                        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
                        OS.MoveMemory(bmiHeader, ptr, BITMAPINFOHEADER.sizeof);
                        long[] pBits = new long[1];
                        long memDib = OS.CreateDIBSection(0L, ptr, 0, pBits, 0L, 0);
                        if (memDib == 0L) {
                            SWT.error(2);
                        }
                        long bits = ptr + (long)bmiHeader.biSize;
                        if (bmiHeader.biBitCount <= 8) {
                            bits += (long)((bmiHeader.biClrUsed == 0 ? 1 << bmiHeader.biBitCount : bmiHeader.biClrUsed) * 4);
                        } else if (bmiHeader.biCompression == 3) {
                            bits += 12L;
                        }
                        if (bmiHeader.biHeight < 0) {
                            OS.MoveMemory(pBits[0], bits, bmiHeader.biSizeImage);
                        } else {
                            DIBSECTION dib = new DIBSECTION();
                            OS.GetObject(memDib, DIBSECTION.sizeof, dib);
                            int biHeight = dib.biHeight;
                            int scanline = dib.biSizeImage / biHeight;
                            long pDestBits = pBits[0];
                            long pSourceBits = bits + (long)(scanline * (biHeight - 1));
                            for (int i = 0; i < biHeight; pDestBits += (long)scanline, pSourceBits -= (long)scanline, ++i) {
                                OS.MoveMemory(pDestBits, pSourceBits, scanline);
                            }
                        }
                        Image image = Image.win32_new(null, 0, memDib);
                        ImageData data = image.getImageData();
                        OS.DeleteObject(memDib);
                        image.dispose();
                        imageData = data;
                        Object var24_23 = null;
                    }
                    catch (Throwable throwable) {
                        Object var24_24 = null;
                        OS.GlobalUnlock(hMem);
                        throw throwable;
                    }
                    OS.GlobalUnlock(hMem);
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var26_11 = null;
                    OS.GlobalFree(hMem);
                    throw throwable;
                }
            }
            OS.GlobalFree(hMem);
            return var9_7;
        }
        Object var26_10 = null;
        OS.GlobalFree(hMem);
        return imageData;
    }

    protected int[] getTypeIds() {
        return new int[]{8};
    }

    protected String[] getTypeNames() {
        return new String[]{CF_DIB};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

