/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code, released March 31, 1998.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by Netscape are Copyright (C) 1998-1999
 * Netscape Communications Corporation.  All Rights Reserved.
 *
 * Contributor(s):
 *
 * IBM
 * -  Binding to permit interfacing between Mozilla and SWT
 * -  Copyright (C) 2012, 2013 IBM Corp.  All Rights Reserved.
 *
 * ***** END LICENSE BLOCK ***** */
package org.eclipse.swt.internal.mozilla;

public class nsIXPConnect extends nsISupports {

	static final int LAST_METHOD_ID = nsISupports.LAST_METHOD_ID + (IsXULRunner17 ? 48 : 27);

	public static final String NS_IXPCONNECT_IID_STR =
		"a995b541-d514-43f1-ac0e-f49746c0b063";

	public static final nsID NS_IXPCONNECT_IID =
		new nsID(NS_IXPCONNECT_IID_STR);
	
	public static final String NS_IXPCONNECT_17_IID_STR =
		"bd300b18-1c34-4589-8285-23a12cc580ea";

	public static final nsID NS_IXPCONNECT_17_IID =
		new nsID(NS_IXPCONNECT_17_IID_STR);

	public nsIXPConnect(long /*int*/ address) {
		super(address);
	}

	public int JSValToVariant(long /*int*/ cx, long /*int*/ aJSVal, long /*int*/[] _retval) {
		return XPCOM.VtblCall(nsISupports.LAST_METHOD_ID + 6, getAddress(), cx, aJSVal, _retval);
	}

	public int VariantToJS(long /*int*/ ctx, long /*int*/ scope, long /*int*/ value, long /*int*/ _retval) {
		return XPCOM.VtblCall(nsISupports.LAST_METHOD_ID + (IsXULRunner17 ? 31 : 33), getAddress(), ctx, scope, value, _retval);
	}
}
