/*
 * Copyright(c) 2005- C/pHeR.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.jstyle;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */
public class JStylePreferencePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {

    /**
     * Body of page.
     */
    private Control body;

    /**
     * Description label.
     *
     * @see #createDescriptionLabel(Composite)
     */
    private Link descriptionLabel;

    /**
     * Creates a new JStylePreferencePage.
     */
	public JStylePreferencePage() {
		super(GRID);
		setPreferenceStore(JStylePlugin.getDefault().getPreferenceStore());
	}
	
	@Override
	protected Label createDescriptionLabel(Composite parent) {

		final Link link= new Link(parent, SWT.WRAP);
		final String target= "org.eclipse.ui.preferencePages.GeneralTextEditor";
		link.setText("表示する制御文字の設定を行います。Eclipse 3.7 以降は標準で <a>'テキスト・エディター'</a> の「空白文字を表示」で設定可能ですが、Eclipse 特有の特殊記号表記を避けて JStyle を利用するユーザーが多いためサポートを継続しています。Eclipse 標準の空白表示機能を利用する場合は、下記のチェックを OFF にしてください。なお、太字を通常文字と同じ幅で表示する機能は標準には無い JStyle 固有の機能です。");
		link.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				PreferencesUtil.createPreferenceDialogOn(link.getShell(), target, null, null);
			}
		});
        link.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        descriptionLabel = link;
		return null;
	}
	
	@Override
	protected Control createContents(Composite parent) {
		return body = super.createContents(parent);
	}

    /**
     * Computes the size needed by this page's UI control.
     * <p>
     * All pages should override this method and set the appropriate sizes
     * of their widgets, and then call <code>super.doComputeSize</code>.
     * </p>
     *
     * @return the size of the preference page encoded as
     *   <code>new Point(width,height)</code>
     */
    protected Point doComputeSize() {
        if (descriptionLabel != null && body != null) {
            Point bodySize = body.computeSize(SWT.DEFAULT, SWT.DEFAULT, true);
            GridData gd = (GridData) descriptionLabel.getLayoutData();
            gd.widthHint = bodySize.x;
        }
        return getControl().computeSize(SWT.DEFAULT, SWT.DEFAULT, true);
    }
	
	/**
	 * Creates the field editors. Field editors are abstractions of
	 * the common GUI blocks needed to manipulate various types
	 * of preferences. Each field editor knows how to save and
	 * restore itself.
	 */
	public void createFieldEditors() {
		
		createSpacer();
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_LINE_BREAK,
				"改行(&L)",
				getFieldEditorParent()));
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_TAB,
				"タブ(&T)",
				getFieldEditorParent(),
				JStyleConstants.comboNamesAndValues));
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_FULL_WIDTH_SPACE,
				"全角スペース(&F)",
				getFieldEditorParent()));
		
		addField(new BooleanColorFieldEditor(
				JStyleConstants.P_HALF_WIDTH_SPACE,
				"半角スペース(&H)",
				getFieldEditorParent()));
		
		createSpacer();
		
		addField(new BooleanFieldEditor(
				JStyleConstants.P_FORCE_MONOSPACE,
				"太字を通常文字と同じ幅で表示する(&M)",
				getFieldEditorParent()));
	}

	/**
	 * Creates a spacer.
	 */
	private void createSpacer() {
		for (int i = 0; i < BooleanColorFieldEditor.NUM_COLUMNS; i++) {
			addField(new SpacerFieldEditor(getFieldEditorParent()));
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
        // do nothing
	}

	/*
	 * (非 Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#performOk()
	 */
    public boolean performOk() {
    	boolean ret = super.performOk();
    	JStylePlugin.getDefault().applySWT();
        return ret;
    }
}
