/*
 * messasy
 *
 * Copyright (C) 2006,2007,2008 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * $RCSfile: client_side.c,v $
 * $Revision: 1.4 $
 * $Date: 2008/12/17 06:49:31 $
 */

/* External command for messasy */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <unistd.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>

#include "client_side.h"
#include "msy_config.h"
#include "log.h"

/* 
 * read_line   
 *
 * Function
 *  read line from socket
 *
 * Argument
 *   arg0 int socket
 *   arg1 char *p
 *
 * Return value
 *    len  length of line
 *
 */
int 
read_line(int socket, char *p)
{
    int len = 0;
    int flag = 0;


    while (len < BUF_LEN){

        int ret;

        /* read character from socket */
        ret = read(socket, p, 1);
        if ( ret == -1 ) {
	    log(ERR_SOCKET_READ, "read_line", strerror(errno));
            return 1;
        } else if (ret == 0) {
            break;
        }

        if (*p == '\r') {
            flag = 1;
        } else if (*p == '\n') {
            if (flag == 1) {
                p--;
                len--;
            }
            break;
        }
        p++;
        len++;
    }

    *p = '\0';

    return len;
}

/* 
 * check_command 
 * Function 
 *   check input command
 *   command sample
 *           restart
 *           exit
 *
 * Argument
 *   arg0 char *command
 *   arg1 int command_size
 *
 * Return value
 *   return_flag  0  other command
 *                1  exit command
 *                2  reload command
 *
 */
int 
check_command(char *command, int command_size)
{
    int return_flag;
    return_flag = 0;

    if (strncmp(command, TEXT_EXIT, LEN_EXIT) == 0) {
        /* case exit */
        return_flag = TYPE_EXIT;
    } else if (strncmp(command, TEXT_RELOAD, LEN_RELOAD) == 0) {
        /* case reload */
        return_flag = TYPE_RELOAD;
    } else {
        /* case other */
        return_flag = TYPE_OTHER;
    }

    return return_flag;

}

/* 
 *   accept command
 *   c
 *   command sample
 *           restart
 *           exit
 *
 *   arg0	char *cfgfile
 *   arg1 char *addr
 *   arg1 int port 
 *
 *   return value
 *   0  Success
 *   1  Fail
 */
int
accept_command(char *cfgfile, char *addr, int port)
{
    int connected_socket, listen_socket;
    struct sockaddr_in peer_sin;
    socklen_t len;
    int ret;
    int ret_command;
    int ret_reload;
//    int newport;
    int flag_reload;
    int read_size;
    char buf[BUF_LEN];

   listen_socket = create_connection(addr, port);
   if (listen_socket == -1) {
        return 1;
   }

    while (1) {
        flag_reload = 0;

        len = sizeof(peer_sin);

        /* accept connection for messasy */
        connected_socket = accept(listen_socket, (struct sockaddr *)&peer_sin,
                                  &len);
        if (connected_socket == -1) {
	    log(ERR_SOCKET_ACCEPT, "accept_command", strerror(errno));
            ret = close(connected_socket);
            if (ret == -1) {
		log(ERR_SOCKET_CLOSE, "accept_command", strerror(errno));
            }
            return 1;
        }

        /* output welcome comment*/
        write(connected_socket, OUTPUT_WELCOME, LEN_OUTPUT_WELCOME);

        while (1){

            /* read line */
            read_size = read_line(connected_socket, buf);
            if (read_size == 0) {
                break;
            }

            ret_command = check_command(buf, read_size);
            if (ret_command == TYPE_OTHER) {

                /* input other command */
                write(connected_socket, OUTPUT_NG, LEN_OUTPUT_NG);
                write(connected_socket, OUTPUT_ERROR, LEN_OUTPUT_ERROR);
            } else if (ret_command == TYPE_EXIT) {

                /* close socket */
                write(connected_socket, OUTPUT_CLOSE, LEN_OUTPUT_CLOSE);
		break;
            } else if(ret_command == TYPE_RELOAD) {

                /* reload config file */
                ret_reload = reload_config(cfgfile);
                if (ret_reload == 0) {
                    /* case reload successfull */
                    write(connected_socket, OUTPUT_OK, LEN_OUTPUT_OK);
                    write(connected_socket, OUTPUT_RELOAD, LEN_OUTPUT_RELOAD);
                    flag_reload = 1;

                } else if(ret_reload == 1) {

                    /* case reload fail for during reload */
                    write(connected_socket, OUTPUT_NG, LEN_OUTPUT_NG);
                    write(connected_socket, OUTPUT_RELOAD_TMP_FAIL, 
                          LEN_OUTPUT_RELOAD_TMP_FAIL);
                } else if(ret_reload == 2) {

                    /* case reload fail for config file */
                    write(connected_socket, OUTPUT_NG, LEN_OUTPUT_NG);
                    write(connected_socket, OUTPUT_RELOAD_CFG_FAIL, 
                          LEN_OUTPUT_RELOAD_CFG_FAIL);
                } else {

                    /* case reload fail */
                    write(connected_socket, OUTPUT_NG, LEN_OUTPUT_NG);
                    write(connected_socket, OUTPUT_RELOAD_FAIL, 
                          LEN_OUTPUT_RELOAD_FAIL);
                }
            }
        }

        ret = close(connected_socket);
        if (ret == -1) {
	    log(ERR_SOCKET_CLOSE, "accept_command", strerror(errno));
            return 1;
        }

        /* case reload that set new port */
//        if (flag_reload == 1) {
            /* case set diffrent port */
//            newport = get_port_num();
//            if (newport != port) {
//                port = newport;
//                ret = close(listen_socket);
//                if (ret == -1) {
//		    log(ERR_SOCKET_CLOSE, "accept_command", strerror(errno));
//                    return 1;
//                }
                /* call accept function */
//                ret = create_connection(port);
//                if (ret == -1) {
//                     return 1;
//                }
//            }
//        }
    }

    return 0;
}

/* 
 * get_port_num
 * 
 * Function
 *    get new port number
 *
 * Argument
 *
 * Return value
 *   portnum port number
 */
int
get_port_num()
{
    struct config *cfg;
    int portnum;

    /* read config file */
    cfg = config_init();

    portnum = cfg->cf_commandport;

    config_release(cfg);

    return portnum;

} 

/* 
 * create_connection
 *   
 * Function   
 *   create socket 
 *
 * Argument
 *   arg0 char *addr	bind address
 *   arg0 int port	port number
 *
 * Return value
 *   listen_socket  Success
 *   -1             Fail
 */
int 
create_connection(char *addr, int port)
{
    int listen_socket;
    struct sockaddr_in sin;
    int sock_optval = 1;
    int ret;

    /* create socket of listen */
    listen_socket = socket(AF_INET, SOCK_STREAM, 0);
    if (listen_socket == -1) {
	log(ERR_SOCKET_CREATE, "create_connection", strerror(errno));
        return 1;
    }

    /* set option of socket */
    if (setsockopt(listen_socket, SOL_SOCKET, SO_REUSEADDR,
                    &sock_optval, sizeof(sock_optval)) == -1) {
	log(ERR_SOCKET_SET_OPTION, "create_connection", strerror(errno));
        return 1;
    }

    /* set address familly and port number and ipaddress */
    sin.sin_family = AF_INET;
    sin.sin_port = htons(port);
    sin.sin_addr.s_addr = inet_addr(addr);

    /* assign address to socket */
    if (bind(listen_socket, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
	log(ERR_SOCKET_BIND, "create_connection", strerror(errno));
        return -1;
    }

    /* check port of listen */
    ret = listen(listen_socket, SOMAXCONN);
    if ( ret == -1 ) {
	log(ERR_SOCKET_LISTEN, "create_connection", strerror(errno));
        return -1;
    }

    return listen_socket;
}
