/*
 * messasy
 *
 * Copyright (C) 2006,2007,2008 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * $RCSfile: msy_config.h,v $
 * $Revision: 1.16 $
 * $Date: 2009/01/23 07:05:10 $
 */

#ifndef _MSY_CONFIG_H_
#define _MSY_CONFIG_H_

#define CFG_NG -1

#define CF_INTEGER	1
#define CF_PLUS		2
#define CF_STRING	3
#define CF_MULTI	4
#define MAX_CONFIG_LINE 1024

struct cfentry {
     char           *cf_name;
     unsigned int    cf_type;
     char           *cf_default;        /* NULL if needed */
     int             cf_dataoffset;
     int          (*cf_check)();
     int             cf_reload;
};

#define OFFSET(x, y)  ((int)&(((x *)NULL)->y))

struct filter {
    char *fl_string;
};

struct config {
    char *cf_maildir;
    char *cf_mailfolder;
    struct filter *cf_savemailaddress;
    int   cf_commandport; 
    char *cf_syslogfacility;
    char *cf_listenip;
    int   cf_listenport;
    struct filter *cf_mydomain;
    char *cf_dotdelimiter;
    char *cf_slashdelimiter;
};

#ifdef _MSY_CONFIG_C_

#define DOT_DELIMITER "DotDelimiter"
#define SLASH_DELIMITER "SlashDelimiter"
#define CHAR_MAILFOLDER "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.,%_&-+ "
#define CHAR_DOT_DELIMITER "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789, -"
#define CHAR_SLASH_DELIMITER "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789, -"

#define DOT_ADDRESS 3
#define RELOAD 1
#define NORELOAD 0
#define SPACE ' '

static int is_writable_directory(char *str);
static int is_readable(char *str);
static int is_port(int value);
static int is_ip(char *str);
static int is_mailfolder(char *str);
static int is_dotdelimiter(char *str);
static int is_slashdelimiter(char *str);
static int is_syslogfacility(char *str);
static int is_savemailaddress(char *str);

struct cfentry cfe[] = {
    {
	"MailDir", CF_STRING, NULL,
	OFFSET(struct config, cf_maildir), is_writable_directory, RELOAD,
    },
    {
	"MailFolder", CF_STRING, NULL,
	OFFSET(struct config, cf_mailfolder), is_mailfolder, RELOAD,
    },
    {
	"SaveMailAddress", CF_MULTI, NULL,
	OFFSET(struct config, cf_savemailaddress), is_savemailaddress, RELOAD,
    },
    {
	"CommandPort", CF_PLUS, "17777",
	OFFSET(struct config, cf_commandport), is_port, NORELOAD,
    },
    {
	"SyslogFacility", CF_STRING, "local1",
	OFFSET(struct config, cf_syslogfacility), is_syslogfacility, RELOAD,
    },
    {
	"ListenIP", CF_STRING, "127.0.0.1",
	OFFSET(struct config, cf_listenip), is_ip, NORELOAD,
    },
    {
	"ListenPort", CF_PLUS, "20026",
	OFFSET(struct config, cf_listenport), is_port, NORELOAD,
    },
    {
	"MyDomain", CF_MULTI, NULL,
	OFFSET(struct config, cf_mydomain), NULL, RELOAD,
    },
    {
	"DotDelimiter", CF_STRING, " ",
	OFFSET(struct config, cf_dotdelimiter), is_dotdelimiter, RELOAD,
    },
    {
	"SlashDelimiter", CF_STRING, "-",
	OFFSET(struct config, cf_slashdelimiter), is_slashdelimiter, RELOAD,
    },
};

#define NCONFIG (sizeof(cfe) / sizeof(struct cfentry))
#endif	/* _MSY_CONFIG_C_ */


/*
 * reload_config()
 *
 * Reload configuration file
 *
 * Args:
 *  char *file          Configuration file name
 *
 * Return value:
 *  0                   Success
 *  CFG_NG              System error
 *  1                   Temporaly error (during reloading)
 *  2                   Temporaly error (because of config file)
 */
int reload_config(char *file);

/*
 * config_release()
 *
 * Countdown config reference counter.
 *
 * Args:
 *  struct config *cfg          To release pointer.
 *
 * Return value:
 *  (void)
 */
void config_release(struct config *cfg);

/*
 * config_init()
 *
 * Get current config structure pointer,
 * and countup the reference counter.
 *
 * Args: (void)
 *
 * Return value:
 *  struct config *             config structure pointer
 */
struct config * config_init();

/*
 * dup_filter
 *
 * args:
 *  struct filter *	filter
 * return value:
 *  struct filter *	structure pointer
 *  NULL		error
 */
struct filter *dup_filter(struct filter *);

/*
 * config_get()
 *
 * Get config element.
 */
#define config_get(val) (val)

void free_filter(struct filter *fl);

#endif	/* _MSY_CONFIG_H_ */
