#ifndef MFILER2_COMMON
#define MFILER2_COMMON

extern "C" {
#include "ruby.h"
#include "mlib/mlib.h"
#include "mlib/mdebug.h"
#include "mlib/mlist.h"
#include "mlib/mvector.h"
#include "mlib/mstring.h"
#include "mlib/mhash.h"
#include "mlib/mcurses.h"
#include <termios.h>
}

using namespace std;

/// menu.cpp ///
#include "menu.h"

extern cMenu* gActiveMenu;
extern hash_obj* gMenu;

/// dirwnd.cpp ///
#include "dirwnd.h"

/// main.cpp ///
extern char** environ;

extern cDirWnd* gLDir;
extern cDirWnd* gRDir;
extern bool gMainLoop;
extern hash_obj* gKeyCommand[2][KEY_MAX];
extern bool gGnuScreen;
extern bool gXterm;
extern bool gXtermNext;
extern bool gPty;
extern bool gISearchEnterDecision;
extern bool gISearchMismatchFinish;
extern bool gAutoRehash;

void cut(char* src, char* dest, int len);

extern bool gErrMsgCancel;
int err_msg(char* msg, ...);
void msg(char* msg);
int select_str(char* msg, char* str[], int len, int cancel);
void view();

extern bool gISearch;
extern bool gColor;
extern bool gIndividualCursor;
extern bool gCheckDeleteFile;
extern bool gCheckCopyFile;
extern bool gCheckExit;
extern bool gProcessLine;
extern bool gShiftISearch;
extern char gTrashBoxName[256];
extern bool gRemainCursor;
extern bool gSelect;

extern bool gBoldExe;
extern bool gBoldDir;
extern int gColorMark;
extern int gColorDir;
extern int gColorExe;
extern int gColorLink;

/// command.cpp ///
void command_init();
void command_final();

/// cmdline.cpp ///
//const int kOutputSize = 131072;
const int kOutputSize = 65536;
struct sMasterTty
{
    int mFD;
    char mName[1024];
    pid_t mPID;
    
    char mOutput[kOutputSize];
    int mOutputTail;
};

extern vector_obj* gTty;
extern bool gCmdLineActive;   // readonly
extern vector_obj* gCCandidate;;    // readonly

extern VALUE gXtermPrgName;
extern VALUE gXtermOptTitle;
extern VALUE gXtermOptEval;
extern VALUE gXtermOptExtra;

extern char gShellName[256];
extern char gShellPath[256];
extern char gShellOptEval[256];

extern bool gCompletionMenu;

void cmdline_init();
void cmdline_init_after_rc_file();
void cmdline_final();
void cmdline_start(char* cmd, int posion);
void cmdline_input(int meta, int key);
void cmdline_completion_menu_input(int meta, int key);
void cmdline_view();
void cmdline_completion_view();
void cmdline_run(char* str, char* title);
void cmdline_restore_pty(int n);
int cmdline_select_pty(char* title);
void cmdline_alias_add(char* alias, int arg_num, char* cmd);
void cmdline_rehash();
void cmdline_completion(VALUE all_candidate, char* editing, bool sqort, bool dqort);
void cmdline_completion2(VALUE all_candidate, char* editing, bool sqort, bool dqort);

/// file.cpp ///
enum eCopyOverride { kNone, kYesAll, kNoAll, kCancel };
extern eCopyOverride gCopyOverride;

bool file_copy(char* spath, char* dpath, bool move);
bool file_remove(char* path);

/// help.cpp ///
extern bool gViewHelp;

void help_start();
void help_view();
void help_input(int meta, int key);

#endif
