#ifndef MFILER2_DIRWND
#define MFILER2_DIRWND

extern "C" {
#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
}

struct sFile{
    char mName[PATH_MAX];
    struct stat mStat;
    struct stat mLStat;
    bool mMark;

    sFile(char* name, struct stat* stat_, struct stat* lstat_, bool mark)
    {
        strcpy(mName, name);
        mStat = *stat_;
        mLStat = *lstat_;
        mMark = mark;
    }
};

struct sDirInfo {
    char mPath[512];
    int mScrollTop;
    int mCursor;
};

class cDirWnd {
    char mPath[PATH_MAX];    // last char is '/'
    char mPathBefore[PATH_MAX];
    hash_obj* mMarkFiles;

    vector_obj* mFiles;
    
    int mScrollTop;
    int mCursor;

    char mMask[1024];
    
    list_obj* mDirStack;
   
    static BOOL sort_name(void* left, void* right);
    static BOOL sort_name_reverse(void* left, void* right);
    static BOOL sort_ext(void* left, void* right);
    static BOOL sort_ext_reverse(void* left, void* right);
    static BOOL sort_size(void* left, void* right);
    static BOOL sort_size_reverse(void* left, void* right);
    static BOOL sort_time(void* left, void* right);
    static BOOL sort_time_reverse(void* left, void* right);

    static const int kMaxYMinus = 4;

    void read();
    bool check_path(char* new_path);
public:
    cDirWnd(char* path, bool active);
    ~cDirWnd();

    static void Init();
    static void Final();
    
    static void* operator new(size_t size) { return MALLOC(size); }
    static void operator delete(void* p) { FREE(p); }

    static const int kDirStackSize = 500;
    static bool gRemainMarks;

    /// properties ///
    bool mActive;
   
    enum eSortKind { kName, kNameReverse, kExt, kExtReverse, kSize, kSizeReverse, kTime, kTimeReverse };
    static eSortKind gSortKind;

    enum eViewOption { kAll, kOneDir, kOneDir2, kOneDir3, kOneDir5 };
    static eViewOption gViewOption;
    static bool gViewNameOnly;

    static bool gSortDirUp;
    
    vector_obj* Files() { return mFiles; }
    sFile* CursorFile();
    char* Path() { return mPath; }
    VALUE MarkFiles();
    void MarkFilesSQuote(RESULT char* result);
    int MarkFileNum();
    int MarkFileSize();

    bool Marking();

    bool IsLeftDir();
    bool IsRightDir();

    /// methods ///
    int Cursor();
    int CursorMax();
    int CursorX();
    int CursorY();
    int CursorMaxX();
    int CursorMaxY();
    void MoveCursor(int index);
    int ScrollTop();
    void SetScrollTop(int index);
    
    void Mark();
    void MarkAll();
    void MarkAllFiles();
    void ResetMarks();
    
    void Activate(cDirWnd* current);
   
    void Move(char* path);        // last char don't have to be '/'
    void MoveBack();

    void PushFrontDir();
    void PushBackDir();
    void PopDir();
   
    void Sort();
    void View();

    void Reread();
    bool ChangeMask(char* mask);
};

extern cDirWnd* ActiveDir();
extern cDirWnd* SleepDir();

#endif
