/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.architecturemaker;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.wasamon.mics.architecturemaker.Ghost;
import net.wasamon.mics.architecturemaker.HauntedMansion;
import net.wasamon.mics.architecturemaker.unit.DataBuffer;
import net.wasamon.mics.architecturemaker.unit.HardwareUnit;
import net.wasamon.mics.architecturemaker.unit.InitAttribute;
import net.wasamon.mics.architecturemaker.unit.Mediator;
import net.wasamon.mics.architecturemaker.unit.MicsNode;

public class ArchitectureCanvas
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener {
    private Image offimage;
    private Graphics offg;
    private final int NONE_MODE = 0;
    private final int CONNECTION_MODE = 1;
    private final int SELECTION_MODE = 2;
    private final int MOVEMENT_MODE = 3;
    private Point actionFrom;
    private Point actionTo;
    private HauntedMansion mansion;
    private int currentKey;
    private int scale;
    private int pitch;
    private int actionMode;
    private Mediator mediator;
    private static ArchitectureCanvas instance = new ArchitectureCanvas();

    private ArchitectureCanvas() {
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFocusTraversalKeysEnabled(false);
        this.currentKey = 48;
        this.pitch = 25;
        this.actionMode = 0;
        this.scale = 100;
        this.mediator = Mediator.getInstance();
    }

    public static ArchitectureCanvas getInstance() {
        return instance;
    }

    private void showPopup(int n, int n2) {
        JMenuItem jMenuItem = new JMenuItem("Add Init File");
        JMenuItem jMenuItem2 = new JMenuItem("Cut");
        JMenuItem jMenuItem3 = new JMenuItem("Copy");
        JMenuItem jMenuItem4 = new JMenuItem("Paste");
        JMenuItem jMenuItem5 = new JMenuItem("Delete");
        JMenuItem jMenuItem6 = new JMenuItem("Select All");
        jMenuItem.addActionListener(this);
        jMenuItem2.addActionListener(this);
        jMenuItem3.addActionListener(this);
        jMenuItem4.addActionListener(this);
        jMenuItem5.addActionListener(this);
        jMenuItem6.addActionListener(this);
        HardwareUnit[] hardwareUnitArray = this.mediator.getSelectedUnits();
        boolean bl = false;
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            if (!(hardwareUnitArray[i] instanceof DataBuffer)) continue;
            bl = true;
            break;
        }
        jMenuItem4.setEnabled(!this.mediator.copyBufferIsEmpty());
        if (hardwareUnitArray.length == 0) {
            jMenuItem2.setEnabled(false);
            jMenuItem5.setEnabled(false);
            jMenuItem3.setEnabled(false);
        }
        if (this.mediator.getUnitsCount() == 0) {
            jMenuItem6.setEnabled(false);
        }
        JMenu jMenu = new JMenu("Disconnect from");
        JMenu jMenu2 = new JMenu("Remove Init File");
        if (hardwareUnitArray.length == 1) {
            Object object;
            int n3;
            if (!(hardwareUnitArray[0] instanceof DataBuffer)) {
                jMenuItem.setEnabled(false);
            }
            for (n3 = 0; n3 < hardwareUnitArray[0].connectedUnits().size(); ++n3) {
                object = new JMenuItem(hardwareUnitArray[0].connectedUnits().get(n3).getID());
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        HardwareUnit[] hardwareUnitArray = new HardwareUnit[]{ArchitectureCanvas.this.mediator.getSelectedUnits()[0], ArchitectureCanvas.this.mediator.getUnit(actionEvent.getActionCommand())};
                        ArchitectureCanvas.this.mediator.disconnectUnits(hardwareUnitArray);
                    }
                });
                jMenu.add((JMenuItem)object);
            }
            for (n3 = 0; n3 < hardwareUnitArray[0].childList().size(); ++n3) {
                Object object2;
                object = hardwareUnitArray[0].childList().get(n3);
                if (!(object instanceof InitAttribute)) continue;
                Iterator<Map.Entry<String, StringBuilder>> iterator = ((MicsNode)object).attributeTable().entrySet().iterator();
                String string = ((MicsNode)object).getTag() + " ";
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    string = string + (String)object2.getKey() + "=\"" + object2.getValue() + "\" ";
                }
                object2 = new JMenuItem(string);
                ((AbstractButton)object2).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ArchitectureCanvas.this.mediator.removeChild(ArchitectureCanvas.this.mediator.getSelectedUnits()[0], actionEvent.getActionCommand());
                    }
                });
                jMenu2.add((JMenuItem)object2);
            }
            if (jMenu.getMenuComponentCount() == 0) {
                jMenu.setEnabled(false);
            }
            if (jMenu2.getMenuComponentCount() == 0) {
                jMenu2.setEnabled(false);
            }
        } else {
            jMenuItem.setEnabled(false);
            jMenu.setEnabled(false);
            jMenu2.setEnabled(false);
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenu2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenu);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.add(jMenuItem5);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem6);
        jPopupMenu.show(this, n, n2);
    }

    public void adjustUnitPositions(HardwareUnit[] hardwareUnitArray) {
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            int n = (hardwareUnit.getX() + this.pitch / 2) / this.pitch * this.pitch;
            int n2 = (hardwareUnit.getY() + this.pitch / 2) / this.pitch * this.pitch;
            this.mediator.setValue(hardwareUnit.appearance(), "x", Integer.toString(n));
            this.mediator.setValue(hardwareUnit.appearance(), "y", Integer.toString(n2));
        }
    }

    public void setScale(int n) {
        if (n > 0) {
            this.scale = n;
        }
    }

    public int getScale() {
        return this.scale;
    }

    public Point getLogicalMousePosition(Point point) {
        return new Point((int)((double)point.x * 100.0 / (double)this.scale), (int)((double)point.y * 100.0 / (double)this.scale));
    }

    public HardwareUnit onUnit(Point point) {
        Point point2 = this.getLogicalMousePosition(point);
        HardwareUnit[] hardwareUnitArray = this.mediator.getAllUnits();
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            if (!hardwareUnit.inRange(point2.x, point2.y)) continue;
            return hardwareUnit;
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Point point2 = this.getLogicalMousePosition(point);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.showPopup(point.x, point.y);
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            HardwareUnit[] hardwareUnitArray = this.mediator.getAllUnits();
            for (int i = 0; i < hardwareUnitArray.length; ++i) {
                HardwareUnit hardwareUnit = hardwareUnitArray[i];
                if (!hardwareUnit.inRange(point2.x, point2.y)) continue;
                this.mediator.clearSelectedUnits();
                this.mediator.select(hardwareUnit);
                this.repaint();
                return;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.getPoint().move(0, 0);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        Point point = this.getLogicalMousePosition(mouseEvent.getPoint());
        HardwareUnit hardwareUnit = null;
        HardwareUnit[] hardwareUnitArray = this.mediator.getAllUnits();
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            if (!hardwareUnitArray[i].inRange(point.x, point.y)) continue;
            hardwareUnit = hardwareUnitArray[i];
            break;
        }
        if (hardwareUnit == null) {
            if (this.currentKey != 17) {
                this.mediator.clearSelectedUnits();
            }
            this.actionFrom = this.actionTo = point;
            this.actionMode = 2;
            return;
        }
        if (this.currentKey == 17) {
            if (this.mediator.selectedUnit(hardwareUnit)) {
                this.mediator.deselect(hardwareUnit);
            } else {
                this.mediator.select(hardwareUnit);
            }
            return;
        }
        if (this.currentKey == 16) {
            this.mediator.clearSelectedUnits();
            this.mediator.select(hardwareUnit);
            this.actionFrom.x = this.actionTo.x = hardwareUnit.getX();
            this.actionFrom.y = this.actionTo.y = hardwareUnit.getY();
            this.actionMode = 1;
            return;
        }
        if (!this.mediator.selectedUnit(hardwareUnit)) {
            this.mediator.clearSelectedUnits();
            this.mediator.select(hardwareUnit);
        }
        this.actionFrom = point;
        this.mansion = new HauntedMansion(this.mediator.getSelectedUnits(), 128);
        this.actionMode = 3;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point;
        this.actionTo = point = this.getLogicalMousePosition(mouseEvent.getPoint());
        switch (this.actionMode) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int n = this.actionTo.x - this.actionFrom.x;
                int n2 = this.actionTo.y - this.actionFrom.y;
                this.mansion.setOffset(n, n2);
            }
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = this.getLogicalMousePosition(mouseEvent.getPoint());
        HardwareUnit[] hardwareUnitArray = this.mediator.getAllUnits();
        block0 : switch (this.actionMode) {
            case 1: {
                for (int i = 0; i < hardwareUnitArray.length; ++i) {
                    HardwareUnit hardwareUnit = hardwareUnitArray[i];
                    if (this.mediator.selectedUnit(hardwareUnit) || !hardwareUnit.inRange(point.x, point.y)) continue;
                    this.mediator.getSelectedUnits()[0].connect(hardwareUnit);
                    this.mediator.clearSelectedUnits();
                    this.mediator.select(hardwareUnit);
                    break block0;
                }
                break;
            }
            case 2: {
                int n = Math.min(this.actionFrom.x, this.actionTo.x);
                int n2 = Math.min(this.actionFrom.y, this.actionTo.y);
                int n3 = Math.abs(this.actionFrom.x - this.actionTo.x);
                int n4 = Math.abs(this.actionFrom.y - this.actionTo.y);
                for (int i = hardwareUnitArray.length - 1; i >= 0; --i) {
                    HardwareUnit hardwareUnit = hardwareUnitArray[i];
                    int n5 = hardwareUnit.getX();
                    int n6 = hardwareUnit.getY();
                    if (n > n5 || n5 > n + n3 || n2 > n6 || n6 > n2 + n4) continue;
                    if (this.mediator.selectedUnit(hardwareUnit)) {
                        this.mediator.deselect(hardwareUnit);
                        continue;
                    }
                    this.mediator.select(hardwareUnit);
                }
                break;
            }
            case 3: {
                HardwareUnit[] hardwareUnitArray2 = this.mansion.bodyList.toArray(new HardwareUnit[this.mansion.bodyList.size()]);
                for (int i = 0; i < hardwareUnitArray2.length; ++i) {
                    Point point2 = this.mansion.getPosition(hardwareUnitArray2[i]);
                    this.mediator.setValue(hardwareUnitArray2[i].appearance(), "x", Integer.toString(point2.x));
                    this.mediator.setValue(hardwareUnitArray2[i].appearance(), "y", Integer.toString(point2.y));
                }
                this.mansion = null;
            }
        }
        this.actionMode = 0;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.onUnit(mouseEvent.getPoint()) != null) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            this.keyPressed(keyEvent);
        } else if (keyEvent.getID() == 402) {
            this.keyReleased(keyEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.currentKey = keyEvent.getKeyCode();
        if (this.actionMode != 0) {
            return;
        }
        switch (this.currentKey) {
            case 74: {
                this.moveDownUnits(this.mediator.getSelectedUnits());
                break;
            }
            case 75: {
                this.moveUpUnits(this.mediator.getSelectedUnits());
                break;
            }
            case 76: {
                this.moveRightUnits(this.mediator.getSelectedUnits());
                break;
            }
            case 72: {
                this.moveLeftUnits(this.mediator.getSelectedUnits());
                break;
            }
            case 89: {
                this.mediator.copyUnits(this.mediator.getSelectedUnits());
                break;
            }
            case 80: {
                this.mediator.pasteUnits();
                break;
            }
            case 88: {
                HardwareUnit[] hardwareUnitArray = this.mediator.getSelectedUnits();
                this.mediator.copyUnits(hardwareUnitArray);
                this.mediator.deleteUnits(hardwareUnitArray);
                break;
            }
            case 87: {
                int n = this.mediator.getUnitsCount();
                if (n == 0) break;
                HardwareUnit hardwareUnit = this.mediator.getAllUnits()[n - 1];
                this.mediator.clearSelectedUnits();
                this.mediator.select(hardwareUnit);
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.actionMode == 2) {
            this.mediator.clearSelectedUnits();
            return;
        }
        this.actionFrom = this.actionTo = new Point(0, 0);
        this.currentKey = 48;
        this.actionMode = 0;
        this.repaint();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void moveUpUnits(HardwareUnit[] hardwareUnitArray) {
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            int n = hardwareUnit.getX();
            int n2 = hardwareUnit.getY();
            this.mediator.setValue(hardwareUnit.appearance(), "x", Integer.toString(n));
            this.mediator.setValue(hardwareUnit.appearance(), "y", Integer.toString(n2 - 1));
        }
    }

    private void moveDownUnits(HardwareUnit[] hardwareUnitArray) {
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            int n = hardwareUnit.getX();
            int n2 = hardwareUnit.getY();
            this.mediator.setValue(hardwareUnit.appearance(), "x", Integer.toString(n));
            this.mediator.setValue(hardwareUnit.appearance(), "y", Integer.toString(n2 + 1));
        }
    }

    private void moveLeftUnits(HardwareUnit[] hardwareUnitArray) {
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            int n = hardwareUnit.getX();
            int n2 = hardwareUnit.getY();
            this.mediator.setValue(hardwareUnit.appearance(), "x", Integer.toString(n - 1));
            this.mediator.setValue(hardwareUnit.appearance(), "y", Integer.toString(n2));
        }
    }

    private void moveRightUnits(HardwareUnit[] hardwareUnitArray) {
        for (int i = 0; i < hardwareUnitArray.length; ++i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            int n = hardwareUnit.getX();
            int n2 = hardwareUnit.getY();
            this.mediator.setValue(hardwareUnit.appearance(), "x", Integer.toString(n + 1));
            this.mediator.setValue(hardwareUnit.appearance(), "y", Integer.toString(n2));
        }
    }

    public void paintConnectionLines(Graphics graphics) {
        graphics.setColor(Color.black);
        HardwareUnit[] hardwareUnitArray = this.mediator.getAllUnits();
        for (int i = hardwareUnitArray.length - 1; i >= 0; --i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            int n = (int)((double)(hardwareUnit.getX() * this.scale) / 100.0);
            int n2 = (int)((double)(hardwareUnit.getY() * this.scale) / 100.0);
            HardwareUnit[] hardwareUnitArray2 = hardwareUnit.getConnectedUnitList();
            for (int j = 0; j < hardwareUnitArray2.length; ++j) {
                graphics.drawLine(n, n2, (int)((double)(hardwareUnitArray2[j].getX() * this.scale) / 100.0), (int)((double)(hardwareUnitArray2[j].getY() * this.scale) / 100.0));
            }
        }
        if (this.actionMode == 1) {
            graphics.drawLine((int)((double)(this.actionFrom.x * this.scale) / 100.0), (int)((double)(this.actionFrom.y * this.scale) / 100.0), (int)((double)(this.actionTo.x * this.scale) / 100.0), (int)((double)(this.actionTo.y * this.scale) / 100.0));
        }
    }

    public void paintUnits(Graphics graphics) {
        graphics.setColor(Color.black);
        HardwareUnit[] hardwareUnitArray = this.mediator.getAllUnits();
        for (int i = hardwareUnitArray.length - 1; i >= 0; --i) {
            HardwareUnit hardwareUnit = hardwareUnitArray[i];
            int n = (int)((double)(hardwareUnit.getWidth() * this.scale) / 100.0);
            int n2 = (int)((double)(hardwareUnit.getHeight() * this.scale) / 100.0);
            int n3 = (int)((double)(hardwareUnit.getX() * this.scale) / 100.0 - (double)(n / 2));
            int n4 = (int)((double)(hardwareUnit.getY() * this.scale) / 100.0 - (double)(n2 / 2));
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            int n5 = n3 + (n - fontMetrics.stringWidth(hardwareUnit.getID())) / 2;
            int n6 = n4 + n2 + fontMetrics.getHeight();
            graphics.drawString(hardwareUnit.getID(), n5, n6);
            graphics.drawImage(hardwareUnit.getImage(), n3, n4, n, n2, null);
            if (!this.mediator.selectedUnit(hardwareUnit)) continue;
            graphics.drawRect(n3, n4, n - 1, n2 - 1);
        }
    }

    public void paintGhosts(Graphics graphics) {
        if (this.actionMode != 3) {
            return;
        }
        graphics.setColor(new Color(128, 128, 128));
        Ghost[] ghostArray = this.mansion.getGhosts();
        for (int i = ghostArray.length - 1; i >= 0; --i) {
            Ghost ghost = ghostArray[i];
            int n = (int)((double)(ghost.size.width * this.scale) / 100.0);
            int n2 = (int)((double)(ghost.size.height * this.scale) / 100.0);
            int n3 = (int)((double)(ghost.position.x * this.scale) / 100.0 - (double)(n / 2));
            int n4 = (int)((double)(ghost.position.y * this.scale) / 100.0 - (double)(n2 / 2));
            graphics.drawImage(ghost.image, n3, n4, n, n2, null);
            graphics.drawRect(n3, n4, n - 1, n2 - 1);
        }
    }

    public void paintGhostLines(Graphics graphics) {
        if (this.actionMode != 3) {
            return;
        }
        graphics.setColor(new Color(128, 128, 128));
        Ghost[] ghostArray = this.mansion.getGhosts();
        for (int i = ghostArray.length - 1; i >= 0; --i) {
            Ghost ghost = ghostArray[i];
            int n = (int)((double)(ghost.position.x * this.scale) / 100.0);
            int n2 = (int)((double)(ghost.position.y * this.scale) / 100.0);
            for (int j = 0; j < ghost.connectingPoints.size(); ++j) {
                int n3 = (int)((double)(ghost.connectingPoints.get((int)j).x * this.scale) / 100.0);
                int n4 = (int)((double)(ghost.connectingPoints.get((int)j).y * this.scale) / 100.0);
                graphics.drawLine(n, n2, n3, n4);
            }
        }
    }

    public void paintSelectionRectangle(Graphics graphics) {
        if (this.actionMode == 2) {
            graphics.setColor(new Color(0, 64, 255, 16));
            int n = (int)((double)(Math.min(this.actionFrom.x, this.actionTo.x) * this.scale) / 100.0);
            int n2 = (int)((double)(Math.min(this.actionFrom.y, this.actionTo.y) * this.scale) / 100.0);
            int n3 = (int)((double)(Math.abs(this.actionFrom.x - this.actionTo.x) * this.scale) / 100.0);
            int n4 = (int)((double)(Math.abs(this.actionFrom.y - this.actionTo.y) * this.scale) / 100.0);
            graphics.fillRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(new Color(0, 100, 255));
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintComponent(Graphics graphics) {
        if (this.offimage == null) {
            this.offimage = this.createImage(1024, 768);
            this.offg = this.offimage.getGraphics();
            this.offg.setFont(new Font("Dialog", 1, 12));
        }
        this.offg.setColor(Color.white);
        this.offg.fillRect(0, 0, 1024, 768);
        this.paintConnectionLines(this.offg);
        this.paintGhostLines(this.offg);
        this.paintUnits(this.offg);
        this.paintGhosts(this.offg);
        this.paintSelectionRectangle(this.offg);
        graphics.drawImage(this.offimage, 0, 0, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Add Init File")) {
            this.mediator.addInitFile(this.mediator.getSelectedUnits()[0], "./init_file", "0");
        } else if (string.equals("Cut")) {
            this.mediator.copyUnits(this.mediator.getSelectedUnits());
            this.mediator.deleteUnits(this.mediator.getSelectedUnits());
        } else if (string.equals("Copy")) {
            this.mediator.copyUnits(this.mediator.getSelectedUnits());
        } else if (string.equals("Paste")) {
            this.mediator.pasteUnits();
        } else if (string.equals("Delete")) {
            this.mediator.deleteUnits(this.mediator.getSelectedUnits());
        } else if (string.equals("Select All")) {
            this.mediator.selectAll();
        }
    }
}

